var gl = new WebGL2RenderingContext(); //enable WebGL 2 partial support

var images = {};

var tick= 0.075;
var beat = 6*tick;
var pattern = 8*beat;


var particleMesh = void null;
	var fftImage = new Image();
	
	function additive(animation) {
       glPushMatrix();     

    gl.enable(gl.BLEND);
   gl.blendFunc(gl.ONE, gl.ONE);
	    glPopMatrix();
	}

		function normal(animation) {
       glPushMatrix();     

		gl.enable(gl.BLEND);
 //   gl.blendFunc(gl.ONE, gl.ONE);
	    glPopMatrix();
	}
	
	function blendAdd(animation) {

		gl.enable(gl.DEPTH_TEST);
		gl.depthMask(0);
		gl.enable(gl.BLEND);
		gl.blendFunc(gl.ONE, gl.ONE);
	}

	function blendNormal(animation) {

		gl.enable(gl.BLEND);
		gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);

	}


Demo.prototype.init = function()
{
	Sync.addSync(
	[
		 { "name":"Sync1", "type":"rocket" },
		 { "name":"Sync2", "type":"rocket" }
	]);
    var start = 0;
    var duration = 60*20;
    var layer = 1; 


	fftImage.load("fft0");
	
	//fbot
	this.createFBO(0,20000,"fbo20k");
	this.createFBO(20001,40000,"fbo40k");
	
	this.loader.addAnimation ([
	{
		 "start": 0, "duration": 8888
	,"image": ["fbo20k.color.fbo", "fft0"]
		,"layer": 40107
				,"shader":{"name":["fftdistort.fs"]}

	}]);


	
		this.loader.addAnimation ([
	{
		 "start": 0, "duration": 8888
	,"image": ["fbo40k.color.fbo"]
		,"layer": 50105
			 ,"position":[{"x":640,"y":150}]
		,"scale":[{"uniform3d":1.1}]
		,"angle": [{"degreesZ":"{return Math.sin(getSceneTimeFromStart())}"}]
	,"runFunction": "{normal(animation);}"
				,"shader":{"name":["blur.fs"]}

	}]);
	
	    this.loader.addAnimation({
         "start": start, "duration": duration,"layer": 10000
        ,"image": "small_transparent.png"
		
		,"scale":[{
			"uniform3d":"{return 1+.15*Sync.getSyncValue('Sync1');}"
			}]
		,"color":[{"r":0,"g":0,"b":0,"a":"{return 255-5*Sync.getSyncValue('Sync1');}"}]
    });


	    this.loader.addAnimation({
         "start": start, "duration": duration,"layer": 11
        ,"image": "fcf_bg.png"
			,"runFunction": "{normal(animation);}"
		,"scale":[{"uniform3d":2.55}]
     ,"shader":{
            "name":["tunnel.fs"],
            "variable":[
                  {"name":"tim3","value":["{return 1*getSceneTimeFromStart()}"]}
			]
        }
    });
	

	
	

	
		this.loader.addAnimation([{
      "start": 0, "duration": 300,"layer": 10000
      ,"runFunction": "{blendAdd(animation);}"    
	  }]);
	

    this.loader.addAnimation([{
         "start": 0, "duration": 300
		 ,"object":"sphere.obj"
         ,"layer": 10001
		 ,"position":[{"z":-2.55}]
		,"scale":[{"uniform3d":0.2}]
	    ,"shader":{"name":["particles.vs","particles.gs","particles.fs"]}
	    //,"angle": [{"degreesY":"{return getSceneTimeFromStart()*5}","degreesZ":"{return getSceneTimeFromStart()*5}"}]
		,"angle": [{"degreesX":"{return getSceneTimeFromStart()*5}"}]
    }]);
	

	  
	  			    this.loader.addAnimation({
         "start": 4*pattern, "duration": 120*pattern,"layer": 31000
        ,"image": "farjan.png"
		,"scale":[{"uniform3d":0.5}]
		,"color":[{"r":0,"g":0,"b":0,"a":255}]
      		 ,"position":[{"y":375,"x":"{return 310+15*Math.sin(6*getSceneTimeFromStart());}"}]  
    });

		this.loader.addAnimation([{
      "start": 0, "duration": 300,"layer": 30999
      ,"runFunction": "{blendNormal(animation);}"    
	  }]);
	  
	  			    this.loader.addAnimation({
         "start": 4*pattern, "duration": 120*pattern,"layer": 31000
        ,"image": "bridge.png"
		,"scale":[{"x":1.5,"y":0.3}]
		,"color":[{"r":0,"g":0,"b":0,"a":255}]
      		 ,"position":[{"y":222,"x":640}]  
			 	 ,"shader":{
            "name":["scroll.fs"],
            "variable":[
                  {"name":"tim3","value":["{return 1.5*getSceneTimeFromStart()}"]}
			]
        }
    });
	
	
/*
    this.loader.addAnimation({
         "start": start, "duration": duration,"layer": 10000
        ,"image": "fft0"
	
		,"shader":{"name":["singleblockfft.fs"]}

    });
*/
}

Demo.prototype.createFBO = function (startLayer, endLayer, name)
{
	   	this.loader.addAnimation ([
	{
	"start": 0, "duration": 99999
	,"layer": startLayer
	,"fbo":{"name":name,"action":"begin","storeDepth":true}
	}
	]);
	
	this.loader.addAnimation ([
	{
	"start": 0, "duration": 99999
	,"layer": endLayer,"fbo":{"name":name,"action":"unbind"}
	}
	]);
	
}