// This is an example effect bundled with Spindle
// http://www.linusakesson.net/software/spindle/

#include <stdio.h>

int map[64] = {
	0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
	0x29, 0x54, 0x15, 0x16, 0x17, 0x18, 0x59, 0x32,
	0x28, 0x13, 0x06, 0x27, 0x28, 0x09, 0x1a, 0x33,
	0x27, 0x12, 0x25, 0x20, 0x21, 0x2a, 0x1b, 0x34,
	0x26, 0x11, 0x24, 0x23, 0x22, 0x2b, 0x1c, 0x35,
	0x25, 0x10, 0x0f, 0x2e, 0x2d, 0x0c, 0x1d, 0x36,
	0x24, 0x63, 0x22, 0x21, 0x20, 0x1f, 0x5e, 0x37,
	0x3f, 0x3e, 0x3d, 0x3c, 0x3b, 0x3a, 0x39, 0x38,
};

int main() {
	int i, x, y, acc;

	fputc(0x00, stdout);
	fputc(0x30, stdout);

	for(i = 0; i < 32; i++) {
		for(y = 0; y < 8; y++) {
			acc = 0;
			if(y > 0 && y < 7) {
				for(x = 0; x < 8; x++) {
					acc <<= 1;
					if(map[y * 8 + x] < i * 1.5) acc |= 1;
				}
			}
			acc &= 0x7e;
			fputc(acc ^ 255, stdout);
		}
	}
	for(i = 32; i >= 0; i--) {
		for(y = 0; y < 8; y++) {
			acc = 0;
			if(y > 0 && y < 7) {
				for(x = 0; x < 8; x++) {
					acc <<= 1;
					if(map[y * 8 + x] < i * 1.5) acc |= 1;
				}
			}
			acc &= 0x7e;
			fputc(acc ^ 255, stdout);
		}
	}

	return 0;
}
