let lienzo;
let cuadricula = {}

function setup() {
  frameRate(50)
  lienzo = createCanvas(700, 700,'WEBGL');
  lienzo.parent('canvas')
  cantidad = 15
  tamano = width / cantidad
  
  for(j=0;j< cantidad;j++){
    for(k=0;k< cantidad;k++){
      cuadricula['x'+j+'y'+k] = new Cuadrito(tamano,j,k) 
    }
  }
  
  pintc1 = new AntCuadro(cuadricula, cantidad -1, '#d81b60','Turing','brown')
  pintc2 = new AntCuadro(cuadricula, cantidad -1, '#fbc02d','Moore','pink')
  pintc3 = new AntCuadro(cuadricula, cantidad -1, '#039be5','Minsky','white')
  pintc4 = new AntCuadro(cuadricula, cantidad -1, '#aeea00','Wang','pink')
  pintc5 = new AntCuadro(cuadricula, cantidad -1, '#009624','Chomsky','brown')

}

function draw() {
  background(220);

  Object.keys(cuadricula).forEach(function(e){
    cuadricula[e].crear()
  })
  
  pintc1.seleccionar()
  pintc1.maxCuadros()

  pintc2.seleccionar()
  pintc2.maxCuadros()

  pintc3.seleccionar()
  pintc3.maxCuadros()
  
  pintc4.seleccionar()
  pintc4.maxCuadros()
	
  pintc5.seleccionar()
  pintc5.maxCuadros()  
}

class Cuadrito{
  constructor(tam, px,py){
    this.tam = tam
    this.px = px
    this.py = py
    this.estado = 0
    this.color = 255
  }
  
  crear(){
    let tam = this.tam
    let px = this.px
    let py = this.py
    
    fill(this.color)
    stroke(this.color)
    rect(tam*px,tam*py,tam,tam)
  }  
}

class AntCuadro{
  
  constructor(objeto,dimeciónCuadricula,color, nombre,tnoise){
    this.objeto = objeto
    this.llaves = Object.keys(objeto)
    this.dimeciónCuadricula = dimeciónCuadricula
    this.pintados = []
    this.div = createDiv(); 
    this.divVelocidad = createDiv(); 
    this.divColor = createDiv(); 
    this.divExtencion = createDiv(); 
    this.divNoise = createDiv(); 
    this.titulo = createP(nombre);
    this.pVelocidad = createP('Velocidad');
    this.pColor = createP('Color');
    this.pExtension = createP('Extensión');
    this.color = createColorPicker(color);
    this.velocidad = createSlider(2, 17, 8)
    this.extension = createSlider(1, 35, 15)
    this.huella = createSelect();
    this.huella.option('Con huella', false);
    this.huella.option('Sin huella', true);
    this.pNoise = createP('Noise');
    this.volumen = createSlider(0, 20, 10)
    this.decayTime = createSlider(1, 20, 10)
    this.susRadio = createSlider(0, 10, 5)
    this.releasTime = createSlider(1, 20, 10)

    this.div.id(nombre.toLowerCase())
    this.divVelocidad.id('velocidad')
    this.divColor.id('color')
    this.divExtencion.id('extension')
    this.divNoise.id('noise')

    this.div.class('cuadro-control')
    this.titulo.class('titulos')
    this.pVelocidad.class('velocidades')
    this.pColor.class('colores')
    this.pExtension.class('extensiones')

    this.div.parent('controles')
    this.titulo.parent(this.div)
    this.divVelocidad.parent(this.div)
    this.divColor.parent(this.div)
    this.divExtencion.parent(this.div)
    this.divNoise.parent(this.div)

    this.pVelocidad.parent(this.divVelocidad)
    this.velocidad.parent(this.divVelocidad)
    this.pColor.parent(this.divColor)
    this.color.parent(this.divColor)
    this.pExtension.parent(this.divExtencion)
    this.extension.parent(this.divExtencion)
    this.huella.parent(this.divExtencion)
    this.pNoise.parent(this.divNoise)
    this.volumen.parent(this.divNoise)
    this.decayTime.parent(this.divNoise)
    this.susRadio.parent(this.divNoise)
    this.releasTime.parent(this.divNoise)


    this.noise = new p5.Noise(tnoise)
    this.noise.start();
    this.noise.amp(0);
    this.env = new p5.Env();


  }
  pun() {
    let volumen = this.volumen.value() * 0.1
    let attackTime = map(this.extension.value(),1, 35, 0.01, 0.25 )
    let decayTime = this.decayTime.value() * 0.01
    let susRadio = this.susRadio.value() * 0.1
    let releasTime = this.releasTime.value() * 0.01

    if(this.volumen.value() == 0){
      volumen = 0.0001
    }
    this.env.setRange( volumen);
    this.env.setADSR( attackTime, decayTime, susRadio, releasTime);
    this.env.play(this.noise);
  } 
  seleccionar(){
    let cuadricula = this.pintados
    let dimeciónCuadricula = this.dimeciónCuadricula
    let objeto = this.objeto
    let llaveSeleccionada
    let cuadro
    let color = this.color
    let velocidad = this.velocidad
    let anteriorCuadro
    let px
    let py

    if(frameCount % velocidad.value() == 0){
      if(cuadricula.length == 0){
        llaveSeleccionada = this.llaves[Math.round(random(0,this.llaves.length - 1))]

      }else{
        anteriorCuadro = objeto[cuadricula[cuadricula.length -1]]
        px = anteriorCuadro.px
        py = anteriorCuadro.py
        
        if(cuadricula.length - 1 <= this.dimeciónCuadricula * this.dimeciónCuadricula){
          do{
            do{
              do{
                px = px + Math.round(random(-1,1))
              }while(px < 0 || px > dimeciónCuadricula)
              if(px == anteriorCuadro.px){
                do{
                  py = py + Math.round(random(-1,1))
                }while(py == anteriorCuadro.py || py < 0 || py > dimeciónCuadricula)
              }
              llaveSeleccionada = 'x'+px+'y'+py
            }while(llaveSeleccionada == cuadricula[cuadricula.length - 1])
          }while(cuadricula.includes(llaveSeleccionada))
        }    
      }
      cuadricula.push(llaveSeleccionada)
      cuadro = objeto[llaveSeleccionada]
      cuadro.color = color.color()
      if(frameCount % 4 == 0){
        this.pun()
      }
    }
  }
        
  maxCuadros(){
    let extension = this.extension
    let cuadricula = this.pintados
    let cuadro
    if(cuadricula.length >= extension.value() + 1){
      if( this.huella.value() == 'true'){
        cuadro = this.objeto[cuadricula[0]]
        cuadro.color = 255

      }
      
      cuadricula.shift()
    }
  }
}
