@echo off
setlocal EnableExtensions DisableDelayedExpansion

:: _run_intro, v1.00 (c) 2020 Jin X (t.me/jinxonik, jin_x@list.ru)
:: Batch to launch intro via DOSBox.
::
:: Intro filename and screen mode are detected based on batch filename.
:: Batch filename should be "[_run.]INTRONAME[.EXT].[dosbox_][SCRMODE].bat" (where "SCRMODE" is "full"* or "win"*, default "EXT" is "com"),
:: e.g. "_run.myintro.dosbox_windowed.bat", "_run.myintro.exe.fullscreen.bat", "_run.myintro.com.dosbox.bat", "myintro.exe.dosbox_win.bat", "myintro.fullscr.bat", "myintro.bat".
:: DOSBox config should be written to "intr0.conf" or "dosbox.conf", where "intr0" is intro filename without com/exe/bat ext ("fullscreen=" option can be absent).
:: Use /? command line parameter for help.


:: User settings: DOSBox extra options, versions and executable filename paths (up to 6 versions and up to 6*5 paths with suffixes ""/"a"/"b"/"c"/"d" are supported)
set dosboxextraopt=-exit

set dosboxver1=0.74-3
set dosboxver=0.74

if not "%dosboxver1%" == "" (call :SetDefPaths 1 "-%dosboxver1%")
if not "%dosboxver2%" == "" (call :SetDefPaths 2 "-%dosboxver2%")
if not "%dosboxver3%" == "" (call :SetDefPaths 3 "-%dosboxver3%")
if not "%dosboxver4%" == "" (call :SetDefPaths 4 "-%dosboxver4%")
if not "%dosboxver5%" == "" (call :SetDefPaths 5 "-%dosboxver5%")
if not "%dosboxver6%" == "" (call :SetDefPaths 6 "-%dosboxver6%") else (call :SetDefPaths 6)
goto Start

:: Set default DOSBox paths
:SetDefPaths
set "dosboxpath%~1=DOSBox%~2\DOSBox.exe"
set "dosboxpath%~1a=%ProgramFiles(x86)%\DOSBox%~2\DOSBox.exe"
set "dosboxpath%~1b=%ProgramFiles%\DOSBox%~2\DOSBox.exe"
exit /b


:Start
:: Detect intro executable filename and screen mode (depending on batch filename)
set "batfile=%~nx0"
set defintro=
set part1=
set part2=
set part3=
set part4=
for /f "tokens=1-4 delims=." %%i in ("%batfile%") do (set "part1=%%i"&set "part2=%%j"&set "part3=%%k"&set "part4=%%l")
call :SetDefIntroAndScrMode %part1% %part2% %part3% %part4%

:: Show help (if /? parameter is specified)
if "%~1%" == "/?" (
  echo Usage:
  echo   "%batfile%" [/win^|/full] [/c conffile] [/d dosbox.exe] [intro.com]
  echo.
  echo   /win - windowed mode%windeftext%
  echo   /full - fullscreen mode%fulldeftext%
  echo   /c conffile - DOSBox config file ^(default is "intr0.conf" or "dosbox.conf", where "intr0" is intro filename without com/exe/bat ext^)
  echo   /d dosbox.exe - path to DOSBox executable file
  echo   intro.com - intro executable filename ^(default ext is ".com"^), must be the last parameter ^(default is "%defintro%" for this batch^)
  echo.
  pause
  exit /b
)

:: Process command line options
set srcconf=
set dosbox=
:NextOpt
if /i "%~1" == "/full" (set fullscreen=true
) else if /i "%~1" == "/win" (set fullscreen=false
) else if /i "%~1" == "/c" (set "srcconf=%~2"&shift
) else if /i "%~1" == "/d" (set "dosbox=%~2"&shift
) else goto NoOpt
shift
goto NextOpt
:NoOpt

:: Get executable filename
if "%~1" == "" (set "intro=%defintro%") else (
  set "intro=%~1"
)
if /i not "%intro:~-4%" == ".com" (if /i not "%intro:~-4%" == ".exe" (if /i not "%intro:~-4%" == ".bat" (set "intro=%intro%.com")))
if not exist "%intro%" (
  echo Intro executable "%intro%" is not found :^(
  goto EoE
)

:: Get DOSBox executable
if not "%dosbox%" == "" goto CheckDOSBox
call :CheckDOSBoxPaths "%dosboxpath1%" "%dosboxpath1a%" "%dosboxpath1b%" "%dosboxpath1c%" "%dosboxpath1d%"
call :CheckDOSBoxPaths "%dosboxpath2%" "%dosboxpath2a%" "%dosboxpath2b%" "%dosboxpath2c%" "%dosboxpath2d%"
call :CheckDOSBoxPaths "%dosboxpath3%" "%dosboxpath3a%" "%dosboxpath3b%" "%dosboxpath3c%" "%dosboxpath3d%"
call :CheckDOSBoxPaths "%dosboxpath4%" "%dosboxpath4a%" "%dosboxpath4b%" "%dosboxpath4c%" "%dosboxpath4d%"
call :CheckDOSBoxPaths "%dosboxpath5%" "%dosboxpath5a%" "%dosboxpath5b%" "%dosboxpath5c%" "%dosboxpath5d%"
call :CheckDOSBoxPaths "%dosboxpath6%" "%dosboxpath6a%" "%dosboxpath6b%" "%dosboxpath6c%" "%dosboxpath6d%"

:CheckDOSBox
if not exist "%dosbox%" (
  echo DOSBox executable is not found :^(
  goto EoE
)

:: Get config filename
set "introsrcconf=%intro:~0,-4%.conf"
if /i not "%intro:~-4%" == ".com" (if /i not "%intro:~-4%" == ".exe" (if /i not "%intro:~-4%" == ".bat" (set "introsrcconf=%intro%.conf")))
if "%srcconf%" == "" (
  set "srcconf=%introsrcconf%"
  set conffiletext=s "%introsrcconf%" and "dosbox.conf" are
  if not exist "%introsrcconf%" (set "srcconf=dosbox.conf")
) else (
  set conffiletext= "%srcconf%" is
)

if not exist "%srcconf%" (
  echo DOSBox config file%conffiletext% not found :^(
  goto EoE
)
set tempconf=
set "conffile=%srcconf%"

:: Create temp config file
if "%fullscreen%" == "" goto Launch
set "tempconf=%TEMP%\dosbox.$temp$.conf"
set "conffile=%tempconf%"
set error=0
if exist "%tempconf%" (del "%tempconf%" < nul > nul)
if exist "%tempconf%" (set error=1) else (
  copy /y "%srcconf%" "%tempconf%" > nul
  if not exist "%tempconf%" (set error=1)
)
if %error% == 1 (
  echo Error creating temp DOSBox config file "%tempconf%" :^(
  goto EoE
)

echo.>>"%tempconf%"
echo>> "%tempconf%" [sdl]
echo>> "%tempconf%" fullscreen=%fullscreen%

:: Launch intro and delete temp config file
:Launch
call "%dosbox%" -conf "%conffile%" %dosboxextraopt% "%intro%"
if not "%tempconf%" == "" (del "%tempconf%" < nul > nul)
exit /b


:: Set default intro name and screen mode
:SetDefIntroAndScrMode %1 %2 %3 %4
if /i "%1" == "_run" shift
set "defintro=%1"
if /i "%2" == "com" (set "defintro=%1.%2"&shift
) else if /i "%2" == "exe" (set "defintro=%1.%2"&shift
) else if /i "%2" == "bat" (if not "%3" == "" (set "defintro=%1.%2"&shift))
set fullscreen=
set windeftext=
set fulldeftext=
set "suffix=%2"
if not "%suffix:win=%" == "%suffix%" (set fullscreen=false&set "windeftext= ^(default for this batch^)")
if not "%suffix:full=%" == "%suffix%" (set fullscreen=true&set "fulldeftext= ^(default for this batch^)")
exit /b

:: Check DOSBox paths
:CheckDOSBoxPaths %1
if "%~1" == "" exit /b
if not exist "%dosbox%" (set "dosbox=%~1")
shift
goto CheckDOSBoxPaths

:: End of error
:EoE
echo Run "%batfile%" /? to see help.
pause
