/*
 * Some raymarching by rimina
 */

THREE.Kaleido2 = {

	uniforms: {
		"uNear": { type: "f", value: 0 },
		"uFar":   { type: "f", value: 0 },
		"uRo": { type: "v3", value: new THREE.Vector3(0, 0, 0)},
		"uRd": { type: "v3", value: new THREE.Vector3(0, 0, 0)},
		"uTime" : { type: "f", value: 0.0},
		"uHb" : {type: "f", value: 0.0},
		"uResolution" : {type: "v2", value: new THREE.Vector2(0, 0)},
		"uFOV" : {type : "f", value: 50.0}
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [
		"#include <packing>",
        "uniform float uNear;",
		"uniform float uFar;",
		"uniform vec3 uRo;",
		"uniform vec3 uRd;",

		"uniform float uTime;",
		"uniform float uHb;",
		"uniform vec2 uResolution;",
		"uniform float uFOV;",

        "varying vec2 vUv;",

        "#define STEPS 60",
		"#define EPSILON 0.01",
		"#define FAR 200.0",

		"vec3 glow = vec3(0.0);",

		//Distance functions from Mercury's SDF library
		//http://mercury.sexy/hg_sdf/

		// Maximum/minumum elements of a vector
		"float vmax3(vec3 v) {",
			"return max(max(v.x, v.y), v.z);",
		"}",

		"float fSphere(vec3 p, float r) {",
			"return length(p) - r;",
		"}",

		// Box: correct distance to corners
		"float fBox(vec3 p, vec3 b) {",
			"vec3 d = abs(p) - b;",
			"return length(max(d, vec3(0))) + vmax3(min(d, vec3(0)));",
		"}",

		"void rot(inout vec2 p, float a){",
			"p = cos(a)*p + sin(a)*vec2(p.y, -p.x);",
		"}",

		// 3D noise function (IQ)
		"float noise(vec3 p){",
			"vec3 ip = floor(p);",
		    "p -= ip;",
		    "vec3 s = vec3(7.0,157.0,113.0);",
		    "vec4 h = vec4(0.0, s.yz, s.y+s.z)+dot(ip, s);",
		    "p = p*p*(3.0-2.0*p);",
		    "h = mix(fract(sin(h)*43758.5), fract(sin(h+s.x)*43758.5), p.x);",
		    "h.xy = mix(h.xz, h.yw, p.y);",
		    "return mix(h.x, h.y, p.z);",
		"}",

		"vec2 scene(vec3 p){",
			"vec3 pp = p;",

			"float safe = fSphere(p, 10.0);",
			
			"float n = noise((p)*0.5);",
			"for(int i = 0; i < 5; ++i){",
				"rot(pp.xy, uTime);",
				"rot(pp.xz, uHb);",
				"pp = abs(pp) - vec3(20.0);",
				"rot(pp.xy, uHb*0.5);",
			"}",

			"float a = fSphere(pp, 5.0)-n*2.0;",
			"float b = fBox(pp, vec3(4.0, 8.0, FAR));",

		    "vec3 g = vec3(0.8, 0.3, 0.1) * 0.01 / (0.01+abs(a));",
		    "g += vec3(0.5, 0.2, 0.8) * 0.03 / (0.01+abs(b));",
		    "g *= 0.5;",
		    "glow += g;",

		    "b = max(abs(b), 0.9);",

		    "float obj = min(a, b);",
		    "obj = max(obj, -safe);",
			"return vec2(obj, 1.0);",
		"}",

		"vec2 march(vec3 ro, vec3 rd){",
		    "float t = 0.0;",
		    "vec3 p = ro;",
		    "for(int i = 0; i < STEPS; ++i){",
		        "float d = scene(p).x;",
		        "p += rd*d;",
		        "t += d;",
		        
		        "if(d < EPSILON || t >= FAR){",
		            "break;",
		        "}",
		    "}",
		    "p = ro+rd*t;",
    		"float id = scene(p).y;",
		    "return vec2(t, id);",
		"}",

        "void main() {",

        	"vec2 q = -1.0+2.0*vUv;",
    		"q.x *= uResolution.x/uResolution.y;",

            "vec3 color = vec3(0.0);",

            "vec3 z = normalize(uRd - uRo);",
            "vec3 x = normalize(cross(z, vec3(0.0, 1.0, 0.0)));",
    		"vec3 y = normalize(cross(x, z));",
    		"vec3 rd = normalize(mat3(x, y, z)*vec3(q, 1.0/radians(uFOV)));",

            "vec2 t = march(uRo, rd);",

            "vec3 p = uRo + rd*t.x;",
    		"color += glow;",

            "gl_FragColor = vec4(color, 1.0);",
        "}"

	].join("\n")

};
