var Spheric = function(){
    PartBase.call(this);
    this.setEdgeDetection();
    this.setBloom(4);

    this.texture = TDEMO.TEXTURES.getTextures().turkki2;
    var material = new THREE.MeshBasicMaterial({map: this.texture, side: THREE.BackSide});
    var geometry = new THREE.BoxGeometry(200, 200, 200);
    this.sphere = new THREE.Mesh(geometry, material);

    this.scene.add(this.sphere);
};


Spheric.prototype = PartBase.prototype.inheritance();

Spheric.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var pos = TDEMO.SYNC.getObjPosition();
    this.sphere.position.x = pos.x;
    this.sphere.position.y = pos.y;
    this.sphere.position.z = pos.z;

    var rot = TDEMO.SYNC.getObjRotation();
    this.sphere.rotation.x = rot.x;
    this.sphere.rotation.y = rot.y;
    this.sphere.rotation.z = rot.z;

    var hb = TDEMO.SYNC.getHeartBeat();
    this.texture.offset.x = hb*1.5;
    this.texture.offset.y = hb;
    this.texture.needsUpdate = true;

    var edges = TDEMO.SYNC.getEdges();
    this.edge.enabled = edges;
};
