var Cubic = function(){
    PartBase.call(this);
    this.setEdgeDetection();
    this.setBloom(4);

    this.texture = TDEMO.TEXTURES.getTextures().turkki;
    var material = new THREE.MeshBasicMaterial({map: this.texture, side: THREE.BackSide});
    var geometry = new THREE.BoxGeometry(200, 200, 200);
    this.box = new THREE.Mesh(geometry, material);

    this.scene.add(this.box);
};


Cubic.prototype = PartBase.prototype.inheritance();

Cubic.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var pos = TDEMO.SYNC.getObjPosition();
    this.box.position.x = pos.x;
    this.box.position.y = pos.y;
    this.box.position.z = pos.z;

    var rot = TDEMO.SYNC.getObjRotation();
    this.box.rotation.x = rot.x;
    this.box.rotation.y = rot.y;
    this.box.rotation.z = rot.z;

    var hb = TDEMO.SYNC.getHeartBeat();
    this.texture.offset.x = hb;
    this.texture.offset.y = -hb;
    this.texture.needsUpdate = true;

    var edges = TDEMO.SYNC.getEdges();
    this.edge.enabled = edges;
};
