#version 450 core

// inputs
layout(location = 0) in vec2 vPos;
layout(location = 1) in vec2 vTexCoord;

// outputs
out vec2 texCoord;
out	vec3 rayOrigin;			// projected onto near plane
out	vec3 rayDirection;		// normalize(g_origin - origin)

// uniforms
uniform mat4  m_Perspective;
uniform vec3  g_origin;
uniform float g_znear;

void main() {
	gl_Position = vec4(vPos, 1.0, 1.0);

	rayOrigin = vec3(
		g_znear * (vPos.x / m_Perspective[0][0]),
		g_znear * (vPos.y / m_Perspective[1][1]),
		g_znear
	);
	rayDirection = normalize(rayOrigin - g_origin);
	texCoord = vTexCoord;
}