#version 450 core

// inputs 
in vec2 texCoord;

// outputs
//layout (location = 0) out fragColor;

// uniforms
uniform sampler2D   t_texture0;
uniform float       g_scale;
uniform float       g_time;


float			gli_scale = 0.3;

float noise(vec2 x) {return fract(3.5277*sin(g_time+dot(x*15.624, x*552.63)));}

float fbm(vec2 x, float H )
{    
    float G = exp2(-H);
    float f = 1.0;
    float a = 1.0;
    float t = 0.0;
    for( int i=0; i<4; i++ )
    {
        t += a*noise(f*x);
        f *= 2.0;
        a *= G;
    }
    return t;
}


#define BLUR_SAMPLES 16

void main(void)
{
  
  	vec2 uv = texCoord-.5;
  	float radius = dot(uv,uv);
  	uv *= (0.9 + 0.3*radius);
 
 	float glx = gli_scale*sin(g_time*7.2)*fbm(vec2(sin(g_time*0.6)), 0.32)*0.02*mod(float(int(uv.y * 20)), 0.4);;
 	float gly = gli_scale*cos(g_time*7.2)*fbm(vec2(sin(g_time*0.1)), 0.38)*0.02*mod(float(int(uv.x * 110)), 0.4);;
 	uv.x += glx;
	uv.y += gly;

	// insert big "LOGICOMA" logo :DDDDDD
	
	vec3 acc  = vec3(0.0);
	vec3 zoom = vec3(1.0, 1.0, 1.0);
	
	for (int i = 0 ; i < BLUR_SAMPLES; i++) {
		zoom *= vec3(0.999, .998, .997);
		acc.r += texture(t_texture0, g_scale*(uv*zoom.r + 0.5)).r;
		acc.g += texture(t_texture0, g_scale*(uv*zoom.g + 0.5)).g;
		acc.b += texture(t_texture0, g_scale*(uv*zoom.b + 0.5)).b;
	}
	//acc = (ivec4(acc * 16.0)) / 16.0;
	vec3 weights = 1*((vec3(glx, gly, glx*gly)-0.5));
	
	acc = mix(mix(acc, vec3(0.0), min(weights, vec3(0.0))), vec3(1.0), max(weights, vec3(0.0)));
	
	// add vingette
	float dim = clamp(1.0 - 2.1*pow(dot(uv, uv), 0.88), 0.0, 1.0);
	
	// noize noize noize
	
	gl_FragColor = vec4((acc.rgb / BLUR_SAMPLES) * dim + 0.1*fbm(uv, 0.1), 1.0);
	
	return;
}



