// modified from https://www.geeks3d.com/20110428/shader-library-swirl-post-processing-filter-in-glsl/

#version 130

uniform sampler2D currentTexture; 
uniform float rt_w;  
uniform float rt_h; 
uniform float center_x;
uniform float center_y;

// Swirl effect parameters
uniform float radius;
uniform float angle;

vec4 PostFX(sampler2D tex, vec2 uv)
{
    vec2 center = vec2(center_x, center_y);
    vec2 texSize = vec2(rt_w, rt_h);
    vec2 tc = uv * texSize;
    tc -= center;
    float dist = length(tc);
    if (dist < radius) 
    {
    float percent = (radius - dist) / radius;
    float theta = percent * percent * angle * 8.0;
    float s = sin(theta);
    float c = cos(theta);
    tc = vec2(dot(tc, vec2(c, -s)), dot(tc, vec2(s, c)));
    }
    tc += center;
    vec3 color = texture2D(currentTexture, tc / texSize).rgb;
    return vec4(color, 1.0);
}

void main (void)
{
    vec2 uv = gl_TexCoord[0].st;
    gl_FragColor = PostFX(currentTexture, uv);
}
