#version 450 core

uniform float ms;
uniform float width;
uniform float height;

// Julia 1 (0.186, 0.588)

// Julia 2 (0.329, 0.505)

//uniform float juliaX = -1.4;
//uniform float juliaY = 0.8;
uniform float juliaXunit = -0.4;
uniform float juliaYunit = 0.8;
uniform float mixunit = 0.0;
uniform float mix2unit = 0.0;
uniform float phoenixXunit = 0.0;
uniform float phoenixYunit = 0.0;

layout(location = 0) out vec4 Color; // out_color must be written in order to see anything

float epsilon = 0.001;

float p = 0.56667;
float q = -0.5;

//float p = 0.000566667 + sin(ms/2000.) * 0.8; // 0 + sin(ms/2000.) * 0.1;
//float q = -1 + cos(ms*0.9/2000.) * 0.5;

vec2 xs, xtemp;

vec2 cmul( vec2 a, vec2 b) {
    return vec2(a.x * b.x - a.y * b.y, 2 * a.x * b.y);
}

vec2 julia_step(vec2 j) {
    vec2 ret = cmul(j, j);
//    ret += vec2(sin(ms*0.0008) - 1.4, sin(ms*0.00073) * 1.8);
    ret += vec2(juliaXunit, juliaYunit);
    return ret;
}

vec2 phoenix_step(vec2 current, vec2 prev) {
    current = cmul(current, current);
    current.x += p + (q * prev.x);
    current.y += q * prev.y;
    return current;
}

vec2 mandelbrot_step(vec2 z, vec2 c) {
    vec2 ret = cmul(z, z);
    ret += c;
    return ret;
}

vec3 palette( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b* cos( 6.28318*(c*t+d) );
}

void main(void)
{
    //    vec2 c = vec2(sin(ms/2000.), sin(ms*0.9/2000.));
    vec2 c = vec2(phoenixXunit, phoenixYunit);
    vec2 uv = vec2(gl_FragCoord.y / height, gl_FragCoord.x / width);
    vec2 puv = c;
    uv -= 0.5;
    uv /= vec2(width/height, 1);

    uv *= 4.;
    //    uv -= vec2(.8, 0.65);
//    uv /= (ms/5000.0);
//    uv += vec2(0.5, 0.5);

    vec2 muv = uv.yx;
    vec2 uv2 = uv;
    vec2 d = uv + vec2(epsilon);
    float traveled = 0.;
    float pTraveled = 0.;
    float traveled2 = 0.;
    float pTraveled2 = 0.;
    float traveled3 = 0.;
    float pTraveled3 = 0.;
    float uvLength = length(uv);

    vec2 t =  vec2(sin(ms*0.0008) * 0.5 - 0.4, sin(ms*0.00013) * 0.78);
    vec2 z = vec2(0.,0.);

    int i = 0;
    vec2 prev = uv;
    while ( i < 200 && length(uv) < 4) {
        i++;
        if (ms < 9000.) {
            t = mix(phoenix_step(uv, puv), julia_step(uv), mixunit);
        } else if (ms < 12000.) {
            t = mix(mandelbrot_step(z, uv2.yx), julia_step(uv), mixunit);
        } else {
            t = mix(mandelbrot_step(z, uv2.yx), mandelbrot_step(t, c), mixunit);
        }

        pTraveled3 = traveled3;
        pTraveled2 = traveled2;
        pTraveled = traveled;
        vec2 s = t - uv2;
        float sLength = length(s);
        float inter = abs(sLength - uvLength);
        traveled += abs((length(t) - inter)/(uvLength - inter));
        traveled2 += abs((length(t) - inter)/(sLength - inter));
        traveled3 += abs((length(t) - inter)/(abs(sLength - uvLength)));
        puv = uv;
        uv = t;
        prev = uv;
        z = t;
    }

    float overage = length(uv - prev); // length(uv) - 4.;
    if (overage < epsilon) {
        overage = epsilon;
    } else {
        overage = log(overage);// 000.;
    }

//    vec2 puv2 = c;
//    vec2 pd = c;
//    for (int y = 0; y < 12; y++) {
//        vec2 t = mix(phoenix_step(uv, puv), julia_step(t), 0.5 + 0.5*sin(ms/1765.)); //  phoenix_step(uv2, puv2);
//        puv2 = uv2;
//        uv2 = t;
//
//        t = phoenix_step(d, pd);
//        pd = d;
//        d = t;
//    }
//
//    float dist = length(uv2 - d);
//    float ldist = (log(dist));

    float tia = traveled / float(i - overage);
    float pTia = pTraveled / float(i - 1 - overage);
    float tia2 = traveled2 / float(i - overage);
    float pTia2 = pTraveled2 / float(i - 1 - overage);
    float tia3 = traveled3 / float(i - overage);
    float pTia3 = pTraveled3 / float(i - 1 - overage);

    float k1 = abs(pTia - tia); // 1. - abs(1. / tia + (pTia - tia));
    float k2 = abs(pTia2 - tia2); // 1. - abs(1. / tia2 + (pTia2 - tia2));
    float k3 = abs((pTia3 - tia3));

    vec3 c1 =  clamp(palette( clamp(k1/1.1, 0., 1.),
    vec3(0., 0., 0.),
    vec3(1., 1., 1.),
    vec3(.9, .5, .5),
    vec3(0.5, 0.5, 0.5)
    ), 0., 1.);
    vec3 c2 =   clamp(  palette( clamp(k2, 0., 1.),
    vec3(0., 0., 0.),
    vec3(1., 1., 1.),
    vec3(.5, .5, .9),
    vec3(0.5, 0.5, 0.5)
    ), 0., 1.);
    vec3 c3 =    clamp( palette( clamp(k3, 0., 1.),
    vec3(0., 0., 0.),
    vec3(0.0, 0.5, 1.),
    vec3(.5, .9, 1.9),
    vec3(0.5, 0.5, 0.5)
    ), 0., 1.);

    vec4 col = vec4(
    //    1. - 1./i,
    //    ldist,

        1. - (1. / tia + (pTia - tia)),
    //    1. - (1. / tia + (pTia - tia)),
    //    1. - (1. / tia + (pTia - tia)),

    //    palette(1. / (1. - abs((1. / tia + (pTia - tia)))), // * fract(overage)),
    //        vec3(0.0,0.5,0.5),
    //        vec3(0.0,0.2,0.2),
    //        vec3(1., 1., 1.),
    //        vec3(0.,.5,.5)),

        1. - (1. / tia3 + (pTia3 - tia3)), // * fract(overage)),
    //    1. - (1. / tia3 + (pTia3 - tia3)), // * fract(overage)),
    //    1. - (1. / tia3 + (pTia3 - tia3)), // * fract(overage)),
//    c1 + c3 , // + c2 + c3) / 3., //  + c2 + c3,

        clamp(1. - abs((1. / tia2 + (pTia2 - tia2))), 0., 1.), //  * fract(overage)),
//        clamp(1. - abs((1. / tia2 + (pTia2 - tia2))), 0., 1.), //  * fract(overage)),
//        clamp(1. - abs((1. / tia2 + (pTia2 - tia2))), 0., 1.), //  * fract(overage)),
    1);

    if (ms < 2000.) {
        Color = mix(vec4(0.,0.,0.,1.), col, ms/2000.);
    } else if(ms > 13000.) {
        Color = mix(col, vec4(0,0,0,1), clamp((ms-13000.)/2000., 0., 1.));
    } else {
        Color = col;
    }
}