#version 450

uniform float ms;
uniform float width;
uniform float height;
out vec4 Color;

uniform sampler2D background;

uniform float bigSize = 0.5;
uniform float mediumSize = 0.4;
uniform float smallSize = 0.1;

const int greenMat = 4;
const int redMat = 3;
const int grayMat = 5;

vec3 dir;

float sdPlane( vec3 p ) {
    return p.y;
}

float sdSphere( vec3 p, float s ) {
    return length(p) - s;
}

vec2 opU( vec2 d1, vec2 d2 ) {
    return (d1.x<d2.x) ? d1 : d2;
}

vec2 letter_S(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    res = opU(res, vec2(sdSphere(pos-vec3(-0.4, 0.6, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(-0.2, 0.6, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(0, 0.6, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(-0.6, 0.4, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(0.2, 0.4, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(-0.6, 0.2, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(-0.4, 0, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(-0.2, 0, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(0.0, 0, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(0.2, -0.2, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(0.2, -0.4, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(-0.6, -0.4, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(-0.4, -0.6, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(-0.2, -0.6, 0), smallSize), greenMat));
    res = opU(res, vec2(sdSphere(pos-vec3(0., -0.6, 0), smallSize), greenMat));
    return res;
}

vec2 letter_Y(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, -0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, -0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, -0.6, 0), smallSize), greenMat));
    return res;
}

vec2 letter_N(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    for(float i = -0.6; i <= 0.6; i+= 0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(-0.4, i, 0), smallSize), greenMat));
        res = opU( res, vec2( sdSphere( pos-vec3(0.4, i, 0), smallSize), greenMat));
    }
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, -0.2, 0), smallSize), greenMat));
    return res;
}

vec2 letter_C(vec3 pos) {
    pos = vec3(pos.x, abs(pos.y), pos.z);
    vec2 res = vec2(1e10, 0.0);
    for(float i = 0; i <= 0.4; i+= 0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(-0.4, i, 0), smallSize), greenMat));
    }
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0.4, 0), smallSize), greenMat));
    return res;
}

vec2 letter_H(vec3 pos) {
    pos = vec3(pos.x, abs(pos.y), pos.z);
    vec2 res = vec2(1e10, 0.0);
    for(float i = 0; i <= 0.6; i+= 0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(-0.4, i, 0), smallSize), greenMat));
        res = opU( res, vec2( sdSphere( pos-vec3(0.4, i, 0), smallSize), greenMat));
    }
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0, 0), smallSize), greenMat));
    return res;
}

vec2 letter_O(vec3 pos) {
    pos = vec3(abs(pos.x), abs(pos.y), pos.z);
    vec2 res = vec2(1e10, 0.0);
    for(float i = 0; i <= 0.4; i+= 0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(0.4, i, 0), smallSize), greenMat));
    }
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, 0.6, 0), smallSize), greenMat));
    return res;
}

vec2 letter_R(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    for(float i = -0.6; i <= 0.6; i+= 0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(-0.4, i, 0), smallSize), greenMat));
    }
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., -0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, -0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, -0.6, 0), smallSize), greenMat));
    return res;
}

vec2 letter_n(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    for(float i = -0.6; i <= 0.; i+= 0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(-0.4, i, 0), smallSize), greenMat));
        res = opU( res, vec2( sdSphere( pos-vec3(0.4, i, 0), smallSize), greenMat));
    }
    for(float i = -0.4; i <= 0.2; i+= 0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(i, 0.2, 0), smallSize), greenMat));
    }
    return res;
}

vec2 letter_y(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    pos.x = abs(pos.x);
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0., 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., -0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., -0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., -0.6, 0), smallSize), greenMat));
    return res;
}

vec2 letter_gt(vec3 pos) {
    pos = vec3(pos.x, abs(pos.y), pos.z);
    vec2 res = vec2(1e10, 0.0);
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0.6, 0), smallSize), greenMat));
    return res;
}

vec2 letter_d(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    for(float i = -0.6; i <= 0.6; i+= 0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(0.4, i, 0), smallSize), greenMat));
    }
    pos.y = abs(pos.y + 0.2);
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.0, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.4, 0), smallSize), greenMat));
    return res;
}

vec2 letter_e(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, -0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, -0.4, 0), smallSize), greenMat));

    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, -0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, -0.6, 0), smallSize), greenMat));

    pos.y = abs(pos.y + 0.2);
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.0, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.0, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.4, 0), smallSize), greenMat));
    return res;
}

vec2 letter_m(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    pos.x = abs(pos.x);
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, -0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, -0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, -0.60, 0), smallSize), greenMat));

    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., 0., 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., -0.2, 0), smallSize), greenMat));

    return res;
}

vec2 letter_o(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    pos.x = abs(pos.x);
    pos.y = abs(pos.y + 0.2);
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.4, 0), smallSize), greenMat));

    return res;
}

vec2 letter_s(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    res = opU( res, vec2( sdSphere( pos-vec3(0.4, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0.2, 0), smallSize), greenMat));

    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0.0, 0), smallSize), greenMat));

    res = opU( res, vec2( sdSphere( pos-vec3(0.2, -0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., -0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, -0.2, 0), smallSize), greenMat));

    res = opU( res, vec2( sdSphere( pos-vec3(0.4, -0.4, 0), smallSize), greenMat));

    res = opU( res, vec2( sdSphere( pos-vec3(0.2, -0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0., -0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, -0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, -0.6, 0), smallSize), greenMat));

    return res;
}

vec2 letter_c(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    pos.y = abs(pos.y + 0.2);
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.2, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.0, 0.4, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.4, 0), smallSize), greenMat));
    return res;
}

vec2 letter_t(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    for(float i = -0.4; i <= 0.6; i+=0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(-0.2, i, 0), smallSize), greenMat));
    }
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.0, 0.2, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, 0.2, 0), smallSize), greenMat));

    res = opU( res, vec2( sdSphere( pos-vec3(0., -0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.2, -0.6, 0), smallSize), greenMat));
    return res;
}

vec2 letter_l(vec3 pos) {
    vec2 res = vec2(1e10, 0.0);
    for(float i = -0.6; i <= 0.6; i+=0.2) {
        res = opU( res, vec2( sdSphere( pos-vec3(-0.2, i, 0), smallSize), greenMat));
    }
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, 0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(-0.4, -0.6, 0), smallSize), greenMat));
    res = opU( res, vec2( sdSphere( pos-vec3(0.0, -0.6, 0), smallSize), greenMat));
    return res;
}

vec2 iBox( in vec3 ro, in vec3 rd, in vec3 rad ) {
    vec3 m = 1.0/rd;
    vec3 n = m*ro;
    vec3 k = abs(m)*rad;
    vec3 t1 = -n - k;
    vec3 t2 = -n + k;
    return vec2( max( max( t1.x, t1.y ), t1.z ),
    min( min( t2.x, t2.y ), t2.z ) );
}

vec2 map( in vec3 pos) {
    vec2 res = vec2( 1e10, 0.0 );

    vec2 tb = iBox( pos - vec3(-4.3, 0, 0), dir, vec3(1, 1, 0.2));
    if( tb.x<tb.y && tb.y>0.0) {
        res = opU(res, letter_S(pos - vec3(-4.3, 0, 0)));
    }

    tb = iBox( pos - vec3(0, 0, 0), dir, vec3(6, 0.7, 0.2));
    if( tb.x<tb.y && tb.y>0.0) {
        res = opU(res, letter_Y(pos-vec3(-3.3, 0, 0)));
        res = opU(res, letter_N(pos-vec3(-2.1, 0, 0)));
        res = opU(res, letter_C(pos-vec3(-0.9, 0, 0)));
        res = opU(res, letter_H(pos-vec3(0.3, 0, 0)));
        res = opU(res, letter_R(pos-vec3(1.5, 0, 0)));
        res = opU(res, letter_O(pos-vec3(2.7, 0, 0)));
        res = opU(res, letter_N(pos-vec3(3.9, 0, 0)));
        res = opU(res, letter_Y(pos-vec3(5.1, 0, 0)));
    }

    tb = iBox( pos - vec3(0, -2, 0), dir, vec3(10, 0.6, 0.2));
    if( tb.x<tb.y && tb.y>0.0) {

        float offset = -2.2;
        res = opU(res, letter_n(pos-vec3(-7 + offset, -2, 0)));
        res = opU(res, letter_y(pos-vec3(-5.8 + offset, -2, 0)));
        res = opU(res, letter_c(pos-vec3(-4.6 + offset, -2, 0)));

        res = opU(res, letter_gt(pos-vec3(-3.4 + offset, -2, 0)));

        offset -= 0.2;
        res = opU(res, letter_d(pos-vec3(-2.2 + offset, -2, 0)));
        res = opU(res, letter_e(pos-vec3(-1 + offset, -2, 0)));
        res = opU(res, letter_m(pos-vec3(0.2 + offset, -2, 0)));
        res = opU(res, letter_o(pos-vec3(1.4 + offset, -2, 0)));
        res = opU(res, letter_s(pos-vec3(2.6 + offset, -2, 0)));
        res = opU(res, letter_c(pos-vec3(3.8 + offset, -2, 0)));
        offset -= 0.2;
        res = opU(res, letter_e(pos-vec3(5 + offset, -2, 0)));
        res = opU(res, letter_n(pos-vec3(6.2 + offset, -2, 0)));
        res = opU(res, letter_e(pos-vec3(7.4 + offset, -2, 0)));

        res = opU(res, letter_gt(pos-vec3(8.6 + offset, -2, 0)));

        res = opU(res, letter_m(pos-vec3(9.8 + offset, -2, 0)));
        res = opU(res, letter_t(pos-vec3(11 + offset, -2, 0)));
        offset -= 0.2;
        res = opU(res, letter_l(pos-vec3(12.2 + offset, -2, 0)));
    }
    return res;
}

const float maxHei = 0.8;

vec2 castRay( in vec3 ro, in vec3 rd ) {
    vec2 res = vec2(-1.0,-1.0);

    float tmin = 1.0;
    float tmax = 100.0;

    // raytrace floor plane
    //    float tp1 = (0.0-ro.y)/rd.y;
    //    if( tp1>0.0 )
    //    {
    //        tmax = min( tmax, tp1 );
    //        res = vec2( tp1, 1.0 );
    //    }

    // raymarch primitives
    vec2 tb = iBox( ro-vec3(0.1,0.1,-0.1), rd, vec3(100.0,100.0,100.0) );
    if( tb.x<tb.y && tb.y>0.0 && tb.x<tmax)
    {
        tmin = max(tb.x,tmin);
        tmax = min(tb.y,tmax);

        float t = tmin;
        for( int i=0; i<150 && t<tmax; i++ )
        {
            vec2 h = map( ro+rd*t );
            if( abs(h.x)<(0.000001*t) )
            {
                res = vec2(t,h.y);
                break;
            }
            t += h.x;
        }
    }

    return res;
}

// http://iquilezles.org/www/articles/rmshadows/rmshadows.htm
float calcSoftshadow( in vec3 ro, in vec3 rd, in float mint, in float tmax ) {
    // bounding volume
    float tp = (maxHei-ro.y)/rd.y;
    if( tp>0.0 ) tmax = min( tmax, tp );

    float res = 1.0;
    float t = mint;
    for( int i=0; i<16; i++ )
    {
        float h = map( ro + rd*t ).x;
        float s = clamp(8.0*h/t,0.0,1.0);
        res = min( res, s*s*(3.0-2.0*s) );
        t += clamp( h, 0.02, 0.10 );
        if( res<0.005 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

// http://iquilezles.org/www/articles/normalsSDF/normalsSDF.htm
vec3 calcNormal( in vec3 pos ) {
    // inspired by klems - a way to prevent the compiler from inlining map() 4 times
    vec3 n = vec3(0.0);
    for( int i=0; i<4; i++ )
    {
        vec3 e = 0.5773*(2.0*vec3((((i+3)>>1)&1),((i>>1)&1),(i&1))-1.0);
        n += e*map(pos+0.0005*e).x;
    }
    return normalize(n);
}

float calcAO( in vec3 pos, in vec3 nor ) {
    float occ = 0.0;
    float sca = 1.0;
    for( int i=0; i<5; i++ )
    {
        float hr = 0.01 + 0.12*float(i)/4.0;
        vec3 aopos =  nor * hr + pos;
        float dd = map( aopos ).x;
        occ += -(dd-hr)*sca;
        sca *= 0.95;
    }
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 ) * (0.5+0.5*nor.y);
}

// http://iquilezles.org/www/articles/checkerfiltering/checkerfiltering.htm
float checkersGradBox( in vec2 p, in vec2 dpdx, in vec2 dpdy ) {
    // filter kernel
    vec2 w = abs(dpdx)+abs(dpdy) + 0.001;
    // analytical integral (box filter)
    vec2 i = 2.0*(abs(fract((p-0.5*w)*0.5)-0.5)-abs(fract((p+0.5*w)*0.5)-0.5))/w;
    // xor pattern
    return 0.5 - 0.5*i.x*i.y;
}

float infColor(float x) {
    return (1. / (abs(x) + 1.));
}

float cdistance(vec4 cubic, vec2 loc) {
    float cd = cubic.w + (loc.x * (cubic.z + (loc.x * (cubic.y + (loc.x * cubic.x))))) - loc.y;
    return abs(cd);
}

vec3 render( in vec3 ro, in vec3 rd, in vec3 rdx, in vec3 rdy ) {
    vec3 col = vec3(0) - max(rd.y,0.0)*0.3;
    vec2 res = castRay(ro,rd);
    float t = res.x;
    float m = res.y;
    if( m>0 )
    {
        vec3 pos = ro + t*rd;
        vec3 nor = calcNormal( pos );
        vec3 ref = reflect( rd, nor );

        // material
        col = 0.2 + 0.18*sin(m*560 + vec3(0.5,0.5,1.0) );
        col = vec3(mod(m, 2.), mod(m, 3.)/2., m > 4 ? 1 : 0);

        // lighting
        //        float occ = calcAO( pos, nor );
        vec3  lig = normalize( vec3(sin(ms/1000), cos(ms/1700.0), sin(ms/1243.))); // 0, 0.6, -5) );
        vec3  hal = normalize( lig-rd );
        float amb = sqrt(clamp( 0.5+0.5*nor.y, 0.0, 1.0 ));
        float dif = clamp( dot( nor, lig ), 0.0, 1.0 );
        float bac = clamp( dot( nor, normalize(vec3(-lig.x,0.0,-lig.z))), 0.0, 1.0 )*clamp( 1.0-pos.y,0.0,1.0);
        float dom = smoothstep( -0.2, 0.2, ref.y );
        //        float fre = pow( clamp(1.0+dot(nor,rd),0.0,1.0), 2.0 );

        dif *= calcSoftshadow( pos, lig, 0.02, 2.5 );
        dom *= calcSoftshadow( pos, ref, 0.02, 2.5 );

        float spe = pow( clamp( dot( nor, hal ), 0.0, 1.0 ),40.0);
        //        * dif *
        //        (0.04 + 0.96*pow( clamp(1.0+dot(hal,rd),0.0,1.0), 5.0 ));

        vec3 lin = vec3(0.0);
        //        lin += 3.80*dif*vec3(1.00,1.00,1.0);
        lin += 0.55*amb*vec3(0.40,0.60,1.0);//*occ;
        //        lin += 0.85*dom*vec3(0.40,0.60,1.30);//*occ;
        lin += 0.55*bac*vec3(0.25,0.25,0.25);//*occ;
        //        lin += 0.25*fre*vec3(1.00,1.00,1.00);//*occ;
        col = col*lin;
        col += 1.00*spe*vec3(1.10,0.90,0.70);

        //        col = mix( col, vec3(0), 1.0-exp( -0.00001*t*t*t ) );
    }

    return vec3( clamp(col,0.0,1.0) );
}

mat3 setCamera( in vec3 ro, in vec3 ta, float cr ) {
    vec3 cw = normalize(ta-ro);
    vec3 cp = vec3(sin(cr), cos(cr),0.0);
    vec3 cu = normalize( cross(cw,cp) );
    vec3 cv =          ( cross(cu,cw) );
    return mat3( cu, cv, cw );
}

void main() {
    vec2 fragCoord = gl_FragCoord.xy;
    vec2 iResolution = vec2(width, height);
    float time = ms/100.;
    //    float time = 612.61;
    // camera
    vec3 ro = vec3( 20.*cos(0.12*time), 20.*sin(0.13*time), 20*sin(.1*time)) ; // 3.8*sin(0.1*time) );
    // camera-to-world transformation
    mat3 ca = setCamera( ro, vec3(0), 0.0 );

    // pixel coordinates
    vec2 p = (-iResolution.xy + 2.0*(fragCoord))/iResolution.y;

    // ray direction
    vec3 rd = ca * normalize( vec3(p,3)); // .0 - (ms/1000.)));
    dir = rd;

    // ray differentials
    vec2 px = (-iResolution.xy+2.0*(fragCoord+vec2(1.0,0.0)))/iResolution.y;
    vec2 py = (-iResolution.xy+2.0*(fragCoord+vec2(0.0,1.0)))/iResolution.y;
    vec3 rdx = ca * normalize( vec3(px,2.0) );
    vec3 rdy = ca * normalize( vec3(py,2.0) );

    // render
    vec3 col = render( ro, rd, rdx, rdy );

    if (col.x == 0) {
        vec2 p = (-iResolution.xy + 2.0*(fragCoord)) / iResolution.y;
        float timeMod = ms/3.;
        float r = 1.;
        for(int i = 1; i < 5; i++) {
            r *= infColor(cdistance(vec4(sin(i*timeMod/1000.), cos(i*timeMod/1234.), cos(i*timeMod/1700.), sin(i*timeMod/2700.)), p));
        }
        float g = 1.;
        for(int i = 1; i < 5; i++) {
            g *= infColor(cdistance(vec4(sin(i*timeMod/1234.), cos(i*timeMod/1900.), cos(i*timeMod/2700.), sin(i*timeMod/1700.)), p));
        }
        float b = 1.;
        for(int i = 1; i < 5; i++) {
            b *= infColor(cdistance(vec4(sin(i*timeMod/1700.), cos(i*timeMod/2234.), cos(i*timeMod/2700.), sin(i*timeMod/1900.)), p));
        }

        col = vec3( r, g, b);
    }

    // gamma
    if (ms < 2000.0) {
        col = col * (ms/2000.0);
    } else if (ms > 10000.0) {
        col = col * clamp((11000.0-ms)/1000.00, 0, 1);
    }
    col = pow(col, vec3(0.7));

    Color = texture(background, fragCoord / iResolution) + vec4( col, 1.0 );
}