; Drumken by Abaddon - 256 byte intro / 2020.01
; softsynth drums with some visual effect
; code: TomCat
; drum pattern: Dick

; you can make your own drum loops here:
; https://learningmusic.ableton.com/make-beats/play-with-beats.html

; greetings to Buckethead, unbeliever^x7m and every sizecoder...

; PC Speaker rulez!
; https://youtu.be/_uckaZ-uePo

BASE=IRQ

ORG 256
 MOV AL,13H
 INT 10H

 MOV AX,3508H
 INT 21H
 PUSH ES
 PUSH BX

 MOV AL,90H
 OUT 43H,AL
 MOV AL,3FH
 MOV DX,IRQ
 CALL init
 MOV BP,DX

 PUSH 0A000H
 POP ES

nextframe:
 SUB DI,DI
 ADD BX,32
 NEG DL
 HLT
nextline:
 NEG CX
nextpixel:
 MOV AL,DL
 CBW
 XOR AH,DL
 MOV DH,AH
 MOV AL,CH
 CBW
 XOR AH,CL
 SUB DH,AH

 MOV AL,DL
 IMUL AL
 XCHG SI,AX
 MOV AL,CL
 IMUL AL
 ADD AX,SI
 PUSH CX
 MOV CL,7
 AND CL,AH

skip:
 ADD DH,BH
 SHR DH,CL
 POP CX
 SALC
 AND AL,31
 STOSB
 INC CX
 CMP CX,160
 JNE nextpixel
 INC DX
 CMP DL,100
 JNE nextline
 IN AL,60H
 DEC AL
 JNZ nextframe

 POP DX
 POP DS
init:
 OUT 61H,AL
 OUT 40H,AL
 SALC
 OUT 40H,AL
 MOV AX,2508H
 INT 21H
RETN

DRUMS1:
 DW 0000100010001000B   ; open hihat
 DW 0101011001010110B   ; closed hihat
 DW 1000000000000000B   ; snare (clap)
 DW 0111000100110001B   ; kick drum

IRQ:
 PUSHA

 MOV AL,0               ; AL=last sample
.SAMPLE:
 SHR AL,1               ; zero means pause (no sound)
 JZ @F
 OUT 42H,AL             ; send out the 6bit sample
@@:

 MOV SI,1
.COUNTER:
 MOV BH,0

 INC WORD [BP-BASE+IRQ.COUNTER-2]
 MOV DI,SI
 SHR DI,16-4

KICKDRUM:
 MOV AX,32256
 BT [BP-BASE+DRUMS1+6],DI
 JNC .SKIP
 CWD
 MOV CX,4095
 AND CX,SI
 INC CX
 DIV CX
 AND AX,64
 ADD BH,AL
.SKIP:

SNARE:
 CWD
 MOV CX,99

 MOV AX,SI
 DIV CX
 XCHG AX,DX
 MUL SI

 AND AX,64
 XCHG CX,AX
 BT [BP-BASE+DRUMS1+4],DI
 JNC .SKIP
 MOV AH,0F0H
 OR AX,SI
 IMUL AX
 XCHG AX,DX
 TEST AX,NOT 31
 JNZ @F
 SALC
@@:
 MUL CL
 ADD BH,AH
.SKIP:

HIHAT:
 CWD
 XCHG AX,CX
 BT [BP-BASE+DRUMS1+2],DI
 JC .CLOSED
 BT [BP-BASE+DRUMS1],DI
 JNC .SKIP
 MOV CL,96

 MOV AX,SI
 DIV CX
 XCHG AX,DX
 MUL SI

 AND AX,256
 MOV DL,3
.CLOSED:
 INC DX
 SHR SI,6
 AND SI,63
 ADD SI,DX
 CWD
 DIV SI
 ADD BH,AL
.SKIP:

 MOV [BP-BASE+IRQ.SAMPLE-1],BH

 MOV  AL,20H
 OUT  20H,AL
 POPA
IRET
