// Witch Head Blues by Ajna

var gl = new WebGL2RenderingContext(); //enable WebGL 2 partial support

var particleMesh = void null;
function initParticles(animation) {
    particleMesh = new Mesh();

    var particleImage = new Image();
    particleImage.load("particle.png");
    particleMesh.setMaterialTexture(particleImage, 0);

    particleMesh.setFaceDrawType(POINTS);

    for (var z = 0; z < 1000; z++) {
        particleMesh.addVertex(Math.random()*60-30.0,Math.random()*50-25.0,-z/10.0+Math.random());
    }

    particleMesh.generate();
}

function deinitParticles(animation) {
    particleMesh.delete();
}

function drawParticles(animation) {
    glPushMatrix();
    perspective2dEnd();
        
    gl.enable(gl.BLEND);
    gl.disable(gl.DEPTH_TEST);
    gl.blendFunc(gl.ONE, gl.ONE);
    glColor4f(1,1,1,1);

    particleMesh.draw();
    gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
    gl.enable(gl.DEPTH_TEST);

    glPopMatrix();
}

var tunnelMesh2 = void null;
var tunnelMeshTexture = void null;
function initTunnel(animation) {
    tunnelMesh2 = meshNew();
    if (tunnelMesh2.ptr === void null) {
        loggerFatal("Could not initialize Mesh");
    }

    tunnelMeshTexture = imageLoadImage("particle.png");
    meshMaterialSetTexture(tunnelMesh2.ptr, tunnelMeshTexture.ptr, 0);

    var precision = 24;

    meshSetFaceDrawType(tunnelMesh2.ptr, TRIANGLES);

    for(var j = 0; j < 160; j++) {
        var z1 = -j * 3;
        var z2 = z1-(2+Math.random()*2);
        for (var i=0; i < precision; i+=Math.floor(Math.random()*8))
        {

            var radius = 1.0 + Math.random()*10.0-5.0;
            var x1 = radius;
            var y1 = radius;
            var x2 = radius;
            var y2 = radius;

            var pos = Math.floor(Math.random()*4);
            if (pos == 0) {
                // -X
                x1 *= -1;
                x2 = x1;
                y1 = 1.0 + Math.random()*10.0-5.0;
                y2 += 1.0;
            } else if (pos == 1) {
                // +X
                x2 = x1;
                y1 = 1.0 + Math.random()*10.0-5.0;
                y2 += 1.0;
            } else if (pos == 2) {
                // -Y
                y1 *= -1;
                y2 = y1;
                x1 = 1.0 + Math.random()*10.0-5.0;
                x2 += 1.0;
            } else {
                // +Y
                y = y1;
                x1 = 1.0 + Math.random()*10.0-5.0;
                x2 += 1.0;
            }

            var uMin = 0.0;
            var uMax = 1.0;
            var vMin = 0.0;
            var vMax = 1.0;

            meshAddTexCoord(tunnelMesh2.ptr, uMin, vMax);
            meshAddVertex(tunnelMesh2.ptr, x1,y1,z2);
            meshAddTexCoord(tunnelMesh2.ptr, uMax, vMax);
            meshAddVertex(tunnelMesh2.ptr, x2,y2,z2);
            meshAddTexCoord(tunnelMesh2.ptr, uMin, vMin);
            meshAddVertex(tunnelMesh2.ptr, x1,y1,z1);

            meshAddTexCoord(tunnelMesh2.ptr, uMin, vMin);
            meshAddVertex(tunnelMesh2.ptr, x1,y1,z1);
            meshAddTexCoord(tunnelMesh2.ptr, uMax, vMax);
            meshAddVertex(tunnelMesh2.ptr, x2,y2,z2);
            meshAddTexCoord(tunnelMesh2.ptr, uMax, vMin);
            meshAddVertex(tunnelMesh2.ptr, x2,y2,z1);
        }
    }

    meshGenerate(tunnelMesh2.ptr);


}

function deinitTunnel(animation) {
    meshDelete(tunnelMesh2.ptr);
}

function drawTunnel(animation) {
    glPushMatrix();
    perspective2dEnd();
        
    gl.enable(gl.BLEND);
    gl.blendFunc(gl.ONE, gl.ONE);
    gl.disable(gl.DEPTH_TEST);

    glTranslatef(-0.5,0,0 + 20 * getSceneTimeFromStart()*0.1);
    glRotatef(getSceneTimeFromStart()*30.0,0,0,-1);
    meshDraw(tunnelMesh2.ptr, 0.0, 1.0);

    gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
    gl.enable(gl.DEPTH_TEST);

    glPopMatrix();
}

function getGlowValue(animation, type, name)
{
    //var p = 1-Utils.calculateProgress(animation.start+animation.warpSlowStart, animation.warpSlowDuration);

    var samples = 30;
    var spread = 0.012;
    var intensity = 0.012;
    var alpha = 1;

    if (name === "samples")
    {
        return samples;
    }
    else if (name === "spread")
    {
        return spread;
    }
    else if (name === "intensity")
    {
        return intensity;
    }
    else if (name === "alpha")
    {
        return alpha;
    }
    else if (name === "glowAlpha")
    {
        return 1.0;
    }
    else if (name === "showOnlyGlow")
    {
        if (type === 1) {
            return 0;
        }
        return 1;
    }
    
    return void null;
}


var frameStableRand=0.0;
var mathFuncVary=0;
function shake(axis, prefix) {

    var p = {
         "pos":Sync.getSyncValue(prefix+"pos")
        ,"force":Sync.getSyncValue(prefix+"force")*0.1
        ,"speed":Sync.getSyncValue(prefix+"speed")
        ,"rand":Sync.getSyncValue(prefix+"rand")
    };

    var func = [Math.sin,Math.cos][(mathFuncVary++)%2];
    return axis * (p.pos+(func(getSceneTimeFromStart()*(p.speed+frameStableRand*p.rand))*p.force));
}

function lpad(digit, len) {
    if (len === void null) {
        len = 2;
    }
    return digit.toString().padStart(len, 0);
}

var initialTime = Date.now();
function getHudTime() {
    var slowDate = new Date(initialTime + (Date.now() - initialTime) * 0.15);
    var time = lpad(slowDate.getHours()) + ":" + lpad(slowDate.getMinutes()) + ":" + lpad(slowDate.getSeconds()) + "." + lpad(slowDate.getMilliseconds(), 3);
    return time;
}

Demo.prototype.init = function()
{
    var start = 0;
    var duration = 147;
    var layer = 1;

    var videos = true;

    Sync.addSync(
    [
         { "name":"sun:zoom", "type":"rocket" }
        ,{ "name":"sun:threshold", "type":"rocket" }
        ,{ "name":"pilot:blur", "type":"rocket" }
        ,{ "name":"pilot:alpha", "type":"rocket" }
        ,{ "name":"pilot:xpos", "type":"rocket" }
        ,{ "name":"pilot:xspeed", "type":"rocket" }
        ,{ "name":"pilot:xrand", "type":"rocket" }
        ,{ "name":"pilot:xforce", "type":"rocket" }
        ,{ "name":"pilot:ypos", "type":"rocket" }
        ,{ "name":"pilot:yspeed", "type":"rocket" }
        ,{ "name":"pilot:yrand", "type":"rocket" }
        ,{ "name":"pilot:yforce", "type":"rocket" }
        ,{ "name":"suit:xpos", "type":"rocket" }
        ,{ "name":"suit:xspeed", "type":"rocket" }
        ,{ "name":"suit:xrand", "type":"rocket" }
        ,{ "name":"suit:xforce", "type":"rocket" }
        ,{ "name":"suit:ypos", "type":"rocket" }
        ,{ "name":"suit:yspeed", "type":"rocket" }
        ,{ "name":"suit:yrand", "type":"rocket" }
        ,{ "name":"suit:yforce", "type":"rocket" }
        ,{ "name":"background:blur", "type":"rocket" }
        ,{ "name":"foreground:blur", "type":"rocket" }
        ,{ "name":"phenomenon:alpha", "type":"rocket" }
    ]);

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"particlesFbo","action":"begin","storeDepth":false}
    }]);

    this.loader.addAnimation([{
         "start": start, "duration": duration
        ,"layer": layer
        ,"part": 1
        ,"initFunction": "{initTunnel(animation);}"
        ,"deinitFunction": "{deinitTunnel(animation);}"
        ,"runFunction": "{drawTunnel(animation);}"
    }]);
    this.loader.addAnimation([{
         "start": start, "duration": duration
        ,"layer": layer
        ,"initFunction": "{initParticles(animation);}"
        ,"deinitFunction": "{deinitParticles(animation);}"
        ,"runFunction": "{drawParticles(animation);}"
        ,"shader":{"name":["particles.vs","particles.gs","particles.fs"]}
    }]);


    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"particlesFbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"starfield2Fbo","action":"begin","storeDepth":false}
        ,"runFunction":"{frameStableRand=Math.random();}"
    }]);

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"starfield.fs"}
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png","fft0"]
        ,"shader":{"name":"fft.fs"}
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["particlesFbo.color.fbo","fft0"]
        ,"shader":{"name":"itsfullofstars.fs"}
        ,"color":[{"a":"{return Sync.getSyncValue('phenomenon:alpha')*255.0;}"}]
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"starfield2Fbo","action":"unbind"}
    });
    this.loader.addAnimation([{
         "start": start, "duration": duration, "layer": layer
        ,"image": "starfield2Fbo.color.fbo"
        ,"passToFbo": {name:"starfieldFbo"}
        ,"shader":[
             {"name":"glow.fs","variable":[
                 {"name":"direction","value":[1,0]}
                ,{"name":"glowAlpha","value":["{return getGlowValue(animation, 0, \"glowAlpha\");}"]}
                ,{"name":"spread","value":["{return getGlowValue(animation, 0, \"spread\");}"]}
                ,{"name":"intensity","value":["{return getGlowValue(animation, 0, \"intensity\");}"]}
                ,{"name":"samples","type":"int","value":["{return getGlowValue(animation, 0, \"samples\");}"]}
            ]}
            ,{"name":"glow.fs","variable":[
                 {"name":"direction","value":[0,1]}
                ,{"name":"glowAlpha","value":["{return getGlowValue(animation, 1, \"glowAlpha\");}"]}
                ,{"name":"spread","value":["{return getGlowValue(animation, 1, \"spread\");}"]}
                ,{"name":"intensity","value":["{return getGlowValue(animation, 1, \"intensity\");}"]}
                ,{"name":"samples","type":"int","value":["{return getGlowValue(animation, 1, \"samples\");}"]}
                ,{"name":"showOnlyGlow","type":"int","value":["{return getGlowValue(animation, 1, \"showOnlyGlow\");}"]}
                ,{"name":"alpha","value":["{return getGlowValue(animation, 1, \"alpha\");}"]}
            ]}
        ]
    }]);


    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"kaleidoscopeFbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["starfieldFbo.color.fbo"]
        ,"shader":{"name":"kaleidoscope.fs"}
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png","fft0"]
        ,"shader":{"name":"fft.fs"
            ,"variable": [
                 {"name":"zoom","value":["{return Sync.getSyncValue('sun:zoom');}"]}
                ,{"name":"sunThreshold","value":["{return Sync.getSyncValue('sun:threshold');}"]}
            ]
        }
    });


    this.loader.addAnimation({
         "start": duration-15, "duration":15
        ,"layer": layer, "image": ["qr_ajna.png"]
        ,"scale":[{"uniform2d":0.2}]
        ,"color":[{"a":0},{"duration":4,"a":255}]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"starfield.fs"}
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"kaleidoscopeFbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"hudFbo","action":"begin","storeDepth":false}
    }]);

    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"LCD-BOLD.TTF"
            ,"string":"{return getHudTime();}"
        }
        ,"scale": [{"uniform2d":2.0}]
        ,"position":[
            {"x":getScreenWidth()*0.47,"y":getScreenHeight()*0.05}
        ]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"LCD-BOLD.TTF"
            ,"string":"2094/01/16"
        }
        ,"scale": [{"uniform2d":2.0}]
        ,"position":[
            {"x":getScreenWidth()*0.47,"y":getScreenHeight()*0.15}
        ]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png","fft0"]
        ,"scale": [{"uniform2d":0.4}]
        ,"shader":{"name":"hudFft.fs"}
        ,"position":[
            {"x":getScreenWidth()*0.80,"y":getScreenHeight()*0.20}
        ]
        ,"color":[{"a":200}]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["hud.png"]
        ,"scale": [{"uniform2d":0.65}]
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"hudFbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"skewyFbo","action":"begin","storeDepth":false}
    }]);

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["kaleidoscopeFbo.color.fbo"]
        ,"shader":{"name":"wavy.fs"}
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["hudFbo.color.fbo"]
        ,"scale":[{"x":-0.7,"y":0.7}]
        ,"color":[{"a":150}]
        ,"angle":[{"degreesZ":2}]
        ,"position":[{"x":"{return getScreenWidth()*0.56;}","y":"{return getScreenHeight()*0.48;}"}]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["particlesFbo.color.fbo","fft0"]
        ,"shader":{"name":"itsfullofstars.fs"}
        ,"color":[{"a":"{return Sync.getSyncValue('phenomenon:alpha')*100.0;}"}]
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"skewyFbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"planetFbo","action":"begin","storeDepth":false}
    }]);

    if (videos) {
        this.loader.addAnimation({
             "start": start, "duration": duration
            ,"layer": layer, "image": {"name":"planet.ogv", "video":{"speed":0.15} }
            ,"scale":[{"uniform2d":3.5}]
            ,"position":[{"x":getScreenWidth()*0.51,"y":getScreenHeight()*0.22}]
            //,"color":[{"a":100}]
        });
    }

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"planetFbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"backgroundFbo","action":"begin","storeDepth":false}
    }]);

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["background.png","planetFbo.color.fbo"]
        ,"shader":{"name":"starfield_background.fs"}
       //,"color":[{"a":50}] 
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["helmet.png","planetFbo.color.fbo"]
       //,"color":[{"r":50,"g":50,"b":50}] 
        ,"position":[{"x":"{return shake(getScreenWidth(), 'suit:x');}","y":"{return shake(getScreenHeight(), 'suit:y');}"}]
       ,"shader":{"name":"starfield_helmet.fs"}
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"backgroundFbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"fisheyeFbo","action":"begin","storeDepth":false}
    }]);

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["skewyFbo.color.fbo","fft0"]
        ,"color":[{"a":255}]
        //,"layer": layer, "image": ["uvtest.png","fft0"]
        ,"shader":{"name":"fisheye.fs"}
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"fisheyeFbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"foregroundFbo","action":"begin","storeDepth":false}
    }]);

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["fisheyeFbo.color.fbo"]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["helmet_shield.png"]
        ,"position":[{"x":"{return shake(getScreenWidth(), 'suit:x');}","y":"{return shake(getScreenHeight(), 'suit:y');}"}]
        ,"color":[{"a":50}] 
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"foregroundFbo","action":"unbind"}
        ,"runFunction":"{frameStableRand=Math.random();}"
    });

    if (videos) {
        this.loader.addAnimation({
             "start": start, "duration": duration
            ,"layer": layer, "image": [{"name":"pilot.ogv", "video":{"speed":0.15}},"fisheyeFbo.color.fbo"]
            ,"scale":[{"x":-3.5,"y":3.5}]
            ,"position":[{"x":"{return shake(getScreenWidth(), 'pilot:x');}","y":"{return shake(getScreenHeight(), 'pilot:y')+50;}"}]
            ,"shader":{"name":"face.fs"
                ,"variable": [
                     {"name":"textureBias","value":["{return Sync.getSyncValue('pilot:blur');}"]}
                ]
            }
            ,"color":[{"a":"{return Sync.getSyncValue('pilot:alpha')*255;}","r":255,"g":215,"b":220}]
        });
    } else {
        this.loader.addAnimation({
             "start": start, "duration": duration
            ,"layer": layer, "image": ["tmp/pilot_still.png","fisheyeFbo.color.fbo"]
            ,"scale":[{"x":-3.5,"y":3.5}]
            ,"position":[{"x":"{return shake(getScreenWidth(), 'pilot:x');}","y":"{return shake(getScreenHeight(), 'pilot:y');}"}]
            ,"shader":{"name":"face.fs"
                ,"variable": [
                     {"name":"textureBias","value":["{return Sync.getSyncValue('pilot:blur');}"]}
                ]
            }
            ,"color":[{"a":"{return Sync.getSyncValue('pilot:alpha')*255;}","r":255,"g":215,"b":220}]
        });
    }

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["foregroundFbo.color.fbo"]
        ,"color":[{"a":200}]
        ,"shader":{"name":"biasTex.fs"
            ,"variable": [
                 {"name":"textureBias","value":["{return Sync.getSyncValue('foreground:blur');}"]}
            ]
        }
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["backgroundFbo.color.fbo"]
        ,"shader":{"name":"biasTex.fs"
            ,"variable": [
                 {"name":"textureBias","value":["{return Sync.getSyncValue('background:blur');}"]}
            ]
        }
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"vignette.fs"}
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"vignette.fs"}
    });

    this.loader.addAnimation({
         "start": duration-10, "duration":15
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"color":[{"a":0,"r":0,"g":0,"b":0},{"duration":10,"a":255}]
    });
/*
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"color":[{"r":0,"g":0,"b":0}]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["hudFbo.color.fbo"]
    });*/

}
