#pragma once

//We do not show the full spectrum, instead just the interesting part
#define SPECTRUM_START 6 // 41.0156 Hz  (6 * BINSIZE)
#define SPECTRUM_END 2560 // 15000.0 Hz  (2560 * BINSIZE)
#define SPECTRUM_VIEW 513 

#define SPECTRUMSIZE 4096 //Defines the accuracy of the analyzed spectrum
#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))

//Storages for the left and right spectrums
extern float spectrumL[SPECTRUMSIZE];
extern float spectrumR[SPECTRUMSIZE];

extern float visualizationBuffer[SPECTRUMSIZE];    // Single channel to visualize
extern float bar_size[SPECTRUMSIZE - 1];

extern int lensD;
extern int* lensArrayA;
extern int* lensArrayB;
extern int* lensArrayALR;
extern int* lensArrayBLR;

namespace magnifglass
{

	class lensmagnif
	{

	public:

		// Lens transformation array
		static void Len_transf(int D, int M);

		// fast lens transformation array
		static void Len_transf_fast(int D, int magFactor);

		// For each pixel in the lens rectangle, apply the 
		// offset from lensArray using background pixel
		static void updatePixels(int xx, int yy, int iScreenWidth, int iScreenHeight, unsigned char* Lpixels, unsigned char* backg_image);

		static void updatePixels_fast(int xx, int yy, int iScreenWidth, int iScreenHeight, unsigned char* Lpixels, unsigned char* backg_image);


		// Lens transformation array
		static void Len_transfLR(int D, int M);

		// fast lens transformation array
		static void Len_transf_fastLR(int D, int magFactor);

		// For each pixel in the lens rectangle, apply the 
		// offset from lensArray using background pixel
		static void updatePixelsLR(int xx, int yy, int iScreenWidth, int iScreenHeight, unsigned char* Lpixels, unsigned char* backg_image);

		static void updatePixels_fastLR(int xx, int yy, int iScreenWidth, int iScreenHeight, unsigned char* Lpixels, unsigned char* backg_image);


		static void initSpectrumBar(void);

		static void smoothSpectrumBar(void);

	};
}