// Template_glutglew.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "IfontLib.h"
#include "mesh.h"
#include "Objects.h"
#include "sound_system.hpp"
#include "resource.h"
#include "BHorzScrollLib.h"


#define SCREEN_WIDTH 1024								// We want our screen width 800 pixels
#define SCREEN_HEIGHT 768								// We want our screen height 800 pixels
// Default camera values
#define YAW -90.0f
#define PITCH 0.0f

// my
#define MY_PI 3.14159265359f

//We do not show the full spectrum, instead just the interesting part
#define SPECTRUM_START 6 // 41.0156 Hz  (6 * BINSIZE)
#define SPECTRUM_END 2560 // 15000.0 Hz  (2560 * BINSIZE)
#define SPECTRUM_VIEW 513 

typedef unsigned char       BYTE;

//rendering selection in the shaders
enum
{
	NOLUMI = 1,               // Background
	OBJLUMI = 2,              // Object no texturing
	FADEOUTIN = 3             // Iluminated Texturing

};

// Data for the resolution used depending on the screen size
struct ReSdata
{
	int HScrl;
	int VScrl;
	int lensd;
	float tlamp1X, tlamp1Y;
	float tlamp2X, tlamp2Y;
	float SlampX, SlampY;
	float texX, texY, texY1;
	float linTx, linTy;
};


// choosable songs
std::vector<std::string> music;
std::vector<std::string> music_text;

sound_system_c *sound_system;   // class that uses the fmod audio library

std::vector<ReSdata> chResol;   // resolution list supported
int indchResol = 2, indResProg;  // list index
BOOL swm = FALSE, shm = FALSE, stopRend = FALSE, actStopR = FALSE;  //Boolean check variables

GLint mIndx = 0;             //current track playing
HINSTANCE	hInstance;		// Holds The Instance Of The Application

// shaders
GLuint g_shaderID;
GLuint g_shaderID1;

//Uniform variables
GLuint modelLoc = 0;
GLuint viewLoc = 0;
GLuint projLoc = 0;
GLuint modelLoc1 = 0;
GLuint viewLoc1 = 0;
GLuint projLoc1 = 0;
int lumi = OBJLUMI;

//Index of the textures used
GLuint BtextureID;
GLuint BtextureID1, BtextureID2;
GLuint CoverTexID;
GLuint BackTexID;

// transform matrix
glm::mat4 g_model;
glm::mat4 g_view;
glm::mat4 g_projection;

// Camera Attributes
glm::vec3 Position(0, 0, 0.f);
glm::vec3 Front(0, 0, -1);
glm::vec3 Up;
glm::vec3 Right;
glm::vec3 WorldUp(0, 1, 0);
// Eular Angles
GLfloat Yaw = YAW;
GLfloat Pitch = PITCH;


//Storages for the left and right spectrums
float spectrumL[SPECTRUMSIZE];
float spectrumR[SPECTRUMSIZE];

GLfloat visualizationBuffer[SPECTRUMSIZE];    // Single channel to visualize
float bar_size[SPECTRUMSIZE - 1];

//Objects created to display images and text
CMesh *pframe;
CMesh *pframe1;
CMesh *pLine1;
CMesh *pLine2;
CMesh *pLine3;


//  define the window position on screen
int window_x;
int window_y;

//  variables representing the window size
int window_width = SCREEN_WIDTH;
int window_height = SCREEN_HEIGHT;
int iScreenHeight = SCREEN_HEIGHT;
int iScreenWidth = SCREEN_WIDTH;

//  variable representing the window title
char *window_title = "Xylitol MusicDisk #1 - Welcome Home";

// mouse move (no delete)
bool g_leftPressed = false;
bool g_rightPressed = false;

//Variables for the lens effect
//*****************************************************

int xx = -200;
int yy = -200;
int dx = 2;
int dy = 2;


int lensD = 768;  // Lens diameter
int* lensArrayA;
int* lensArrayB;

int* lensArrayALR;
int* lensArrayBLR;

int Iwidth, Iheight;

unsigned char* backg_image, *Lpixels;
//*****************************************************

//Variable for offscreen
GLuint  g_texID[1];

//Time variables
std::clock_t g_PreviousTicks;
std::clock_t g_CurrentTicks;

/* Local helper functions */
void pressKey(int key, int xx, int yy);
void keyboard(unsigned char key, int x, int y);
void reshape(int width, int height);
void renderScene(void);
void MouseMove(int x, int y);  // mouse move (no delete)

void init();
GLuint LoadTexture(const std::string& file, bool MN = false);
GLuint LoadShader(GLenum shaderType, const std::string& shaderFile);
GLuint CreateShaderProgram(std::vector<GLuint> shaders);
void updateCameraVectors();
GLuint LoadShader_FResource(GLenum shaderType, const GLint shaderFile);
void renderEqViewer();
void rI_offscreen(GLuint tID);


/* Create scene objects */
void createObjects()
{
	vector <Point3D> points;
	vector <GLuint> indexes;


	//********************** Part of the code where the mesh of painting is created ********************************

	points.push_back(Point3D(glm::vec3(-1.0f, -1.0f, 0.0f), glm::vec3(0.0f, 0.0f, 1.0f), glm::vec2(0.0f, 1.0f)));
	points.push_back(Point3D(glm::vec3(1.0f, -1.0f, 0.0f), glm::vec3(0.0f, 0.0f, 1.0f), glm::vec2(1.0f, 1.0f)));
	points.push_back(Point3D(glm::vec3(1.0f, 1.0f, 0.0f), glm::vec3(0.0f, 0.0f, 1.0f), glm::vec2(1.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(-1.0f, 1.0f, 0.0f), glm::vec3(0.0f, 0.0f, 1.0f), glm::vec2(0.0f, 0.0f)));

		indexes.push_back(0); indexes.push_back(1); indexes.push_back(2);
		indexes.push_back(2); indexes.push_back(3); indexes.push_back(0);

		pframe = new CMesh(points, indexes);

	points.clear();
	indexes.clear();

	//********************** Part of the code where the meshing of the object is created ********************************

	points.push_back(Point3D(glm::vec3(32.f, 107.f, 0.f), glm::vec3(27.f / 255.f, 53.0f / 255.f, 104.f / 255.f), glm::vec2(0.0f, 1.0f)));
	points.push_back(Point3D(glm::vec3(102.f, 107.f, 0.f), glm::vec3(27.f / 255.f, 53.0f / 255.f, 104.f / 255.f), glm::vec2(1.0f, 1.0f)));
	points.push_back(Point3D(glm::vec3(102.f, 131, 0.f), glm::vec3(13.0f / 255.f, 1.f, 254.f / 255.f), glm::vec2(1.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(102.f, 131.f, 0.f), glm::vec3(13.0f / 255.f, 1.f, 254.f / 255.f), glm::vec2(1.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(32.f, 131.f, 0.f), glm::vec3(13.0f / 255.f, 1.f, 254.f / 255.f), glm::vec2(0.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(32.f, 107.f, 0.f), glm::vec3(27.f / 255.f, 53.0f / 255.f, 104.f / 255.f), glm::vec2(0.0f, 1.0f)));

	for (int i = 0; i < 6; i += 6)
	{
		indexes.push_back(i); indexes.push_back(i + 1); indexes.push_back(i + 2);
		indexes.push_back(i + 3); indexes.push_back(i + 4); indexes.push_back(i + 5);
	}
	pLine1 = new CMesh(points, indexes);

	points.clear();
	indexes.clear();


	points.push_back(Point3D(glm::vec3(102.f, 107.f, 0.f), glm::vec3(27.f / 255.f, 53.0f / 255.f, 104.f / 255.f), glm::vec2(1.0f, 1.0f)));
	points.push_back(Point3D(glm::vec3(242.f, 107.f, 0.f), glm::vec3(27.f / 255.f, 53.0f / 255.f, 104.f / 255.f), glm::vec2(1.0f, 1.0f)));
	points.push_back(Point3D(glm::vec3(242.f, 131, 0.f), glm::vec3(13.0f / 255.f, 1.f, 254.f / 255.f), glm::vec2(1.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(242.f, 131.f, 0.f), glm::vec3(13.0f / 255.f, 1.f, 254.f / 255.f), glm::vec2(1.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(102.f, 131.f, 0.f), glm::vec3(13.0f / 255.f, 1.f, 254.f / 255.f), glm::vec2(1.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(102.f, 107.f, 0.f), glm::vec3(27.f / 255.f, 53.0f / 255.f, 104.f / 255.f), glm::vec2(1.0f, 1.0f)));

	for (int i = 0; i < 6; i += 6)
	{
		indexes.push_back(i); indexes.push_back(i + 1); indexes.push_back(i + 2);
		indexes.push_back(i + 3); indexes.push_back(i + 4); indexes.push_back(i + 5);
	}
	pLine2 = new CMesh(points, indexes);

	points.clear();
	indexes.clear();



	points.push_back(Point3D(glm::vec3(242.f, 107.f, 0.f), glm::vec3(27.f / 255.f, 53.0f / 255.f, 104.f / 255.f), glm::vec2(1.0f, 1.0f)));
	points.push_back(Point3D(glm::vec3(312.f, 107.f, 0.f), glm::vec3(27.f / 255.f, 53.0f / 255.f, 104.f / 255.f), glm::vec2(0.0f, 1.0f)));
	points.push_back(Point3D(glm::vec3(312.f, 131, 0.f), glm::vec3(13.0f / 255.f, 1.f, 254.f / 255.f), glm::vec2(0.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(312.f, 131.f, 0.f), glm::vec3(13.0f / 255.f, 1.f, 254.f / 255.f), glm::vec2(0.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(242.f, 131.f, 0.f), glm::vec3(13.0f / 255.f, 1.f, 254.f / 255.f), glm::vec2(1.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(242.f, 107.f, 0.f), glm::vec3(27.f / 255.f, 53.0f / 255.f, 104.f / 255.f), glm::vec2(1.0f, 1.0f)));

	for (int i = 0; i < 6; i += 6)
	{
		indexes.push_back(i); indexes.push_back(i + 1); indexes.push_back(i + 2);
		indexes.push_back(i + 3); indexes.push_back(i + 4); indexes.push_back(i + 5);
	}
	pLine3 = new CMesh(points, indexes);

	points.clear();
	indexes.clear();

	//********************** Part of the code where the mesh of painting is created ********************************


	points.push_back(Point3D(glm::vec3(-0.203f, -0.15f, 0.0f), glm::vec3(0.0f, 0.0f, 1.0f), glm::vec2(0.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(0.203f, -0.15f, 0.0f), glm::vec3(0.0f, 0.0f, 1.0f), glm::vec2(1.0f, 0.0f)));
	points.push_back(Point3D(glm::vec3(0.203f, 0.15f, 0.0f), glm::vec3(0.0f, 0.0f, 1.0f), glm::vec2(1.0f, 1.0f)));
	points.push_back(Point3D(glm::vec3(-0.203f, 0.15f, 0.0f), glm::vec3(0.0f, 0.0f, 1.0f), glm::vec2(0.0f, 1.0f)));

	indexes.push_back(0); indexes.push_back(1); indexes.push_back(2);
	indexes.push_back(2); indexes.push_back(3); indexes.push_back(0);

	pframe1 = new CMesh(points, indexes);

	points.clear();
	indexes.clear();




	std::string source;
	hInstance = GetModuleHandle(NULL);
	HRSRC hrsrc;

		hrsrc = FindResource(hInstance, MAKEINTRESOURCE(IDR_FILEOFF1), "FILEOFF");



	if (hrsrc)
	{
		HGLOBAL hGlob = LoadResource(hInstance, hrsrc);

		if (hGlob)
		{
			char* data = NULL;
			data = (char*)LockResource(hGlob);

			if (data)
			{
				DWORD dwResourceSize = SizeofResource(hInstance, hrsrc);

				if (0 != dwResourceSize)
				{
					// Use pLockedResource and dwResourceSize however you want
					source.assign(data, dwResourceSize);
				}
			}
		}
	}


	Resource_Off(source.c_str());
//	Serialize_Off("lcone.off");


	glGenLists(2);
	glNewList(1, GL_COMPILE);

		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	for (int i = 0; i < Np; i++)
	{

		glBegin(GL_POLYGON);
		for (int j = 0; j < Poli[i].nv; j++)
		{
			GLdouble nvect[3];

			nvect[0] = -Norm_Pv[Poli[i].ip[j]].x;
			nvect[1] = -Norm_Pv[Poli[i].ip[j]].y;
			nvect[2] = -Norm_Pv[Poli[i].ip[j]].z;

			glNormal3d(nvect[0], nvect[1], nvect[2]);

			if (i == 0) {
				if(j<2)
				glColor4f(0, 0, 1, 0.05f);
			    else
				glColor4f(0, 0, 1, 0.17f);
			}
			else {
				if (j>1)
					glColor4f(0, 0, 1, 0.f);
				else
					glColor4f(0, 0, 1, 0.17f);
			}


			GLdouble dvect[4] = { (Verti[Poli[i].ip[j]].x),
				(Verti[Poli[i].ip[j]].y), (Verti[Poli[i].ip[j]].z), 1.0 };
			glVertex4dv(dvect);
		}
		glEnd();

	}

	glEndList();


	glNewList(2, GL_COMPILE);

	glPolygonMode(GL_FRONT, GL_FILL);
	for (int i = 0; i < Np; i++)
	{

		glBegin(GL_POLYGON);
		for (int j = 0; j < Poli[i].nv; j++)
		{
			GLdouble nvect[3];

			nvect[0] = -Norm_Pv[Poli[i].ip[j]].x;
			nvect[1] = -Norm_Pv[Poli[i].ip[j]].y;
			nvect[2] = -Norm_Pv[Poli[i].ip[j]].z;

			glNormal3d(nvect[0], nvect[1], nvect[2]);

			if (i == 0) {
				if (j<2)
					glColor4f(1, 128/255.f, 0, 0.05f);
				else
					glColor4f(1, 128 / 255.f, 0, 0.17f);
			}
			else {
				if (j>1)
					glColor4f(1, 128 / 255.f, 0, 0.f);
				else
					glColor4f(1, 128 / 255.f, 0, 0.17f);
			}


			GLdouble dvect[4] = { (Verti[Poli[i].ip[j]].x),
				(Verti[Poli[i].ip[j]].y), (Verti[Poli[i].ip[j]].z), 1.0 };
			glVertex4dv(dvect);
		}
		glEnd();

	}

	glEndList();

	delete_points();

}

//Initialize the glut library
void InitGLEW()
{
	glewExperimental = GL_TRUE;
	if (glewInit() != GLEW_OK)
	{
		std::cerr << "There was a problem initializing GLEW. Exiting..." << std::endl;
		getchar();
		exit(-1);
	}

	// Check for 3.3 support.
	// I've specified that a 3.3 forward-compatible context should be created.
	// so this parameter check should always pass if our context creation passed.
	// If we need access to deprecated features of OpenGL, we should check
	// the state of the GL_ARB_compatibility extension.
	if (!GLEW_VERSION_3_3)
	{
		std::cerr << "OpenGL 3.3 required version support not present." << std::endl;
		getchar();
		exit(-1);
	}

#ifdef _WIN32
	if (WGLEW_EXT_swap_control)
	{
		wglSwapIntervalEXT(0); // Disable vertical sync
	}
#endif
}

//-------------------------------------------------------------------------
//  This function sets the window and the program
//  when the resolution changes
//-------------------------------------------------------------------------
void chngResolution( int indchres)
{
	indchResol = indchres;

	glBindTexture(GL_TEXTURE_2D, g_texID[0]);
	glDeleteTextures(1, g_texID);

	lensD = chResol[indchResol].lensd;

	switch (indchres) {
	case 0:  
		window_width = iScreenWidth = 960;
		window_height = iScreenHeight = 720;
		break;
	case 1:  
		window_width = iScreenWidth = 640;
		window_height = iScreenHeight = 480;
		xx = 20;
		yy = 20;
		break;
	case 2:  
		window_width = iScreenWidth = 1024;
		window_height = iScreenHeight = 768;
		break;
	}


	// Create and load texture to OpenGL 
	glGenTextures(1, g_texID); // Texture name generation 
	glBindTexture(GL_TEXTURE_2D, g_texID[0]);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE); // automatic mipmap generation included in OpenGL v1.4
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, iScreenWidth, iScreenHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0);

}

//Initialize the program and hide the console 
void timeout()
{
	HANDLE hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
	SetConsoleTextAttribute(hStdout,
		FOREGROUND_GREEN | FOREGROUND_INTENSITY);

	cout << "Xylitol MusicDisk #1 (32-bit) - Welcome Home :: Released at Revision 2020 \n\n" << flush;

	cout << "Note that you can also move the music manually with the up/down arrow keys...\n" << flush;

	SetConsoleTextAttribute(hStdout,
		FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);

	for (int cntr = 3; cntr > 0; cntr--)
	{
		cout << "\r" << cntr << flush;
		Sleep(1000);
	}
	cout << "\r" << flush;


	swm = SCREEN_WIDTH >= glutGet(GLUT_SCREEN_WIDTH);
	shm = SCREEN_HEIGHT >= glutGet(GLUT_SCREEN_HEIGHT);

	if (swm || shm)
	{
		if (swm && shm) {
			if ((960 < glutGet(GLUT_SCREEN_WIDTH)) && (720 < glutGet(GLUT_SCREEN_HEIGHT)))
			{
				indchResol = 0;
				iScreenHeight = 720;
				iScreenWidth = 960;

			}
			else {
				indchResol = 1;
				iScreenHeight = 480;
				iScreenWidth = 640;
			}
		}
		else
		{
			if (swm) {
				if (960 < glutGet(GLUT_SCREEN_WIDTH))
				{
					indchResol = 0;
					iScreenHeight = 720;
					iScreenWidth = 960;
				}
				else {
					indchResol = 1;
					iScreenHeight = 480;
					iScreenWidth = 640;
				}
			}
			else
			{
				if (720 < glutGet(GLUT_SCREEN_HEIGHT))
				{
					indchResol = 0;
					iScreenHeight = 720;
					iScreenWidth = 960;
				}
				else {
					indchResol = 1;
					iScreenHeight = 480;
					iScreenWidth = 640;
				}
			}

		}

	}

	if (indchResol < 2) {
		window_height = iScreenHeight;
		window_width  = iScreenWidth;
		indResProg = indchResol;
	}
	else
		indResProg = indchResol;

}

//-------------------------------------------------------------------------
//  This function sets the window x and y coordinates
//  such that the window becomes centered
//-------------------------------------------------------------------------
void centerOnScreen()
{
	window_x = (glutGet(GLUT_SCREEN_WIDTH) - window_width) / 2;
	window_y = (glutGet(GLUT_SCREEN_HEIGHT) - window_height) / 2;
}

//Main program entry
int main(int argc, char **argv)
{
	g_PreviousTicks = std::clock();
	// init GLUT and create window
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGBA);


	cout << "Preparing to hide the console window\n\n";
	timeout();
	ShowWindow(GetConsoleWindow(), SW_HIDE);

	//  Set the window x and y coordinates such that the 
	//  window becomes centered
	centerOnScreen();

	glutInitWindowPosition(window_x, window_y - 30);
	glutInitWindowSize(window_width, window_height);
	glutCreateWindow(window_title);

	// register callbacks
	glutReshapeFunc(reshape);
	glutDisplayFunc(renderScene);
	glutIdleFunc(renderScene);

	glutSpecialFunc(pressKey);

	// here are the new entries
	glutIgnoreKeyRepeat(1);
	glutKeyboardFunc(keyboard);

	glutMotionFunc(MouseMove);

	InitGLEW();

	//  Set OpenGL program initial state.
	init();



	GLuint vertexShader = LoadShader_FResource(GL_VERTEX_SHADER, IDR_VSHADER1);
	GLuint fragmentShader = LoadShader_FResource(GL_FRAGMENT_SHADER, IDR_FSHADER1);

	std::vector<GLuint> shaders;
	shaders.push_back(vertexShader);
	shaders.push_back(fragmentShader);

	// Initialize Shader
	g_shaderID = CreateShaderProgram(shaders);
	assert(g_shaderID);

	// Initialize uniforms' IDs
	glUseProgram(g_shaderID);
	modelLoc = glGetUniformLocation(g_shaderID, "model");
	viewLoc = glGetUniformLocation(g_shaderID, "view");
	projLoc = glGetUniformLocation(g_shaderID, "projection");
	glUseProgram(0);

	shaders.clear();

	vertexShader = LoadShader_FResource(GL_VERTEX_SHADER, IDR_VSHADER2);
	fragmentShader = LoadShader_FResource(GL_FRAGMENT_SHADER, IDR_FSHADER2);

	shaders.push_back(vertexShader);
	shaders.push_back(fragmentShader);

	g_shaderID1 = CreateShaderProgram(shaders);
	fflush(stdout);
	assert(g_shaderID1);

	// Initialize uniforms' IDs
	glUseProgram(g_shaderID1);
	modelLoc1 = glGetUniformLocation(g_shaderID1, "model");
	viewLoc1 = glGetUniformLocation(g_shaderID1, "view");
	projLoc1 = glGetUniformLocation(g_shaderID1, "projection");
	glUseProgram(0);


	if (BHorzScroll::HorzScroll::load("scroller.txt") == 0)
	{
		BHorzScroll::HorzScroll::initBFFtext2D("data/Textures/Air Americana.bff");
	}
	else
	{
		printf("File scroller.txt not found. Press enter to finish-->"); getchar(); return 0;
	}


	updateCameraVectors();

	createObjects();

	BtextureID = LoadTexture("data/Textures/2020_Xylitol_1.png");
	BtextureID1 = LoadTexture("data/Textures/2020_Xylitol_1a.png", true);
	BtextureID2 = LoadTexture("data/Textures/2020_Xylitol_4.png", true);

	CoverTexID = LoadTexture("data/Textures/Covers/cover.png", true);
	BackTexID = LoadTexture("data/Textures/Covers/back.png", true);

//	LnsID = LoadTexture("data/Textures/Camera-Lens.png", true);

	// Initialize our little text library with the Verdana font
	Textfont::Ifont::initText2D("data/Textures/Verdana.bff");

	//Start playing the song
	sound_system->play_music();
	sound_system->update();//*********************

//*****************************************************************************************

	glReadBuffer(GL_BACK);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

	// Create and load texture to OpenGL 
	glGenTextures(1, g_texID); // Texture name generation 
	glBindTexture(GL_TEXTURE_2D, g_texID[0]);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE); // automatic mipmap generation included in OpenGL v1.4
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, iScreenWidth, iScreenHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0);

//*****************************************************************************************

	lensArrayA = new int[lensD*lensD];
	lensArrayB = new int[lensD*lensD];

	magnifglass::lensmagnif::Len_transf_fast(lensD, 250);

	lensD = 638;
	lensArrayALR = new int[638 * 638];
	lensArrayBLR = new int[638 * 638];

	magnifglass::lensmagnif::Len_transf_fastLR(638, 250);

	if (indchResol < 2)
		lensD = chResol[indchResol].lensd;
	else
		lensD = 768;  // Lens diameter

	// enter GLUT event processing cycle
	glutMainLoop();

	delete[] lensArrayA;
	delete[] lensArrayB;

	delete[] lensArrayALR;
	delete[] lensArrayBLR;

	SOIL_free_image_data(backg_image);
	SOIL_free_image_data(Lpixels);
	Textfont::Ifont::cleanupText2D();
	return 1;
}

// when size changed
void reshape(int width, int height)
{


		swm = iScreenWidth <= width;
		shm = iScreenHeight <= height;

		if (swm && shm && (indchResol == indResProg)) {
			window_width = width;
			window_height = height;
		}
		else
		{
			swm = iScreenWidth > width;
			shm = iScreenHeight > height;
			if (swm || shm)
			{
				if (((width <= 640) || (height <= 480)) && (indchResol == indResProg) && (indResProg != 1))
				{

					chngResolution(1);
					glutReshapeWindow(window_width, window_height);

				}
				else
				{
					window_width = iScreenWidth;
					window_height = iScreenHeight;

					glutReshapeWindow(window_width, window_height);
				}
			}
			else
			{
				int W, H;

				switch (indResProg) {
				case 0:
					W = 960; H = 720;
					break;
				case 2:
					W = 1024; H = 768;
					break;
				}

				if ((width < W) && (height < H))
				{
					window_width = width;
					window_height = height;
				}
				else
				{
					chngResolution(indResProg);
					glutReshapeWindow(window_width, window_height);

				}

			}
		}

		glViewport(0, 0, iScreenWidth, iScreenHeight);	// sets the viewport


}

//program startup settings
void init()
{
	glClearDepth(1.0);									// Enables Clearing Of The Depth Buffer
	glEnable(GL_POLYGON_SMOOTH);                        // Use Line smooting
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);

	glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);

	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing


	ReSdata rtemp;
	rtemp.HScrl = 640;
	rtemp.lensd = 720;
	rtemp.linTx = 320.f;
	rtemp.linTy = -30.f;
	rtemp.SlampX = 210.f;
	rtemp.SlampY = 220.f;
	rtemp.texX = 370.f;
	rtemp.texY = 70.f;
	rtemp.texY1 = 110.f;
	rtemp.tlamp1X = 356.f;
	rtemp.tlamp1Y = 70.f;
	rtemp.tlamp2X = 739.f;
	rtemp.tlamp2Y = 258.f;
	rtemp.VScrl = 410;

	chResol.push_back(rtemp);

	rtemp.HScrl = 640;
	rtemp.lensd = 638;
	rtemp.linTx = 155.f;
	rtemp.linTy = -70.f;
	rtemp.SlampX = 134.f;
	rtemp.SlampY = 142.f;
	rtemp.texX = 220.f;
	rtemp.texY = 30.f;
	rtemp.texY1 = 60.f;
	rtemp.tlamp1X = 238.f;
	rtemp.tlamp1Y = 47.f;
	rtemp.tlamp2X = 462.f;
	rtemp.tlamp2Y = 161.f;
	rtemp.VScrl = 280;

	chResol.push_back(rtemp);


	rtemp.HScrl = 640;
	rtemp.lensd = 768;
	rtemp.linTx = 355.f;
	rtemp.linTy = -20.f;
	rtemp.SlampX = 215.f;
	rtemp.SlampY = 227.f;
	rtemp.texX = 400.f;
	rtemp.texY = 80.f;
	rtemp.texY1 = 130.f;
	rtemp.tlamp1X = 380.f;
	rtemp.tlamp1Y = 75.f;
	rtemp.tlamp2X = 739.f;
	rtemp.tlamp2Y = 258.f;
	rtemp.VScrl = 480;

	chResol.push_back(rtemp);

	if (indchResol < 2)
		lensD = chResol[indchResol].lensd;


	//Check some values
	std::cout << "Using OpenGL version: " << glGetString(GL_VERSION) << std::endl;
	std::cout << "Rendering with: " << glGetString(GL_RENDERER) << std::endl;

	// find sounds
	music = getFilesOfDirectory("data/sound/", "*.mp3");

	// trim
	for (auto ptr : music) {
		std::size_t pos = ptr.find(".mp3");
		std::string music_file = ptr.substr(0, pos);
		music_text.push_back(music_file);
	}

	std::string music_file = "data/sound/" + music[0];
	sound_system = new sound_system_c(music_file.c_str());

	magnifglass::lensmagnif::initSpectrumBar();


}

//Final part of the scene rendering
void endDraw(void) {


	//  Set the frame buffer clear color to black. 
	glClearColor(0.0, 0.0, 0.0, 1.0);
	// Clear Color and Depth Buffers
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	float W = iScreenWidth;
	float H = iScreenHeight;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, W, 0, H, -10.0, 10.0);

	// switch to modelview matrix in order to set scene
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	gluLookAt(0, 0, 5, 0, 0, 0, 0, 1, 0);

    //Rendering of the texture in the frame buffer
	glColor4f(1, 1, 1, 1);

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, g_texID[0]);

	glBegin(GL_QUADS);
	// front faces
	glNormal3f(0, 0, 1);
	glTexCoord2f(0, 0);  glVertex3f(0, 0, 0);
	glTexCoord2f(1, 0);  glVertex3f(W, 0, 0);
	glTexCoord2f(1, 1);  glVertex3f(W, H, 0);
	glTexCoord2f(0, 1);  glVertex3f(0, H, 0);
	glEnd();

	glBindTexture(GL_TEXTURE_2D, 0);
	glDisable(GL_TEXTURE_2D);


	//Rendering of objects that simulate lighting
	glPushMatrix();

	glRotatef(30.f, 0.f, 0.f, 1.f);
	if (indchResol < 2)
	{
		glTranslatef(chResol[indchResol].tlamp1X, chResol[indchResol].tlamp1Y, 0.f);
		glScaled(chResol[indchResol].SlampX, chResol[indchResol].SlampY, 0.f);
	}
	else
	{
		glTranslatef(380.f, 75.f, 0.f);
		glScaled(215.f, 227.f, 0.f);
	}


	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);                                 
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);


	glCallList(1);

	glPopMatrix();


	glPushMatrix();

	if (indchResol < 2)
	{
		glTranslatef(chResol[indchResol].tlamp2X, chResol[indchResol].tlamp2Y, 0.f);
		glRotatef(-30.f, 0.f, 0.f, 1.f);
		glScaled(chResol[indchResol].SlampX, chResol[indchResol].SlampY, 0.f);
	}
	else
	{
		glTranslatef(739.f, 258.f, 0.f);
		glRotatef(-30.f, 0.f, 0.f, 1.f);
		glScaled(215.f, 227.f, 0.f);
	}



	glCallList(2);


	glPopMatrix();

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);


	rI_offscreen(0); // rendering offscreen

//********************************************************************************************

  //Final, Rendering of the texture in the frame buffer


  //  Set the frame buffer clear color to black. 
	glClearColor(0.0, 0.0, 0.0, 1.0);
	// Clear Color and Depth Buffers
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	W = window_width;
	H = window_height;

	glViewport(0, 0, W, H);	// sets the viewport

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, W, 0, H, -10.0, 10.0);

	// switch to modelview matrix in order to set scene
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	gluLookAt(0, 0, 5, 0, 0, 0, 0, 1, 0);


	glColor4f(1, 1, 1, 1);

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, g_texID[0]);

	glBegin(GL_QUADS);
	// front faces
	glNormal3f(0, 0, 1);
	glTexCoord2f(0, 0);  glVertex3f(0, 0, 0);
	glTexCoord2f(1, 0);  glVertex3f(W, 0, 0);
	glTexCoord2f(1, 1);  glVertex3f(W, H, 0);
	glTexCoord2f(0, 1);  glVertex3f(0, H, 0);
	glEnd();

	glBindTexture(GL_TEXTURE_2D, 0);
	glDisable(GL_TEXTURE_2D);




	glFlush();
	glutSwapBuffers();

	glViewport(0, 0, iScreenWidth, iScreenHeight);	// sets the viewport

	Sleep((1000 / 125) - 1);
}

//Main part of the scene rendering
void renderScene(void) {

	static float cnt = 0.f;
	static int frames = 0.f;
	static float lmov = -0.35f;

	g_CurrentTicks = std::clock();
	float deltaTicks = (float)(g_CurrentTicks - g_PreviousTicks);
	g_PreviousTicks = g_CurrentTicks;

	float fDeltaTime = deltaTicks / (float)CLOCKS_PER_SEC;

	cnt += fDeltaTime;


	if (cnt <= 1.2f) {
		frames++;
	}
	else
	{
		frames = 0;
		cnt = 0;
	}

	sound_system->update(); //***********************

	if (stopRend) {  // don't erase or you will pay your dare (Visual Studio)
		actStopR = TRUE;
		return;
	}

	//Rendering of the cover and equalizer
	renderEqViewer();
	rI_offscreen(0);   // rendering offscreen


 //The covers and equalizer is placed in position

	//  Set the frame buffer clear color to black. 
	glClearColor(0.0, 0.0, 0.0, 1.0);
	// Clear Color and Depth Buffers
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);


	g_projection = glm::perspective(MY_PI / 4.0f, (float)iScreenWidth / (float)iScreenHeight, 0.1f, 100.0f);

	g_view = glm::lookAt(Position, Front, Up);

	lumi = NOLUMI;

	// Bind shader
	glUseProgram(g_shaderID1);


	// Now render. 
	glUniformMatrix4fv(projLoc1, 1, GL_FALSE, glm::value_ptr(g_projection));
	glUniformMatrix4fv(viewLoc1, 1, GL_FALSE, glm::value_ptr(g_view));


	if (indchResol == 1)
		g_model = glm::translate(glm::mat4(1.0f), glm::vec3(0.f, 0.f, -2.34f));
	else
		g_model = glm::translate(glm::mat4(1.0f), glm::vec3(0.f, 0.f, -2.39f));

	g_model = glm::scale(g_model, glm::vec3(2.5f, 2.5f, 2.5f));
	glUniformMatrix4fv(modelLoc1, 1, GL_FALSE, glm::value_ptr(g_model));
	glUniform1i(glGetUniformLocation(g_shaderID1, "Rendr"), lumi);

	// Bind texture
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, g_texID[0]);

	// Set our "myTextureSampler" sampler to use Texture Unit 0
	glUniform1i(glGetUniformLocation(g_shaderID1, "myTextureSampler"), 0);


	pframe1->render();

	glUseProgram(0);
	glBindTexture(GL_TEXTURE_2D, 0);


	//Rendering of the background with their respective images

	// Transformation matrices
	g_projection = glm::perspective(MY_PI / 4.0f, (float)iScreenWidth / (float)iScreenHeight, 0.1f, 100.0f);

	g_view = glm::lookAt(Position, Front, Up);

	lumi = NOLUMI;



	// Bind shader
	glUseProgram(g_shaderID1);


	// Bind texture
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, BtextureID);

	// Set our "myTextureSampler" sampler to use Texture Unit 0
	glUniform1i(glGetUniformLocation(g_shaderID1, "myTextureSampler"), 0);

	// Now render. 
	glUniformMatrix4fv(projLoc1, 1, GL_FALSE, glm::value_ptr(g_projection));
	glUniformMatrix4fv(viewLoc1, 1, GL_FALSE, glm::value_ptr(g_view));
	if (indchResol == 1)
    	g_model = glm::translate(glm::mat4(1.0f), glm::vec3(0.f, 0.f, -2.358f));
	else
		g_model = glm::translate(glm::mat4(1.0f), glm::vec3(0.f, 0.f, -2.408f));

	g_model = glm::scale(g_model, glm::vec3((float)iScreenWidth / (float)iScreenHeight, 1.0f, 1.0f));
	glUniformMatrix4fv(modelLoc1, 1, GL_FALSE, glm::value_ptr(g_model));
	glUniform1i(glGetUniformLocation(g_shaderID1, "Rendr"), lumi);

	pframe->render();



//***********************************************************************************
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);                                 
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

// Bind texture
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, BtextureID2);

	pframe->render();


// Bind texture
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, BtextureID1);

	pframe->render();


	glUseProgram(0);
	glBindTexture(GL_TEXTURE_2D, 0);
	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);

	//Horizontal scroll rendering
	if(indchResol < 2)
		BHorzScroll::HorzScroll::draw(chResol[indchResol].HScrl, chResol[indchResol].VScrl);
	else	
		BHorzScroll::HorzScroll::draw(640, 480);

	//memory rendering copy
	glReadPixels(0, 0, iScreenWidth, iScreenHeight, GL_RGBA, GL_UNSIGNED_BYTE, backg_image);

//***********************************************************************************

	//Frame buffer update, and offscreen before lens effect

//  Set the frame buffer clear color to black. 
	glClearColor(0.0, 0.0, 0.0, 1.0);
	// Clear Color and Depth Buffers
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);


	// Bind shader
	glUseProgram(g_shaderID1);

	// Bind texture
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, g_texID[0]);
	glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, iScreenWidth, iScreenHeight, GL_RGBA, GL_UNSIGNED_BYTE, backg_image);

	pframe->render();

	glBindTexture(GL_TEXTURE_2D, 0);

	glReadPixels(0, 0, iScreenWidth, iScreenHeight, GL_RGBA, GL_UNSIGNED_BYTE, backg_image);
	memcpy(Lpixels, backg_image, (4 * iScreenWidth * iScreenHeight));

//***********************************************************************************
	//Rendering with the lens effect

//  Set the frame buffer clear color to black. 
	glClearColor(0.0, 0.0, 0.0, 1.0);
	// Clear Color and Depth Buffers
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	if (indchResol == 1)
		magnifglass::lensmagnif::updatePixels_fastLR(xx, yy, iScreenWidth, iScreenHeight, Lpixels, backg_image);
	else
		magnifglass::lensmagnif::updatePixels_fast(xx, yy, iScreenWidth, iScreenHeight, Lpixels, backg_image);



	// Bind texture
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, g_texID[0]);
	glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, iScreenWidth, iScreenHeight, GL_RGBA, GL_UNSIGNED_BYTE, Lpixels);

	pframe->render();

	glBindTexture(GL_TEXTURE_2D, 0);


	// Bounce lens around the screen
	if ((xx + dx + lensD > iScreenWidth + 200) || (xx + dx < -200)) {
		dx = -dx;
	}
	if ((yy + dy + lensD > iScreenHeight + 350) || (yy + dy < -200)) {
		dy = -dy;
	}

	if(frames > 0)
	xx += dx;
	yy += dy;


	glUseProgram(0);

//***********************************************************************************

  // Last part, placing the line and the text of the tracks, and doing the offscreen 
  // to perform the final part of the rendering
 
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);              
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	// Bind shader
	glUseProgram(g_shaderID1);
	lumi = OBJLUMI;

	g_projection = glm::ortho(0.f, (float)iScreenWidth, 0.f, (float)iScreenHeight, -1.f, 1.f);
	g_view = glm::mat4(1.0f);
	// Now render. 
	glUniformMatrix4fv(projLoc1, 1, GL_FALSE, glm::value_ptr(g_projection));
	glUniformMatrix4fv(viewLoc1, 1, GL_FALSE, glm::value_ptr(g_view));
	if(indchResol < 2)
		g_model = glm::translate(glm::mat4(1.0f), glm::vec3(chResol[indchResol].linTx, chResol[indchResol].linTy, 0.f));
	else
	g_model = glm::translate(glm::mat4(1.0f), glm::vec3(355.f, -20.f, 0.f));
	glUniformMatrix4fv(modelLoc1, 1, GL_FALSE, glm::value_ptr(g_model));
	glUniform1i(glGetUniformLocation(g_shaderID1, "Rendr"), lumi);


	pLine1->render();

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);

	pLine2->render();

	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);        
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	pLine3->render();

	glUseProgram(0);


	//Selection of the corresponding track with its index
	if (sound_system->Cmusic == 0) {
		if (music.size() > 1)
		{
			if (mIndx < music.size() - 1)
			{
				mIndx++;
				std::string music_file = "data/sound/" + music[mIndx];
				//ReStart playing the song
				sound_system->change_play_music(music_file.c_str());
			}
			else
			{
				mIndx = 0;
				std::string music_file = "data/sound/" + music[mIndx];
				//ReStart playing the song
				sound_system->change_play_music(music_file.c_str());

			}
		}
		else
		{
			std::string music_file = "data/sound/" + music[mIndx];
			//ReStart playing the song
			sound_system->change_play_music(music_file.c_str());
		}

	}



	char text[256] = { '\0' };

	if (mIndx == 0)
	{
		Textfont::Ifont::SetColor(1.0f, 1.f, 0.3f);
		sprintf(text, "%s", music_text[mIndx].c_str());

		if (indchResol < 2)
			Textfont::Ifont::printText2D(text, chResol[indchResol].texX, chResol[indchResol].texY);
		else
			Textfont::Ifont::printText2D(text, 400, 80);

/*		if (music_text.size() > 1)
		{
			pf.SetColor(1.0f, 1.0f, 1.0f, 0.4f);
			sprintf(text, "%s", music_text[mIndx + 1].c_str());
			pf.printText2D(text, 400, 30);
		}*/
	}
	else
		if (mIndx == music_text.size()-1)
		{
			Textfont::Ifont::SetColor(1.0f, 1.f, 0.3f);
			sprintf(text, "%s", music_text[mIndx].c_str());
			if (indchResol < 2)
				Textfont::Ifont::printText2D(text, chResol[indchResol].texX, chResol[indchResol].texY);
			else
				Textfont::Ifont::printText2D(text, 400, 80);

			if (music_text.size() > 1)
			{
				Textfont::Ifont::SetColor(1.0f, 1.0f, 1.0f, 0.4f);
				sprintf(text, "%s", music_text[mIndx - 1].c_str());
				if (indchResol < 2)
					Textfont::Ifont::printText2D(text, chResol[indchResol].texX, chResol[indchResol].texY1);
				else
					Textfont::Ifont::printText2D(text, 400, 130);
			}
		}
		else
		{
			Textfont::Ifont::SetColor(1.0f, 1.f, 0.3f);
				sprintf(text, "%s", music_text[mIndx].c_str());
				if (indchResol < 2)
					Textfont::Ifont::printText2D(text, chResol[indchResol].texX, chResol[indchResol].texY);
				else
					Textfont::Ifont::printText2D(text, 400, 80);

				Textfont::Ifont::SetColor(1.0f, 1.0f, 1.0f, 0.4f);
//				sprintf(text, "%s", music_text[mIndx + 1].c_str());
//				pf.printText2D(text, 400, 30);
				sprintf(text, "%s", music_text[mIndx - 1].c_str());
				if (indchResol < 2)
					Textfont::Ifont::printText2D(text, chResol[indchResol].texX, chResol[indchResol].texY1);
				else
					Textfont::Ifont::printText2D(text, 400, 130);
		}




	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);



	rI_offscreen(0);  //Rendering offscreen
	endDraw();

}

// render Equalizer viewer into opengl window
void renderEqViewer()
{

	//  Set the frame buffer clear color to black. 
	glClearColor(0.0, 0.0, 0.0, 1.0);
	// Clear Color and Depth Buffers
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);


	if (sound_system->Cmusic > 0)
	{
		//Get spectrum
		sound_system->get_spectrum(spectrumL, spectrumR);
	}

	memset(visualizationBuffer, 0, SPECTRUMSIZE);

	magnifglass::lensmagnif::smoothSpectrumBar();

	static int timefade = 0;
	static int fadinout = 1;
	static int chng = 6;

	g_projection = glm::perspective(MY_PI / 4.0f, (float)iScreenWidth / (float)iScreenHeight, 0.1f, 100.0f);

	g_view = glm::lookAt(Position, Front, Up);


	lumi = FADEOUTIN;

	if (timefade > 512)
	{
		if ((fadinout > 0) && (fadinout < 3000))
		{
			fadinout += chng;
		}
		else
		{
			chng = -chng;
			fadinout += chng;
			timefade = 0;
		}

	}
	else
		timefade++;

	// Bind shader
	glUseProgram(g_shaderID1);

	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	// Now render. 
	glUniformMatrix4fv(projLoc1, 1, GL_FALSE, glm::value_ptr(g_projection));
	glUniformMatrix4fv(viewLoc1, 1, GL_FALSE, glm::value_ptr(g_view));


	// Now render. 
	g_model = glm::translate(glm::mat4(1.0f), glm::vec3(0.f, 0.f, -2.5f));
	g_model = glm::scale(g_model, glm::vec3((float)iScreenWidth / (float)iScreenHeight, 1.0f, 1.0f));
	glUniformMatrix4fv(modelLoc1, 1, GL_FALSE, glm::value_ptr(g_model));
	glUniform1i(glGetUniformLocation(g_shaderID1, "Rendr"), lumi);
	glUniform1f(glGetUniformLocation(g_shaderID1, "fade"), 1.f - ((float)fadinout/3000.f));

	// Bind texture
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, CoverTexID);

	// Set our "myTextureSampler" sampler to use Texture Unit 0
	glUniform1i(glGetUniformLocation(g_shaderID1, "myTextureSampler"), 0);


	pframe->render();

	glUniform1f(glGetUniformLocation(g_shaderID1, "fade"), ((float)fadinout / 3000.f));

	// Bind texture
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, BackTexID);


	pframe->render();

	glUseProgram(0);
	glBindTexture(GL_TEXTURE_2D, 0);
	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);



// Bind shader
	glUseProgram(g_shaderID);

	// Now render. 
	glUniformMatrix4fv(projLoc, 1, GL_FALSE, glm::value_ptr(g_projection));
	glUniformMatrix4fv(viewLoc, 1, GL_FALSE, glm::value_ptr(g_view));
	g_model = glm::translate(glm::mat4(1.0f), glm::vec3(0.f, 0.f, -0.2f));
	glUniformMatrix4fv(modelLoc, 1, GL_FALSE, glm::value_ptr(g_model));

	glUniform2f(glGetUniformLocation(g_shaderID, "resolution"), iScreenWidth, iScreenHeight);
	glUniform1fv(glGetUniformLocation(g_shaderID, "audioSampleData"), SPECTRUM_VIEW, visualizationBuffer);

	pframe->render();

	glUseProgram(0);

}


//copy the rendering in the frame buffer
void rI_offscreen( GLuint tID)
{

	glBindTexture(GL_TEXTURE_2D, g_texID[tID]);
	//store the texture ID mapping

	glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, iScreenWidth, iScreenHeight);


	glBindTexture(GL_TEXTURE_2D, 0);


}


// when mouse is moved
void MouseMove(int x, int y)
{
	if (g_leftPressed || g_rightPressed) {
		/* Only do mouse motion when the buttons are down! */

	}

}


//-------------------------------------------------------------------------
//  This function is passed to the glutKeyboardFunc and is called 
//  whenever the user hits a Special key.
//-------------------------------------------------------------------------
void pressKey(int key, int xx, int yy) {

	switch (key) {
	case GLUT_KEY_LEFT:  break;
	case GLUT_KEY_RIGHT:  break;
	case GLUT_KEY_UP:   
		if (mIndx > 0)
		{
			mIndx--;
			std::string music_file = "data/sound/" + music[mIndx];
			//ReStart playing the song
			sound_system->change_play_music(music_file.c_str());
		}
		break;
	case GLUT_KEY_DOWN:  
		if (mIndx < music.size()-1)
		{
			mIndx++;
			std::string music_file = "data/sound/" + music[mIndx];
			//ReStart playing the song
			sound_system->change_play_music(music_file.c_str());
		}
		break;
	case GLUT_KEY_PAGE_UP:  break;
	}
}


//-------------------------------------------------------------------------
//  This function is passed to the glutKeyboardFunc and is called 
//  whenever the user hits a key.
//-------------------------------------------------------------------------
void keyboard(unsigned char key, int x, int y)
{
	//  Print what key the user is hitting
	printf("User is hitting the '%c' key.\n", key);
	printf("ASCII code is %d.\n", key);
	time_t newt;

	switch (key)
	{
		//  User hits A key
	case 'a':
		//  User hits Shift + A key
	case 'A':
		break;

		//  User hits r key
	case 'r':
		//  User hits Shift + R key
	case 'R':
		break;

		//  User hits s key
	case 's':
		//  User hits Shift + S key
	case 'S':
		break;


		//  User hits Enter
	case '\r':
		printf("User is hitting the Return key.\n");
		break;

		//  User hits Space
	case ' ':
		printf("User is hitting the Space key.\n");
		break;

		//  User hits back space
	case 8:
		printf("User is hitting the Back Space key.\n");
		break;

		//  User hits ESC key
	case 27:
		exit(1);
		break;
	}

}

//camera setup for gllookAt function
void updateCameraVectors()
{
	// Calculate the new Front vector
	glm::vec3 front;
	front.x = cos(glm::radians(Yaw)) * cos(glm::radians(Pitch));
	front.y = sin(glm::radians(Pitch));
	front.z = sin(glm::radians(Yaw)) * cos(glm::radians(Pitch));
	Front = glm::normalize(front);
	// Also re-calculate the Right and Up vector
	Right = glm::normalize(glm::cross(Front, WorldUp));  // Normalize the vectors, because their length gets closer to 0 the more you look up or down which results in slower movement.
	Up = glm::normalize(glm::cross(Right, Front));
}

//Create and load textures in memory
GLuint LoadTexture(const std::string& file, bool MN)
{
		GLuint textureID;

	if (!MN) {
		// Load, create textures and generate mipmaps
		backg_image = SOIL_load_image(file.c_str(), &Iwidth, &Iheight, 0, SOIL_LOAD_RGBA);

		// request 1 texture name from OpenGL
		glGenTextures(1, &textureID);
		glBindTexture(GL_TEXTURE_2D, textureID);

		//	GLuint textureID = SOIL_load_OGL_texture(file.c_str(), SOIL_LOAD_AUTO, SOIL_CREATE_NEW_ID, SOIL_FLAG_MIPMAPS);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE); // automatic mipmap generation included in OpenGL v1.4
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, Iwidth, Iheight, 0, GL_RGBA, GL_UNSIGNED_BYTE, backg_image);

		glBindTexture(GL_TEXTURE_2D, 0);

		Lpixels = SOIL_load_image(file.c_str(), &Iwidth, &Iheight, 0, SOIL_LOAD_RGBA);
	}
	else
	{
		textureID = SOIL_load_OGL_texture(file.c_str(), SOIL_LOAD_AUTO, SOIL_CREATE_NEW_ID, SOIL_FLAG_MIPMAPS);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		glBindTexture(GL_TEXTURE_2D, 0);
	}

	return textureID;
}


// Loads a shader and returns the compiled shader object.
// If the shader source file could not be opened or compiling the 
// shader fails, then this function returns 0.
GLuint LoadShader(GLenum shaderType, const std::string& shaderFile)
{
	std::ifstream ifs;

	// Load the shader.
	ifs.open(shaderFile);

	if (!ifs)
	{
		std::cerr << "Can not open shader file: \"" << &shaderFile << "\"" << std::endl;
		return 0;
	}

	std::string source(std::istreambuf_iterator<char>(ifs), (std::istreambuf_iterator<char>()));
	ifs.close();

	// Create a shader object.
	GLuint shader = glCreateShader(shaderType);

	// Load the shader source for each shader object.
	const GLchar* sources[] = { source.c_str() };
	glShaderSource(shader, 1, sources, NULL);

	// Compile the shader.
	glCompileShader(shader);

	// Check for errors
	GLint compileStatus;
	glGetShaderiv(shader, GL_COMPILE_STATUS, &compileStatus);
	if (compileStatus != GL_TRUE)
	{
		GLint logLength;
		glGetShaderiv(shader, GL_INFO_LOG_LENGTH, &logLength);
		GLchar* infoLog = new GLchar[logLength];
		glGetShaderInfoLog(shader, logLength, NULL, infoLog);

#ifdef _WIN32
		OutputDebugString(infoLog);
		cout << "shader error: " << infoLog << endl << endl;
#else
		std::cerr << infoLog << std::endl;
#endif
		delete infoLog;
		return 0;
	}

	return shader;
}


// Loads a shader and returns the compiled shader object.
// If the shader source file could not be opened or compiling the 
// shader fails, then this function returns 0.
GLuint LoadShader_FResource(GLenum shaderType, const GLint shaderFile)
{
	std::string source;
	hInstance = GetModuleHandle(NULL);
	HRSRC hrsrc;

	if (shaderType == GL_VERTEX_SHADER)
		hrsrc = FindResource(hInstance, MAKEINTRESOURCE(shaderFile), "VSHADER");
	else
		hrsrc = FindResource(hInstance, MAKEINTRESOURCE(shaderFile), "FSHADER");



	if (hrsrc)
	{
		HGLOBAL hGlob = LoadResource(hInstance, hrsrc);

		if (hGlob)
		{
			char* data = NULL;
			data = (char*)LockResource(hGlob);

			if (data)
			{
				DWORD dwResourceSize = SizeofResource(hInstance, hrsrc);

				if (0 != dwResourceSize)
				{
					// Use pLockedResource and dwResourceSize however you want
					source.assign(data, dwResourceSize);
				}
			}
		}
	}


	// Create a shader object.
	GLuint shader = glCreateShader(shaderType);

	// Load the shader source for each shader object.
	const GLchar* sources[] = { source.c_str() };
	glShaderSource(shader, 1, sources, NULL);

	// Compile the shader.
	glCompileShader(shader);

	// Check for errors
	GLint compileStatus;
	glGetShaderiv(shader, GL_COMPILE_STATUS, &compileStatus);
	if (compileStatus != GL_TRUE)
	{
		GLint logLength;
		glGetShaderiv(shader, GL_INFO_LOG_LENGTH, &logLength);
		GLchar* infoLog = new GLchar[logLength];
		glGetShaderInfoLog(shader, logLength, NULL, infoLog);

#ifdef _WIN32
		OutputDebugString(infoLog);
		cout << "shader error: " << infoLog << endl << endl;
#else
		std::cerr << infoLog << std::endl;
#endif
		delete infoLog;
		return 0;
	}

	return shader;
}

// Create a shader program from a set of compiled shader objects.
GLuint CreateShaderProgram(std::vector<GLuint> shaders)
{
	// Create a shader program.
	GLuint program = glCreateProgram();

	// Attach the appropriate shader objects.
	for (GLuint shader : shaders)
	{
		glAttachShader(program, shader);
	}

	// Link the program
	glLinkProgram(program);

	// Check the link status.
	GLint linkStatus;
	glGetProgramiv(program, GL_LINK_STATUS, &linkStatus);
	if (linkStatus != GL_TRUE)
	{
		GLint logLength;
		glGetProgramiv(program, GL_INFO_LOG_LENGTH, &logLength);
		GLchar* infoLog = new GLchar[logLength];

		glGetProgramInfoLog(program, logLength, NULL, infoLog);

#ifdef _WIN32
		OutputDebugString(infoLog);
		cout << "Shaders link error: " << infoLog << endl;
#else
		std::cerr << infoLog << std::endl;
#endif

		delete infoLog;
		return 0;
	}

	return program;
}
