#version 430 compatibility
#extension GL_ARB_compute_shader : enable
#extension GL_ARB_shader_storage_buffer_object : enable
#define width 640
#define height 320
/*struct pos
{
	vec4 xyzw;
};
struct col
{
	vec4 rgba;
};*/
layout(  binding=9 ) buffer ParticlesPos
{
	vec4 Positions[];
};

layout(  binding=10 ) buffer Colors
{
	vec4 Col[  ];
};
layout(  binding=11 ) buffer ColorsOr
{
	vec4 ColOr[  ];
};

layout( binding=0 ) buffer dcF { int F[  ]; };
layout( binding=1 ) buffer dcU { float dU[  ]; };
layout( binding=2 ) buffer dcV { float dV[  ]; };
layout(location = 10) uniform float time;
layout( location=12) uniform float DT=0.01;
layout( location=13) uniform int integrateonoff=1;          // mode

layout( local_size_x = 100 ) in;



float rand(float seed)
{
	int a = int(100001*seed);
	a = (a * 125) % 2796203;
	return float(((a % 10000) + 1)-5000) / 10000.0;		// 0-1
}
void main()
{
	
	uint gid = gl_GlobalInvocationID.x;
	vec4 p = Positions[ gid ].xyzw;
	vec4 c = ColOr[ gid ].rgba;
	int i = int(p.x * width);
	int j = int(p.y * height);
	float u = 0;
	float v = 0;
	u = dU[i+j*width];
	v = dV[i+j*width];
	//#define EPS 0.0000001
	//if(sqrt(u*u+v*v)<EPS)
	//{
	//	p.x = rand(p.y);
	//	p.y = rand(p.x);
	//}
	#define RAND 0.0002
	if(F[i+j*width]==1)
	{
		p.x += rand(p.y)*RAND;
		p.y += rand(p.x)*RAND;
	}
	else
	{
		p.x += rand(p.y)*RAND;
		p.y += rand(p.x)*RAND;
	}
    float dt=0.013*DT*1.3;

    if(integrateonoff == 1)
        dt = -0.035*DT;

	//if(integrateonoff==1)
	{	
		p.x = p.x + u*dt;
		p.y = p.y + v*dt;
	}
	if(p.x > 1) {p.x -=1;} 
	if(p.x < 0) p.x += 1;
	if(p.y > 1) p.y -= 1;
	if(p.y < 0) p.y += 1;

//p.z = 0.2*sin(p.x*8+time*1.3);            // OK

   // if(integrateonoff == 0)
        p.z = 0.2*sin(p.x*8+time*1.3) + 0.07*(c.x);
    
      if(integrateonoff == 1)
            p.z = 0.29*sin(p.x*10+time*1.35) + 0.07*(c.x);
   /* if(integrateonoff == 1)
    {
       p.z = 0.35*sin(p.x*8+time*1.3) + 0.15*(c.x);
    }*/
    //p.z = 0.2*sin(p.x*8+time*1.0);
	//p.y += 0.0006*sin(p.y*0.5+time*1.5);
//	c *= (1.0+2.0*p.z)*(1.0+2.0*p.z)*(1.0+0.2*rand(p.x+p.y));

c *= (1.0+2.3*p.z)*(1.0+2.3*p.z)*(1.0+0.4*rand(p.x+p.y));
	Col[ gid ].rgba.xyzw = c;
	Positions[ gid ].xyzw = p.xyzw;
}


