/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.encoding.ContentType;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.StreamSOAPCodec;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

final class StreamSOAP12Codec
extends StreamSOAPCodec {
    public static final String SOAP12_MIME_TYPE = "application/soap+xml";
    public static final String DEFAULT_SOAP12_CONTENT_TYPE = "application/soap+xml; charset=utf-8";
    private static final List<String> EXPECTED_CONTENT_TYPES = Collections.singletonList("application/soap+xml");

    StreamSOAP12Codec() {
        super(SOAPVersion.SOAP_12);
    }

    StreamSOAP12Codec(WSBinding wSBinding) {
        super(wSBinding);
    }

    StreamSOAP12Codec(WSFeatureList wSFeatureList) {
        super(wSFeatureList);
    }

    @Override
    public String getMimeType() {
        return SOAP12_MIME_TYPE;
    }

    @Override
    protected com.sun.xml.internal.ws.api.pipe.ContentType getContentType(Packet packet) {
        ContentTypeImpl.Builder builder = this.getContenTypeBuilder(packet);
        if (packet.soapAction == null) {
            return builder.build();
        }
        builder.contentType = builder.contentType + ";action=" + this.fixQuotesAroundSoapAction(packet.soapAction);
        return builder.build();
    }

    @Override
    public void decode(InputStream inputStream, String string, Packet packet, AttachmentSet attachmentSet) throws IOException {
        ContentType contentType = new ContentType(string);
        packet.soapAction = this.fixQuotesAroundSoapAction(contentType.getParameter("action"));
        super.decode(inputStream, string, packet, attachmentSet);
    }

    private String fixQuotesAroundSoapAction(String string) {
        if (!(string == null || string.startsWith("\"") && string.endsWith("\""))) {
            String string2 = string;
            if (!string.startsWith("\"")) {
                string2 = "\"" + string2;
            }
            if (!string.endsWith("\"")) {
                string2 = string2 + "\"";
            }
            return string2;
        }
        return string;
    }

    @Override
    protected List<String> getExpectedContentTypes() {
        return EXPECTED_CONTENT_TYPES;
    }

    @Override
    protected String getDefaultContentType() {
        return DEFAULT_SOAP12_CONTENT_TYPE;
    }
}

