/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part16dottyobject;

import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.Object3D;
import abyss.lunarengine.gfx.Point3DzComparator;
import abyss.lunarengine.gfx.Tools2D;
import abyss.parallelmultiverse.part16dottyobject.Line;
import abyss.parallelmultiverse.part16dottyobject.LinePoint3D;
import abyss.parallelmultiverse.part16dottyobject.LineTo;
import java.util.Arrays;
import java.util.Vector;

public class Lineobject3D
extends Object3D {
    private Vector<LinePoint3D> vecPoints = new Vector();

    public int addPoint(LinePoint3D point) {
        this.vecPoints.add(point);
        return this.vecPoints.size() - 1;
    }

    public LinePoint3D getPoint(int index) {
        return this.vecPoints.get(index);
    }

    public void addLine(Line line) {
        LinePoint3D linePoint3D = this.vecPoints.get(line.pointIndex1);
        linePoint3D.addLineTo(new LineTo(this.vecPoints.get(line.pointIndex2), line.colors));
    }

    public void createArrays() {
        this.points = new LinePoint3D[this.vecPoints.size()];
        for (int i = 0; i < this.vecPoints.size(); ++i) {
            LinePoint3D point = this.vecPoints.get(i);
            point.shiftLeft();
            this.points[i] = point;
        }
        this.vecPoints = null;
    }

    public void render(Tools2D tools2D, int offsetX) {
        for (int i = 0; i < this.points.length; ++i) {
            Vector<LineTo> vecLinesTo = ((LinePoint3D)this.points[i]).vecLinesTo;
            if (vecLinesTo.size() == 0) continue;
            int z = this.points[i].dz + 500 >> 2;
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            for (int j = 0; j < vecLinesTo.size(); ++j) {
                LineTo lineTo = vecLinesTo.get(j);
                tools2D.pixel = lineTo.colors[z];
                tools2D.lightningLine(this.points[i].dx + offsetX, this.points[i].dy + Screen.screenCenterY, lineTo.linePoint3D.dx + offsetX, lineTo.linePoint3D.dy + Screen.screenCenterY);
            }
        }
    }

    public void rotateCALC() {
        super.rotateCALC();
        Arrays.sort(this.points, new Point3DzComparator());
    }
}

