/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part13tunnel;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.LordFader;
import abyss.lunarengine.gfx.PolarBear;
import abyss.lunarengine.gfx.Tools2D;
import abyss.lunarengine.sinatra.Sinatra;
import abyss.parallelmultiverse.part13tunnel.Ring;
import java.util.Vector;

public class PartTunnel
extends APart {
    public static final int BACKGROUNDCOLOR = 32;
    private static final int SHIFT = 12;
    public double lightningLinecountDelta;
    public double lightningLinecountDest;
    public double lightningRndDelta;
    public double lightningRndDest;
    public boolean enableRadiusDelta;
    public boolean enableAngleDelta;
    private double lightningLinecount;
    private double lightningRnd;
    private int newRingIndex;
    private int newRingDelayCount;
    private volatile int masterX;
    private volatile int masterY;
    private int masterXDelta;
    private int masterYDelta;
    private Sinatra sinatraX;
    private Sinatra sinatraY;
    private Sinatra sinatraR;
    private Sinatra sinatraA;
    private Vector<Ring> rings;
    private LordFader faderBackground;
    private static final int TUNNEL_RINGCOUNT = 64;
    private static final int TUNNEL_ANGLESTEP = 12;
    private static final int TUNNEL_POINTCOUNT = 30;
    private static final int TUNNEL_NEWRINGDELAY = 5;
    private static final int TABLESIZE = 320;
    private Tools2D tools2D;
    private int[] radTable = new int[320];
    private int[] colTable = new int[323];
    private Ring vbi_currentRing;
    private Ring worker_lastRing;
    private Ring worker_currentRing;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartTunnel partTunnel = new PartTunnel();
            ((APart)partTunnel).precalc();
            ((APart)partTunnel).initialize();
            LunarEngine.setActivePart(partTunnel);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public void precalc() {
        this.faderBackground = new LordFader(327941, 32, 240);
        this.tools2D = new Tools2D();
        this.sinatraX = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 460.0, 0.17578125, 0.0, 360.0, 250.0, 0.3515625, 0.0, 360.0, 0.0, 0.0, 0.0});
        this.sinatraY = Sinatra.getInstance(new double[]{2048.0, 2.0, 1.0, 0.703125, 0.0, 360.0, 260.0, 0.17578125, 0.0, 360.0, 250.0, 0.3515625, 0.0, 360.0, 0.0, 0.0, 0.0});
        this.sinatraR = Sinatra.getInstance(new double[]{3600.0, 3.0, 40.0, 0.3, 0.0, 360.0, 50.0, 0.5, 0.0, 360.0, 10.0, 2.0, 0.0, 360.0});
        this.sinatraA = Sinatra.getInstance(new double[]{185040.0, 3.0, 180.0, 0.5, 0.0, 360.0, 90.0, 0.7, 0.0, 360.0, 83.0, 1.0, 0.0, 360.0});
        for (int i = 0; i < 320; ++i) {
            this.radTable[i] = (int)(20.0 + 850.0 / ((double)(320 - i) / 20.0));
            this.colTable[i] = (int)(256.0 * (double)i / 320.0);
            this.colTable[i] = this.colTable[i] + (this.colTable[i] << 8) + (this.colTable[i] << 16);
        }
    }

    public void initialize() {
        this.rings = new Vector();
        for (int i = 0; i < 64; ++i) {
            this.rings.add(new Ring(30));
        }
        this.lightningLinecount = 1.0;
        this.lightningLinecountDelta = 0.0;
        this.lightningLinecountDest = this.lightningLinecount;
        this.lightningRnd = 1.0;
        this.lightningRndDelta = 0.0;
        this.lightningRndDest = this.lightningRnd;
        this.enableRadiusDelta = false;
        this.enableAngleDelta = false;
        this.newRingIndex = 0;
        this.newRingDelayCount = 5;
        this.masterX = 409600;
        this.masterY = 204800;
        this.masterXDelta = 0;
        this.masterYDelta = 0;
        this.sinatraX.setIndex(0);
        this.sinatraY.setIndex(0);
        this.sinatraR.setIndex(0);
        this.sinatraA.setIndex(0);
    }

    public void vbi() {
        for (int t = 0; t < 64; ++t) {
            this.vbi_currentRing = this.rings.get(t);
            ++this.vbi_currentRing.radiusIndex;
        }
        this.masterX += this.masterXDelta;
        this.masterY += this.masterYDelta;
        if (--this.newRingDelayCount == 0) {
            this.newRingDelayCount = 5;
            this.vbi_currentRing = this.rings.firstElement();
            this.rings.remove(0);
            this.rings.add(this.vbi_currentRing);
            this.vbi_currentRing.x = 0;
            this.vbi_currentRing.y = 0;
            this.vbi_currentRing.x = this.sinatraX.getNextValue(22) << 12;
            this.vbi_currentRing.y = this.sinatraY.getNextValue(20) << 12;
            this.vbi_currentRing.radiusIndex = 0;
            if (this.enableRadiusDelta) {
                this.vbi_currentRing.radiusDelta = this.sinatraR.getNextValue(30);
            }
            if (this.enableAngleDelta) {
                this.vbi_currentRing.angleDelta = this.sinatraA.getNextValue(3);
            }
            this.newRingIndex = this.newRingIndex + 1 < 64 ? ++this.newRingIndex : 0;
            this.vbi_currentRing = this.rings.firstElement();
            this.masterXDelta = (-this.vbi_currentRing.x - this.masterX) / 5;
            this.masterYDelta = (-this.vbi_currentRing.y - this.masterY) / 5;
        }
        if (this.lightningLinecountDelta < 0.0) {
            double d;
            this.lightningLinecount += this.lightningLinecountDelta;
            if (d <= this.lightningLinecountDest) {
                this.lightningLinecountDelta = 0.0;
            }
        } else {
            double d;
            this.lightningLinecount += this.lightningLinecountDelta;
            if (d >= this.lightningLinecountDest) {
                this.lightningLinecountDelta = 0.0;
            }
        }
        if (this.lightningRndDelta < 0.0) {
            double d;
            this.lightningRnd += this.lightningRndDelta;
            if (d <= this.lightningRndDest) {
                this.lightningRndDelta = 0.0;
            }
        } else {
            double d;
            this.lightningRnd += this.lightningRndDelta;
            if (d >= this.lightningRndDest) {
                this.lightningRndDelta = 0.0;
            }
        }
        this.faderBackground.fade(1);
    }

    public void worker2() {
        this.tools2D.screendataWorking = LunarEngine.screendataToWork;
        this.tools2D.rnd = (int)this.lightningRnd;
        this.tools2D.lightningLineParts = (int)this.lightningLinecount;
        int x = 0;
        int y = 0;
        this.worker_lastRing = null;
        for (int ringNumber = 63; ringNumber >= 0; --ringNumber) {
            this.worker_currentRing = this.rings.get(ringNumber);
            this.tools2D.pixel = this.colTable[this.worker_currentRing.radiusIndex];
            int radius = this.radTable[this.worker_currentRing.radiusIndex] + this.worker_currentRing.radiusDelta;
            int angle = this.worker_currentRing.angleDelta;
            int lastX = 0;
            int lastY = 0;
            int firstX = 0;
            int firstY = 0;
            int ringCount = 0;
            while (ringCount < 30) {
                x = PolarBear.calcXint(radius, angle) + Screen.screenCenterX + (this.worker_currentRing.x + this.masterX >> 12);
                y = PolarBear.calcYint(radius, angle) + Screen.screenCenterY + (this.worker_currentRing.y + this.masterY >> 12);
                if (ringCount == 0) {
                    firstX = x;
                    firstY = y;
                }
                if (lastX + lastY > 0) {
                    this.tools2D.lightningLine(x, y, lastX, lastY);
                }
                lastX = x;
                lastY = y;
                if (this.worker_lastRing != null) {
                    this.tools2D.lightningLine(x, y, this.worker_lastRing.pointsX[ringCount], this.worker_lastRing.pointsY[ringCount]);
                }
                this.worker_currentRing.pointsX[ringCount] = x;
                this.worker_currentRing.pointsY[ringCount] = y;
                ++ringCount;
                angle += 12;
            }
            this.worker_lastRing = this.worker_currentRing;
            this.tools2D.lightningLine(x, y, firstX, firstY);
        }
    }

    public void worker3() {
        Screen.screenClear(LunarEngine.screendataToReset, this.faderBackground.getCurrentColor());
    }

    public void rotateBuffers() {
        this.rotateBuffers5();
    }
}

