/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part08ribbons;

import abyss.lunarengine.gfx.LordFader;
import abyss.lunarengine.gfx.PolarBear;
import abyss.lunarengine.gfx.Tools2D;
import abyss.lunarengine.sinatra.Sinatra;

public class Ribbon {
    public static Tools2D tools2d;
    private static final int SHIFT = 12;
    private Sinatra sinusRibbonY2;
    private int offsetX;
    public int offsetY;
    private double angle;
    private static final int RADIUS = 250;
    private LordFader fader1;
    private LordFader fader2;
    private double alphaDelta;
    private int deltaSinus;
    public int deltaY;
    public boolean enabled;
    public static boolean fadeout;
    public static Sinatra sinatra;
    private int rendermethod = 1;
    public static boolean switchToDottyMode;

    public Ribbon(int offsetX, int offsetY, double angle, LordFader fader1, LordFader fader2, double alphaDelta, int deltaSinus, int deltaY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.angle = angle;
        this.fader1 = fader1;
        this.fader2 = fader2;
        this.alphaDelta = alphaDelta;
        this.deltaSinus = deltaSinus;
        this.deltaY = deltaY;
        this.enabled = true;
        this.sinusRibbonY2 = sinatra.clone();
        this.sinusRibbonY2.move(50);
    }

    public void vbi() {
        this.sinusRibbonY2.move(this.deltaSinus);
        this.angle += this.alphaDelta;
        if ((this.offsetY += this.deltaY) > 1200) {
            if (fadeout) {
                this.enabled = false;
            } else {
                this.offsetY -= 1600;
                if (switchToDottyMode) {
                    this.rendermethod = 2;
                }
            }
        }
    }

    public void render() {
        if (!this.enabled) {
            return;
        }
        this.sinusRibbonY2.beginRender();
        this.sinusRibbonY2.getNextValue(150);
        int x1 = PolarBear.calcXint(-125.0, this.angle);
        int y1 = PolarBear.calcYint(-125.0, this.angle);
        int x2 = PolarBear.calcXint(125.0, this.angle);
        int y2 = PolarBear.calcYint(125.0, this.angle);
        int dx = (x2 - x1 << 12) / 250;
        int dy = (y2 - y1 << 12) / 250;
        int px = -dx * 125;
        int py = -dy * 125;
        double alpha = (this.angle + 90.0) * (Math.PI / 180);
        if (this.rendermethod == 1) {
            for (int i = 0; i < 250; ++i) {
                int deltaY = this.sinusRibbonY2.getNextDeltaValue(1);
                int index = deltaY * 250 / 25;
                Ribbon.tools2d.pixel = deltaY > 0 ? this.fader1.colors[index] : this.fader2.colors[-index];
                int delta = (int)(Math.cos(alpha) * (double)deltaY);
                x1 = px + 2048 >> 12;
                x2 = x1 + delta;
                x1 -= delta;
                delta = (int)(Math.sin(alpha) * (double)deltaY);
                y1 = py + 2048 >> 12;
                y2 = y1 + delta;
                if (x1 == x2 && (y1 -= delta) == y2) {
                    ++x2;
                }
                tools2d.lineClipBold(x1 + this.offsetX, y1 + this.offsetY, x2 + this.offsetX, y2 + this.offsetY);
                px += dx;
                py += dy;
            }
        } else {
            dx += dx + dx;
            dy += dy + dy;
            for (int i = 0; i < 250; i += 3) {
                int deltaY = this.sinusRibbonY2.getNextDeltaValue(3);
                int index = deltaY * 250 / 25;
                Ribbon.tools2d.pixel = deltaY > 0 ? this.fader1.colors[index] : this.fader2.colors[-index];
                int delta = (int)(Math.cos(alpha) * (double)deltaY);
                x1 = px + 2048 >> 12;
                x2 = x1 + delta;
                x1 -= delta;
                delta = (int)(Math.sin(alpha) * (double)deltaY);
                y1 = py + 2048 >> 12;
                y2 = y1 + delta;
                if (x1 == x2 && (y1 -= delta) == y2) {
                    ++x2;
                }
                tools2d.dottyLine(x1 + this.offsetX, y1 + this.offsetY, x2 + this.offsetX, y2 + this.offsetY);
                px += dx;
                py += dy;
            }
        }
    }

    static {
        sinatra = Sinatra.getInstance(new double[]{720.0, 1.0, 25.0, 0.5, 0.0, 360.0});
    }
}

