/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part05bobbackground;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.Bob;
import abyss.lunarengine.gfx.BobFactory;
import abyss.lunarengine.gfx.LordFader;
import abyss.lunarengine.sinatra.Sinatra;

public class PartBobBackground
extends APart {
    private Sinatra[] sinatraX;
    private Sinatra[] sinatraY;
    private int[][] tunnel;
    private static final int TUNNEL_LENGTH = 1160;
    private int tunnelIndex;
    private Bob bob;
    private int[] sinTab = new int[360];
    private int[] cosTab = new int[360];
    public int initialRadius = 40;
    public int sinStepX = 8;
    public int sinStepY = 8;
    public int sinusOffset = 1;
    public boolean fadeOut;
    private LordFader faderBackground;
    public boolean enableBackgroundFader;
    private static final int SHIFT = 12;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartBobBackground partBobsBack = new PartBobBackground();
            partBobsBack.precalc();
            LunarEngine.setActivePart(partBobsBack);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public PartBobBackground() {
        this.tunnel = new int[1160][4];
    }

    public void precalc() {
        int i;
        this.faderBackground = new LordFader(2838, 655619, 90);
        for (int i2 = 0; i2 < 360; ++i2) {
            this.sinTab[i2] = (int)(Math.sin((double)i2 * Math.PI / 180.0) * 4096.0 + 0.5);
            this.cosTab[i2] = (int)(Math.cos((double)i2 * Math.PI / 180.0) * 4096.0 + 0.5);
        }
        this.bob = BobFactory.createBob(PartBobBackground.class, "/data/ball32/");
        this.bob.enabled = true;
        int p = 0;
        for (i = 0; i < this.bob.bobdata[0].length; ++i) {
            p = this.bob.bobdata[0][i];
            if (p >= 0) continue;
            this.bob.bobdata[0][i] = (this.bob.bobdata[0][i] & 0xFEFEFE) >> 1 | 0xFF000000;
        }
        this.sinatraX = new Sinatra[3];
        this.sinatraY = new Sinatra[3];
        this.sinatraX[0] = Sinatra.getInstance(new double[]{7200.0, 5.0, 100.0, 0.05, 0.0, 360.0, 80.0, 0.2, 0.0, 360.0, 72.0, 0.4, 0.0, 360.0, 116.0, 0.2, 0.0, 360.0, 199.0, 0.5, 0.0, 180.0});
        this.sinatraY[0] = Sinatra.getInstance(new double[]{7200.0, 4.0, 130.0, 0.05, 0.0, 360.0, 103.0, 0.3, 0.0, 360.0, 130.0, 1.0, 0.0, 180.0, 68.0, 2.0, 0.0, 360.0});
        this.sinatraX[1] = Sinatra.getInstance(new double[]{7200.0, 3.0, 100.0, 0.3, 0.0, 360.0, 199.0, 0.25, 0.0, 360.0, 156.0, 0.9, 0.0, 360.0});
        this.sinatraY[1] = Sinatra.getInstance(new double[]{7200.0, 3.0, 190.0, 0.25, 0.0, 360.0, 132.0, 0.2, 0.0, 360.0, 78.0, 1.5, 0.0, 360.0});
        this.sinatraX[2] = Sinatra.getInstance(new double[]{3600.0, 5.0, 400.0, 0.2, 180.0, 360.0, 168.0, 1.5, 0.0, 360.0, 83.0, 0.1, 0.0, 360.0, 116.0, 0.2, 0.0, 360.0, 400.0, 1.0, 0.0, 180.0});
        this.sinatraY[2] = Sinatra.getInstance(new double[]{3600.0, 4.0, 164.0, 0.05, 180.0, 360.0, 193.0, 0.3, 0.0, 360.0, 300.0, 1.0, 0.0, 180.0, 189.0, 1.5, 0.0, 360.0});
        for (i = 0; i < 1160; ++i) {
            this.tunnel[i][0] = 0;
            this.tunnel[i][1] = 0;
            this.tunnel[i][2] = this.initialRadius;
            this.tunnel[i][3] = -1;
        }
    }

    public void vbi() {
        this.tunnel[this.tunnelIndex][0] = this.sinatraX[this.sinusOffset].getNextValue(this.sinStepX);
        this.tunnel[this.tunnelIndex][1] = this.sinatraY[this.sinusOffset].getNextValue(this.sinStepY);
        this.tunnel[this.tunnelIndex][2] = this.initialRadius;
        if (this.fadeOut) {
            this.tunnel[this.tunnelIndex][3] = -1;
            if (++this.tunnelIndex == 1160) {
                this.tunnelIndex = 0;
            }
            this.tunnel[this.tunnelIndex][3] = -1;
        } else {
            this.tunnel[this.tunnelIndex][3] = 0;
        }
        if (++this.tunnelIndex == 1160) {
            this.tunnelIndex = 0;
        }
        if (this.enableBackgroundFader) {
            this.faderBackground.fade(1);
        }
    }

    public void worker2() {
        Bob.screendataToWork = LunarEngine.screendataToWork2;
        int deltaAngle = 0;
        for (int t = 0; t < 1160; ++t) {
            int[] nArray = this.tunnel[t];
            nArray[2] = nArray[2] + 2;
            if (this.tunnel[t][3] >= 0) {
                int render_r = this.tunnel[t][2];
                for (int i = 0; i < 4; ++i) {
                    this.bob.render(this.calcXint(render_r, i * -20 + ++deltaAngle) + Screen.screenCenterX + this.tunnel[t][0], this.calcYint(render_r, i * 40 + deltaAngle) + Screen.screenCenterY + this.tunnel[t][1]);
                }
                continue;
            }
            deltaAngle += 4;
        }
    }

    private int calcXint(int r, int a) {
        return this.cosTab[(a + 360) % 360] * r >> 12;
    }

    private int calcYint(int r, int a) {
        return this.sinTab[a % 360] * r >> 12;
    }

    public void worker3() {
        Screen.screenClear(LunarEngine.screendataToReset, this.faderBackground.getCurrentColor());
    }

    public void rotateBuffers() {
        this.rotateBuffers5();
    }
}

