/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part02abysslogo;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.LunarEngineTools;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.Bob;
import abyss.lunarengine.gfx.BobFactory;
import abyss.lunarengine.gfx.LordFader;
import abyss.lunarengine.gfx.Point2D;
import abyss.lunarengine.gfx.Quad;
import abyss.lunarengine.sinatra.Sinatra;
import abyss.lunarengine.spliner.Spliner;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;

public class PartAbyssLogo
extends APart {
    public static final int BACKGROUNDCOLOR = 2838;
    public boolean enableSpliner;
    public int logoFadeSleep;
    public int logoFadeDirection;
    public boolean logoFadeout;
    public boolean enableBackgroundFader;
    public Quad quadLogo;
    private static final int SHIFT = 12;
    private int logoFadePoint = 0;
    private volatile int logoFadeDelta = -24;
    private LordFader faderBackground;
    private Bob bobFade;
    private int[][] bobData;
    private BufferedImage bufferedImageAbysslogo;
    private int[] dataAbysslogo;
    private int[][] dataAbysslogoShaded;
    private int logoWidth;
    private int logoHeight;
    private static final int LOGOSHADECOUNT = 24;
    private Sinatra sinatraX1;
    private Sinatra sinatraX2;
    private Sinatra sinatraY1;
    private Sinatra sinatraY2;
    private Spliner[] spliner;
    private int splineIndexOffset;
    private int renderLogoStepsX = 1300;
    private int renderLogoStepsY = 1300;
    private int renderLogoDeltaX;
    private int renderLogoDeltaY;
    private Point2D point2D;
    private int[] bobDataFrame;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartAbyssLogo partAbyssLogo = new PartAbyssLogo();
            partAbyssLogo.precalc();
            partAbyssLogo.initialize();
            LunarEngine.setActivePart(partAbyssLogo);
            partAbyssLogo.enableSpliner = true;
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public void precalc() {
        this.faderBackground = new LordFader(0, 2838, 210);
        this.bobFade = BobFactory.createBob(PartAbyssLogo.class, "/data/LogoFadeBob/");
        this.bobFade.enabled = true;
        this.bobFade.animdelay = 0;
        this.bobData = this.bobFade.bobdata;
        this.sinatraX1 = Sinatra.getInstance(new double[]{900.0, 2.0, 4.5, 0.4, 0.0, 360.0, 4.0, 4.0, 0.0, 360.0});
        this.sinatraX2 = Sinatra.getInstance(new double[]{720.0, 2.0, 4.0, 0.5, 0.0, 360.0, 4.5, 4.0, 0.0, 360.0});
        this.sinatraY1 = Sinatra.getInstance(new double[]{720.0, 2.0, 4.5, 0.5, 0.0, 360.0, 4.0, 6.0, 0.0, 360.0});
        this.sinatraY2 = Sinatra.getInstance(new double[]{1800.0, 2.0, 4.5, 0.4, 0.0, 360.0, 4.0, 5.0, 0.0, 360.0});
        this.spliner = new Spliner[4];
        this.spliner[0] = Spliner.getInstance(new int[]{2, 6, 690, 310, 344, 320, 215, 170, 65, 160, 170, 65, 163, 405, 320, 215, 160, 320, 215, 456, 45, 671, 386, 110, 671, 386, 935, 760, 885, 288, 160, 885, 288, 849, -52, 413, 197, 110, 413, 197, -68, 459, 369, 282});
        this.spliner[1] = Spliner.getInstance(new int[]{2, 6, 690, 1312, 220, 1349, 247, 1370, 265, 160, 1370, 265, 1628, 455, 1120, 315, 160, 1120, 315, 220, 90, 779, 169, 260, 779, 169, 1934, 358, 1210, 87, 60, 1210, 87, 883, -8, 1646, 148, 60, 1646, 148, 2044, 229, 1438, 200});
        this.spliner[2] = Spliner.getInstance(new int[]{2, 6, 690, 1312, 860, 1158, 761, 912, 796, 240, 912, 796, 522, 849, 1134, 697, 110, 1134, 697, 1367, 643, 1352, 301, 160, 1352, 301, 1329, -27, 1070, 524, 110, 1070, 524, 872, 983, 1723, 970, 80, 1723, 970, 2011, 965, 1252, 749});
        this.spliner[3] = Spliner.getInstance(new int[]{2, 6, 690, 608, 860, 580, 973, 420, 965, 160, 420, 965, -50, 880, 291, 655, 160, 291, 655, 549, 473, 683, 604, 110, 683, 604, 1050, 933, 800, 944, 160, 800, 944, -18, 1020, 656, 728, 110, 656, 728, 1154, 515, 730, 932});
        Image imageAbysslogo = LunarEngineTools.createImage((Component)jFrame, "data/abyss_704x640.png");
        this.logoWidth = imageAbysslogo.getWidth(null);
        this.logoHeight = imageAbysslogo.getHeight(null);
        this.bufferedImageAbysslogo = new BufferedImage(this.logoWidth, this.logoHeight, 1);
        this.dataAbysslogo = ((DataBufferInt)this.bufferedImageAbysslogo.getRaster().getDataBuffer()).getData();
        this.bufferedImageAbysslogo.getGraphics().drawImage(imageAbysslogo, 0, 0, jFrame);
        imageAbysslogo = null;
        this.bufferedImageAbysslogo = null;
        this.renderLogoDeltaX = (this.logoWidth << 12) / this.renderLogoStepsX;
        this.renderLogoDeltaY = (this.logoHeight << 12) / this.renderLogoStepsY;
        int factor = 0;
        int pixel = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        this.dataAbysslogoShaded = new int[24][];
        for (int i = 0; i < 23; ++i) {
            int x;
            int y;
            factor = 256 * i / 24;
            this.dataAbysslogoShaded[i] = new int[this.dataAbysslogo.length];
            for (y = 0; y < this.logoHeight; ++y) {
                for (x = 0; x < this.logoWidth; ++x) {
                    pixel = this.dataAbysslogo[x + y * this.logoWidth];
                    red = pixel & 0xFF0000;
                    green = pixel & 0xFF00;
                    blue = pixel & 0xFF;
                    red = red * factor >> 8 & 0xFF0000;
                    green = green * factor >> 8 & 0xFF00;
                    blue = blue * factor >> 8 & 0xFF;
                    this.dataAbysslogoShaded[i][x + y * this.logoWidth] = pixel = red | green | blue;
                }
            }
            this.dataAbysslogoShaded[23] = new int[this.dataAbysslogo.length];
            for (y = 0; y < this.logoHeight; ++y) {
                for (x = 0; x < this.logoWidth; ++x) {
                    this.dataAbysslogoShaded[23][x + y * this.logoWidth] = this.dataAbysslogo[x + y * this.logoWidth];
                }
            }
        }
        Arrays.fill(this.dataAbysslogo, 0);
        int cornerX = -(this.logoWidth >> 1);
        int cornerY = -(this.logoHeight >> 1);
        int[] point0 = new int[]{cornerX << 12, cornerY << 12, 819200};
        int[] point1 = new int[]{cornerX + this.logoWidth << 12, cornerY << 12, -819200};
        int[] point2 = new int[]{cornerX + this.logoWidth << 12, cornerY + this.logoHeight << 12, 819200};
        int[] point3 = new int[]{cornerX << 12, cornerY + this.logoHeight << 12, -819200};
        this.quadLogo = new Quad(point0, point1, point2, point3);
    }

    public void initialize() {
        this.enableSpliner = false;
        this.logoFadeSleep = 30;
        this.logoFadeDirection = 1;
        this.quadLogo.turnAlpha = 0.0;
        this.quadLogo.turnBeta = 0.0;
        this.quadLogo.turnGamma = 0.0;
        this.quadLogo.focus1 = 3000;
        this.quadLogo.focus2 = 3100;
    }

    public void vbi() {
        if (--this.logoFadePoint < 0) {
            this.logoFadePoint = this.logoFadeSleep;
            this.logoFadeDelta += this.logoFadeDirection;
        }
        this.quadLogo.rotateVBI();
        if (this.logoFadeout && this.quadLogo.focus2 < 100000) {
            this.quadLogo.focus2 += this.quadLogo.focus2 / 300;
        }
        if (this.enableSpliner) {
            for (int i = 0; i < 4; ++i) {
                this.spliner[i + this.splineIndexOffset].move(1);
            }
        }
        this.sinatraY1.move(1);
        this.sinatraY2.move(1);
        this.sinatraX1.move(1);
        this.sinatraX2.move(1);
        if (this.enableBackgroundFader) {
            this.faderBackground.fade(1);
        }
    }

    public void worker2() {
        this.quadLogo.rotateCALC();
        this.sinatraY1.beginRender();
        this.sinatraY2.beginRender();
        this.sinatraX1.beginRender();
        this.sinatraX2.beginRender();
        for (int i = 0; i < 4; ++i) {
            this.spliner[i + this.splineIndexOffset].beginRender();
            this.point2D = this.spliner[i + this.splineIndexOffset].getNextValue(1);
            this.quadLogo.vo[i][0] = this.point2D.x - Screen.screenCenterX << 12;
            this.quadLogo.vo[i][1] = this.point2D.y - Screen.screenCenterY << 12;
        }
        int sinIndexY = this.sinatraY1.getNextValue(0) + 8;
        sinIndexY += this.sinatraY2.getNextValue(0) + 8;
        sinIndexY >>= 1;
        this.sinatraX1.setDeltaIndex(this.sinatraX1.getIndex());
        for (int y1 = 0; y1 < 640; y1 += 32) {
            int sinwaveIndex1 = this.sinatraX1.getDeltaIndex();
            int sinwaveIndex2 = this.sinatraX2.getDeltaIndex();
            for (int x1 = 0; x1 < 704; x1 += 32) {
                this.bobDataFrame = this.bobData[sinIndexY + this.sinatraX1.getNextDeltaValue(3) + 8];
                for (int y2 = 0; y2 < 32; ++y2) {
                    for (int x2 = 0; x2 < 32; ++x2) {
                        int i = x1 + x2 + (y2 + y1) * this.logoWidth;
                        int index = (this.bobDataFrame[x2 + y2 * this.bobFade.bobSizeX] & 0xFF) + this.logoFadeDelta;
                        if (index < 0) {
                            index = 0;
                        } else if (index >= 24) {
                            index = 23;
                        }
                        this.dataAbysslogo[i] = this.dataAbysslogoShaded[index][i];
                    }
                }
            }
            this.sinatraX1.setDeltaIndex(sinwaveIndex1);
            this.sinatraX2.setDeltaIndex(sinwaveIndex2);
            sinIndexY = this.sinatraY1.getNextDeltaValue(2) + 8;
            sinIndexY += this.sinatraY2.getNextDeltaValue(2) + 8;
            sinIndexY >>= 1;
        }
    }

    private void drawLogo() {
        int x0 = this.quadLogo.to[0][0] << 12;
        int delta0x = this.quadLogo.to[3][0] - this.quadLogo.to[0][0] << 12;
        int step0x = delta0x / this.renderLogoStepsX;
        int y0 = this.quadLogo.to[0][1] << 12;
        int delta0y = this.quadLogo.to[3][1] - this.quadLogo.to[0][1] << 12;
        int step0y = delta0y / this.renderLogoStepsY;
        int x1 = this.quadLogo.to[1][0] << 12;
        int delta1x = this.quadLogo.to[2][0] - this.quadLogo.to[1][0] << 12;
        int step1x = delta1x / this.renderLogoStepsX;
        int y1 = this.quadLogo.to[1][1] << 12;
        int delta1y = this.quadLogo.to[2][1] - this.quadLogo.to[1][1] << 12;
        int step1y = delta1y / this.renderLogoStepsY;
        int pixelCountX = this.renderLogoStepsX * this.renderLogoDeltaX;
        for (int posPicY = 0; posPicY < this.renderLogoStepsY * this.renderLogoDeltaY; posPicY += this.renderLogoDeltaY) {
            int lx = x0 += step0x;
            int steplx = ((x1 += step1x) - x0) / this.renderLogoStepsX;
            int ly = y0 += step0y;
            int steply = ((y1 += step1y) - y0) / this.renderLogoStepsY;
            int posPicX = 0;
            while (posPicX < pixelCountX) {
                LunarEngine.screendataToWork2[Screen.screenCenterXY + (lx >> 12) + (ly >> 12) * Screen.screenSizeX] = this.dataAbysslogo[(posPicX >> 12) + (posPicY >> 12) * this.logoWidth];
                posPicX += this.renderLogoDeltaX;
                lx += steplx;
                ly += steply;
            }
        }
    }

    public void worker3() {
        Screen.screenClear(LunarEngine.screendataToReset, this.faderBackground.getCurrentColor());
        this.drawLogo();
    }

    public void rotateBuffers() {
        this.rotateBuffers5();
    }
}

