/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.tools;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class Settings {
    private Properties properties;
    private File fileProperties;
    private String nameProperties;

    public Settings(File properties, String nameProperties) {
        this.fileProperties = properties;
        this.nameProperties = nameProperties;
        this.loadSettings();
    }

    public void saveSettings() throws IOException {
        FileWriter fileWriter = new FileWriter(this.fileProperties);
        try {
            this.properties.store(fileWriter, this.nameProperties);
        }
        finally {
            fileWriter.flush();
            fileWriter.close();
        }
    }

    private void loadSettings() {
        this.properties = new Properties();
        File file = this.fileProperties;
        if (!file.exists()) {
            return;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            this.properties.load(fileReader);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading settings", e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    System.err.println("Error closing settings file");
                    e.printStackTrace();
                }
            }
        }
    }

    public Rectangle getRectangle(String name, Rectangle defaultRectangle) {
        String[] sa;
        String s = this.properties.getProperty(name);
        if (s != null && (sa = s.split(",")).length == 4) {
            return new Rectangle(Integer.parseInt(sa[0]), Integer.parseInt(sa[1]), Integer.parseInt(sa[2]), Integer.parseInt(sa[3]));
        }
        this.setRectangle(name, defaultRectangle);
        return defaultRectangle;
    }

    public void setRectangle(String name, Rectangle rectangle) {
        this.properties.setProperty(name, "" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
    }

    public void set(String name, String string) {
        this.properties.setProperty(name, string);
    }

    public String getString(String name) {
        return this.properties.getProperty(name);
    }
}

