/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.spliner;

import abyss.lunarengine.gfx.Point2D;

public class SplinerData {
    private int size;
    private int ax;
    private int ay;
    private int bx;
    private int by;
    private int cx;
    private int cy;
    private boolean firstValueRead;
    private double cValueX;
    private double cValueY;
    private double cValueX12;
    private double cValueY12;
    private double cValueX23;
    private double cValueY23;
    private double deltaX12;
    private double deltaY12;
    private double deltaX23;
    private double deltaY23;
    private int currentPos;

    public int getAx() {
        return this.ax;
    }

    public void setAx(int ax) {
        this.ax = ax;
    }

    public int getAy() {
        return this.ay;
    }

    public void setAy(int ay) {
        this.ay = ay;
    }

    public int getBx() {
        return this.bx;
    }

    public void setBx(int bx) {
        this.bx = bx;
    }

    public int getBy() {
        return this.by;
    }

    public void setBy(int by) {
        this.by = by;
    }

    public int getCx() {
        return this.cx;
    }

    public void setCx(int cx) {
        this.cx = cx;
    }

    public int getCy() {
        return this.cy;
    }

    public void setCy(int cy) {
        this.cy = cy;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Point2D getNextValue() {
        if (!this.firstValueRead) {
            this.firstValueRead = true;
            this.cValueX12 = this.ax;
            this.cValueY12 = this.ay;
            this.cValueX23 = this.bx;
            this.cValueY23 = this.by;
            this.deltaX12 = (double)(this.bx - this.ax) / (double)this.size;
            this.deltaY12 = (double)(this.by - this.ay) / (double)this.size;
            this.deltaX23 = (double)(this.cx - this.bx) / (double)this.size;
            this.deltaY23 = (double)(this.cy - this.by) / (double)this.size;
        }
        if (this.currentPos >= 0 && this.currentPos < this.size) {
            ++this.currentPos;
            this.cValueX12 += this.deltaX12;
            this.cValueY12 += this.deltaY12;
            this.cValueX23 += this.deltaX23;
            this.cValueY23 += this.deltaY23;
            double deltaX = (this.cValueX23 - this.cValueX12) / (double)this.size;
            double deltaY = (this.cValueY23 - this.cValueY12) / (double)this.size;
            this.cValueX = this.cValueX12 + deltaX * (double)this.currentPos;
            this.cValueY = this.cValueY12 + deltaY * (double)this.currentPos;
        }
        return new Point2D((int)(this.cValueX + 0.5), (int)(this.cValueY + 0.5));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SplineWave: size=" + this.size);
        sb.append(", p1x=" + this.ax);
        sb.append(", p1y=" + this.ay);
        sb.append(", p2x=" + this.bx);
        sb.append(", p2y=" + this.by);
        sb.append(", p3x=" + this.cx);
        sb.append(", p3y=" + this.cy);
        return sb.toString();
    }
}

