/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.sinatra;

public class SinusWave {
    private double radius;
    private double angleStep;
    private double angleStart;
    private double angleEnd;
    private double currentAngle;
    private double currentValue;
    private boolean firstValueRead;
    private static final double DEG2RAD = Math.PI / 180;

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getAngleStep() {
        return this.angleStep;
    }

    public void setAngleStep(double angleStep) {
        this.angleStep = angleStep;
    }

    public double getAngleStart() {
        return this.angleStart;
    }

    public void setAngleStart(double angleStart) {
        this.angleStart = angleStart;
    }

    public double getAngleEnd() {
        return this.angleEnd;
    }

    public void setAngleEnd(double angleEnd) {
        this.angleEnd = angleEnd;
    }

    public int getWaveLength() {
        return this.angleStep == 0.0 ? 1 : (int)((this.angleEnd - this.angleStart) / this.angleStep);
    }

    public double getNextValue() {
        if (!this.firstValueRead) {
            this.firstValueRead = true;
            this.currentAngle = this.angleStart;
        }
        this.currentValue = this.radius * Math.sin(this.currentAngle * (Math.PI / 180));
        this.currentAngle += this.angleStep;
        if (this.currentAngle >= this.angleEnd) {
            this.currentAngle -= this.angleEnd - this.angleStart;
        }
        return this.currentValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("r=" + this.radius);
        sb.append(", angleStep=" + this.angleStep);
        sb.append(", angleStart=" + this.angleStart);
        sb.append(", angleEnd=" + this.angleEnd);
        return sb.toString();
    }
}

