/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.gfx;

import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.lunarengine.tools.Random;

public class Tools2D {
    public int[] screendataWorking;
    public int pixel;
    public int background;
    public int rnd = 20;
    public int lightningLineParts = 3;
    private static final boolean BOLD = true;
    private static final int SHIFT = 12;
    private static int clipX1;
    private static int clipY1;
    private static int clipX2;
    private static int clipY2;
    private static int clipX1shift;
    private static int clipY1shift;
    private static int clipY1screen;
    private static int clipX2shift;
    private static int clipY2shift;
    private static int clipY2screen;

    public Tools2D() {
        Tools2D.setClippingArea(0, 0, Screen.screenSizeX - 1, Screen.screenSizeY - 1);
        this.screendataWorking = LunarEngine.screendataToWork;
    }

    public void line(int x1, int y1, int x2, int y2) {
        block9: {
            int deltaY;
            int deltaX;
            block7: {
                block8: {
                    deltaX = x2 - x1;
                    deltaY = y2 - y1;
                    if (Math.abs(deltaX) <= Math.abs(deltaY)) break block7;
                    if (deltaX <= 0) break block8;
                    int ys = y1 << 12;
                    int yd = (deltaY << 12) / deltaX;
                    int x = x1;
                    while (x < x2) {
                        int index = x + (ys >> 12) * Screen.screenSizeX;
                        this.screendataWorking[index] = this.pixel;
                        this.screendataWorking[index + 1] = this.pixel;
                        ++x;
                        ys += yd;
                    }
                    break block9;
                }
                if (deltaX >= 0) break block9;
                int ys = y2 << 12;
                int yd = (deltaY << 12) / deltaX;
                int x = x2;
                while (x < x1) {
                    int index = x + (ys >> 12) * Screen.screenSizeX;
                    this.screendataWorking[index] = this.pixel;
                    this.screendataWorking[index + 1] = this.pixel;
                    ++x;
                    ys += yd;
                }
                break block9;
            }
            if (deltaY > 0) {
                int xs = x1 << 12;
                int xd = (deltaX << 12) / deltaY;
                int y = y1 * Screen.screenSizeX;
                while (y < y2 * Screen.screenSizeX) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.pixel;
                    this.screendataWorking[index + 1] = this.pixel;
                    y += Screen.screenSizeX;
                    xs += xd;
                }
            } else if (deltaY < 0) {
                int xs = x2 << 12;
                int xd = (deltaX << 12) / deltaY;
                int y = y2 * Screen.screenSizeX;
                while (y < y1 * Screen.screenSizeX) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.pixel;
                    this.screendataWorking[index + 1] = this.pixel;
                    y += Screen.screenSizeX;
                    xs += xd;
                }
            }
        }
    }

    public void dottyLine(int x1, int y1, int x2, int y2) {
        block13: {
            int deltaY;
            int deltaX;
            block11: {
                block12: {
                    deltaX = x2 - x1;
                    deltaY = y2 - y1;
                    if (Math.abs(deltaX) <= Math.abs(deltaY)) break block11;
                    if (deltaX <= 0) break block12;
                    int ys = y1 << 12;
                    int yd = (deltaY << 12) / deltaX;
                    int x = x1;
                    while (x < x2) {
                        int xRnd = x + this.getRND();
                        int yRnd = (ys >> 12) + this.getRND();
                        if (xRnd >= clipX1 && xRnd < clipX2 && yRnd >= clipY1 && yRnd < clipY2) {
                            int index = xRnd + yRnd * Screen.screenSizeX;
                            this.screendataWorking[index] = this.pixel;
                            this.screendataWorking[index + 1] = this.pixel;
                        }
                        ++x;
                        ys += yd;
                    }
                    break block13;
                }
                if (deltaX >= 0) break block13;
                int ys = y2 << 12;
                int yd = (deltaY << 12) / deltaX;
                int x = x2;
                while (x < x1) {
                    int xRnd = x + this.getRND();
                    int yRnd = (ys >> 12) + this.getRND();
                    if (xRnd >= clipX1 && xRnd < clipX2 && yRnd >= clipY1 && yRnd < clipY2) {
                        int index = xRnd + yRnd * Screen.screenSizeX;
                        this.screendataWorking[index] = this.pixel;
                        this.screendataWorking[index + 1] = this.pixel;
                    }
                    ++x;
                    ys += yd;
                }
                break block13;
            }
            if (deltaY > 0) {
                int xs = x1 << 12;
                int xd = (deltaX << 12) / deltaY;
                int y = y1;
                while (y < y2) {
                    int xRnd = (xs >> 12) + this.getRND();
                    int yRnd = y + this.getRND();
                    if (xRnd >= clipX1 && xRnd < clipX2 && yRnd >= clipY1 && yRnd < clipY2) {
                        int index = xRnd + yRnd * Screen.screenSizeX;
                        this.screendataWorking[index] = this.pixel;
                        this.screendataWorking[index + 1] = this.pixel;
                    }
                    ++y;
                    xs += xd;
                }
            } else if (deltaY < 0) {
                int xs = x2 << 12;
                int xd = (deltaX << 12) / deltaY;
                int y = y2;
                while (y < y1) {
                    int xRnd = (xs >> 12) + this.getRND();
                    int yRnd = y + this.getRND();
                    if (xRnd >= clipX1 && xRnd < clipX2 && yRnd >= clipY1 && yRnd < clipY2) {
                        int index = xRnd + yRnd * Screen.screenSizeX;
                        this.screendataWorking[index] = this.pixel;
                        this.screendataWorking[index + 1] = this.pixel;
                    }
                    ++y;
                    xs += xd;
                }
            }
        }
    }

    public void lineClip(int x1, int y1, int x2, int y2) {
        int deltaX = x2 - x1;
        int deltaY = y2 - y1;
        if (Math.abs(deltaX) > Math.abs(deltaY)) {
            if (deltaX > 0) {
                int ys = y1 << 12;
                int yd = (deltaY << 12) / deltaX;
                int x = x1;
                while (x < x2) {
                    int index = x + (ys >> 12) * Screen.screenSizeX;
                    if (x >= clipX1 && x < clipX2 && ys >= clipY1shift && ys < clipY2shift) {
                        this.screendataWorking[index] = this.pixel;
                        this.screendataWorking[index + 1] = this.pixel;
                    }
                    ++x;
                    ys += yd;
                }
            } else if (deltaX < 0) {
                int ys = y2 << 12;
                int yd = (deltaY << 12) / deltaX;
                int x = x2;
                while (x < x1) {
                    int index = x + (ys >> 12) * Screen.screenSizeX;
                    if (x >= clipX1 && x < clipX2 && ys >= clipY1shift && ys < clipY2shift) {
                        this.screendataWorking[index] = this.pixel;
                        this.screendataWorking[index + 1] = this.pixel;
                    }
                    ++x;
                    ys += yd;
                }
            }
        } else if (deltaY > 0) {
            int xs = x1 << 12;
            int xd = (deltaX << 12) / deltaY;
            int y = y1 * Screen.screenSizeX;
            while (y < y2 * Screen.screenSizeX) {
                if (y >= clipY1screen && y < clipY2screen && xs >= clipX1shift && xs < clipX2shift) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.pixel;
                    this.screendataWorking[index + 1] = this.pixel;
                }
                y += Screen.screenSizeX;
                xs += xd;
            }
        } else if (deltaY < 0) {
            int xs = x2 << 12;
            int xd = (deltaX << 12) / deltaY;
            int y = y2 * Screen.screenSizeX;
            while (y < y1 * Screen.screenSizeX) {
                if (y >= clipY1screen && y < clipY2screen && xs >= clipX1shift && xs < clipX2shift) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.pixel;
                    this.screendataWorking[index + 1] = this.pixel;
                }
                y += Screen.screenSizeX;
                xs += xd;
            }
            return;
        }
    }

    public void lineClipBold(int x1, int y1, int x2, int y2) {
        int deltaX = x2 - x1;
        int deltaY = y2 - y1;
        if (Math.abs(deltaX) > Math.abs(deltaY)) {
            if (deltaX > 0) {
                int ys = y1 << 12;
                int yd = (deltaY << 12) / deltaX;
                int x = x1;
                while (x < x2) {
                    int index = x + (ys >> 12) * Screen.screenSizeX;
                    if (x >= clipX1 && x < clipX2 && ys >= clipY1shift && ys < clipY2shift) {
                        this.screendataWorking[index] = this.pixel;
                        this.screendataWorking[++index] = this.pixel;
                        this.screendataWorking[index += Screen.screenSizeX] = this.pixel;
                        this.screendataWorking[--index] = this.pixel;
                    }
                    ++x;
                    ys += yd;
                }
            } else if (deltaX < 0) {
                int ys = y2 << 12;
                int yd = (deltaY << 12) / deltaX;
                int x = x2;
                while (x < x1) {
                    int index = x + (ys >> 12) * Screen.screenSizeX;
                    if (x >= clipX1 && x < clipX2 && ys >= clipY1shift && ys < clipY2shift) {
                        this.screendataWorking[index] = this.pixel;
                        this.screendataWorking[++index] = this.pixel;
                        this.screendataWorking[index += Screen.screenSizeX] = this.pixel;
                        this.screendataWorking[--index] = this.pixel;
                    }
                    ++x;
                    ys += yd;
                }
            }
        } else if (deltaY > 0) {
            int xs = x1 << 12;
            int xd = (deltaX << 12) / deltaY;
            int y = y1 * Screen.screenSizeX;
            while (y < y2 * Screen.screenSizeX) {
                if (y >= clipY1screen && y < clipY2screen && xs >= clipX1shift && xs < clipX2shift) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.pixel;
                    this.screendataWorking[++index] = this.pixel;
                    this.screendataWorking[index += Screen.screenSizeX] = this.pixel;
                    this.screendataWorking[--index] = this.pixel;
                }
                y += Screen.screenSizeX;
                xs += xd;
            }
        } else if (deltaY < 0) {
            int xs = x2 << 12;
            int xd = (deltaX << 12) / deltaY;
            int y = y2 * Screen.screenSizeX;
            while (y < y1 * Screen.screenSizeX) {
                if (y >= clipY1screen && y < clipY2screen && xs >= clipX1shift && xs < clipX2shift) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.pixel;
                    this.screendataWorking[++index] = this.pixel;
                    this.screendataWorking[index + Screen.screenSizeX] = this.pixel;
                    this.screendataWorking[--index] = this.pixel;
                }
                y += Screen.screenSizeX;
                xs += xd;
            }
            return;
        }
    }

    public void lineB(int x1, int y1, int x2, int y2) {
        if (y1 < y2) {
            int deltaY = y2 - y1;
            if (deltaY == 0) {
                return;
            }
            if (x1 < x2) {
                int deltaX = x2 - x1;
                int xs = x1 << 12;
                int xd = (deltaX << 12) / deltaY;
                int y = y1 * Screen.screenSizeX;
                while (y < y2 * Screen.screenSizeX) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.screendataWorking[index] != this.background ? this.background : this.pixel;
                    y += Screen.screenSizeX;
                    xs += xd;
                }
            } else {
                int deltaX = x1 - x2;
                int xs = x1 << 12;
                int xd = (deltaX << 12) / deltaY;
                int y = y1 * Screen.screenSizeX;
                while (y < y2 * Screen.screenSizeX) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.screendataWorking[index] != this.background ? this.background : this.pixel;
                    y += Screen.screenSizeX;
                    xs -= xd;
                }
            }
        } else {
            int deltaY = y1 - y2;
            if (deltaY == 0) {
                return;
            }
            if (x1 < x2) {
                int deltaX = x2 - x1;
                int xs = x2 << 12;
                int xd = (deltaX << 12) / deltaY;
                int y = y2 * Screen.screenSizeX;
                while (y < y1 * Screen.screenSizeX) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.screendataWorking[index] != this.background ? this.background : this.pixel;
                    y += Screen.screenSizeX;
                    xs -= xd;
                }
            } else {
                int deltaX = x1 - x2;
                int xs = x2 << 12;
                int xd = (deltaX << 12) / deltaY;
                int y = y2 * Screen.screenSizeX;
                while (y < y1 * Screen.screenSizeX) {
                    int index = (xs >> 12) + y;
                    this.screendataWorking[index] = this.screendataWorking[index] != this.background ? this.background : this.pixel;
                    y += Screen.screenSizeX;
                    xs += xd;
                }
            }
        }
    }

    public void lightningLine(int x1, int y1, int x2, int y2) {
        int stepX = (x2 - x1) / this.lightningLineParts;
        int stepY = (y2 - y1) / this.lightningLineParts;
        int xPos1 = x1;
        int yPos1 = y1;
        x1 += stepX;
        y1 += stepY;
        int xPos2 = xPos1 + stepX + this.getRND();
        int yPos2 = yPos1 + stepY + this.getRND();
        for (int i = 1; i < this.lightningLineParts; ++i) {
            this.lineClip(xPos1, yPos1, xPos2, yPos2);
            xPos1 = xPos2;
            yPos1 = yPos2;
            xPos2 = (x1 += stepX) + this.getRND();
            yPos2 = (y1 += stepY) + this.getRND();
        }
        this.lineClip(xPos1, yPos1, x2, y2);
    }

    private int getRND() {
        return (int)(Random.random() * (double)(this.rnd + 1)) - (this.rnd >> 1);
    }

    public static void setClippingArea(int x1, int y1, int x2, int y2) {
        clipX1 = x1;
        clipY1 = y1;
        clipX2 = x2 - 1;
        clipY2 = y2 - 1;
        clipX1shift = x1 << 12;
        clipY1shift = y1 << 12;
        clipX2shift = x2 << 12;
        clipY2shift = y2 << 12;
        clipY1screen = y1 * Screen.screenSizeX;
        clipY2screen = y2 * Screen.screenSizeX;
    }

    public void fill() {
        for (int y = 0; y < Screen.screenSizeY * Screen.screenSizeX; y += Screen.screenSizeX) {
            this.pixel = this.background;
            for (int index = y; index < y + Screen.screenSizeX; ++index) {
                if (this.screendataWorking[index] == this.background) {
                    this.screendataWorking[index] = this.pixel;
                    continue;
                }
                this.pixel = this.pixel == this.background ? this.screendataWorking[index] : this.background;
            }
        }
    }
}

