/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.gfx;

import abyss.lunarengine.gfx.Point3D;
import abyss.lunarengine.gfx.Tools2D;
import java.util.Vector;

public class Object3D {
    public static Tools2D tools2D;
    public double alpha;
    public double beta;
    public double gamma;
    public volatile double turnAlpha;
    public volatile double turnBeta;
    public volatile double turnGamma;
    public int focus1;
    public int focus2;
    public int deltaX;
    public int deltaY;
    public int deltaZ;
    public Point3D[] points;
    private static final double DEG2RAD = Math.PI / 180;
    private Vector<Point3D> vecPoints = new Vector();

    public void addPoint(Point3D point) {
        this.vecPoints.add(point);
    }

    public void createArrays() {
        System.out.println("Object3D.createArrays: " + this.vecPoints.size());
        this.points = new Point3D[this.vecPoints.size()];
        for (int i = 0; i < this.vecPoints.size(); ++i) {
            Point3D point = this.vecPoints.get(i);
            point.shiftLeft();
            this.points[i] = point;
        }
    }

    public void rotateVBI() {
        this.alpha += this.turnAlpha;
        this.beta += this.turnBeta;
        this.gamma += this.turnGamma;
    }

    public void rotateCALC() {
        int x = 0;
        int y = 0;
        int z = 0;
        int xi = 0;
        int yi = 0;
        int zi = 0;
        double sina = Math.sin(Math.PI / 180 * this.alpha);
        double cosa = Math.cos(Math.PI / 180 * this.alpha);
        double sinb = Math.sin(Math.PI / 180 * this.beta);
        double cosb = Math.cos(Math.PI / 180 * this.beta);
        double sinc = Math.sin(Math.PI / 180 * this.gamma);
        double cosc = Math.cos(Math.PI / 180 * this.gamma);
        double axx = cosa * cosb;
        double axy = cosa * sinb * sinc - sina * cosc;
        double axz = cosa * sinb * cosc + sina * sinc;
        double ayx = sina * cosb;
        double ayy = sina * sinb * sinc + cosa * cosc;
        double ayz = sina * sinb * cosc - cosa * sinc;
        double azx = -sinb;
        double azy = cosb * sinc;
        double azz = cosb * cosc;
        int deltaXs = this.deltaX << 12;
        int deltaYs = this.deltaY << 12;
        int deltaZs = this.deltaZ << 12;
        for (int i = 0; i < this.points.length; ++i) {
            if (!this.points[i].enabled) continue;
            x = this.points[i].sx + deltaXs;
            y = this.points[i].sy + deltaYs;
            z = this.points[i].sz + deltaZs;
            xi = (int)(axx * (double)x + axy * (double)y + axz * (double)z);
            yi = (int)(ayx * (double)x + ayy * (double)y + ayz * (double)z);
            zi = (int)(azx * (double)x + azy * (double)y + azz * (double)z);
            if (this.focus2 == 0) {
                this.points[i].dx = xi >> 12;
                this.points[i].dy = yi >> 12;
                this.points[i].dz = zi >> 12;
                continue;
            }
            z = zi >> 12;
            int f = this.focus2 - (z >> 1);
            if (f != 0) {
                this.points[i].dx = (xi >> 12) * this.focus1 / f;
                this.points[i].dy = (yi >> 12) * this.focus1 / f;
            } else {
                this.points[i].dx = xi >> 12;
                this.points[i].dy = yi >> 12;
            }
            this.points[i].dz = z;
        }
    }
}

