/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.gfx;

import abyss.lunarengine.Screen;

public class Bob {
    public static final int ANIMTYPE_NOANIM = 0;
    public static final int ANIMTYPE_FORWARD = 1;
    public static final int ANIMTYPE_FORWARDLOOP = 2;
    public static final int ANIMTYPE_BACKWARD = 3;
    public static final int ANIMTYPE_BACKWARDLOOP = 4;
    public static final int ANIMTYPE_PINGPONG = 5;
    private static final int ANIMTYPE_PING = 6;
    private static final int ANIMTYPE_PONG = 7;
    public static final int SHIFT = 12;
    public static int[] screendataToWork;
    private static int clipX1;
    private static int clipY1;
    private static int clipX2;
    private static int clipY2;
    public boolean enabled = false;
    public int[][] bobdata;
    public int bobSizeX;
    public int bobSizeY;
    public int bobSizeXshifted;
    public int bobSizeYshifted;
    public int bobHalfSizeXshifted;
    public int bobHalfSizeYshifted;
    public int posXshifted;
    public int posYshifted;
    public int frame;
    public int frameAsync;
    public int animdelay;
    public int animPos = this.animdelay = 5;
    public int animType;

    private Bob() {
    }

    @Deprecated
    public Bob(Bob bob) {
        this.setSize(bob.bobSizeX, bob.bobSizeY);
        this.bobdata = bob.bobdata;
        this.animType = bob.animType;
        this.animdelay = bob.animdelay;
    }

    public Bob(int frames, int width, int height) {
        this.setSize(width, height);
        if (clipX1 + clipY1 + clipX2 + clipY2 == 0) {
            clipX1 = 0;
            clipY1 = 0;
            clipX2 = Screen.screenSizeX;
            clipY2 = Screen.screenSizeY;
        }
        this.bobdata = new int[frames][this.bobSizeX * this.bobSizeY];
    }

    public static void setClippingArea(int x1, int y1, int x2, int y2) {
        clipX1 = x1;
        clipY1 = y1;
        clipX2 = x2;
        clipY2 = y2;
    }

    public void vbi() {
        if (this.enabled) {
            if (--this.animPos > 0) {
                return;
            }
            this.animPos = this.animdelay;
            switch (this.animType) {
                case 0: {
                    break;
                }
                case 1: {
                    if (++this.frameAsync == this.bobdata.length) {
                        this.frameAsync = 0;
                        this.enabled = false;
                    }
                    this.frame = this.frameAsync;
                    break;
                }
                case 2: {
                    if (++this.frameAsync == this.bobdata.length) {
                        this.frameAsync = 0;
                    }
                    this.frame = this.frameAsync;
                    break;
                }
                case 3: {
                    if (--this.frameAsync == -1) {
                        this.frameAsync = this.bobdata.length - 1;
                        this.enabled = false;
                    }
                    this.frame = this.frameAsync;
                    break;
                }
                case 4: {
                    if (--this.frameAsync == -1) {
                        this.frameAsync = this.bobdata.length - 1;
                    }
                    this.frame = this.frameAsync;
                    break;
                }
                case 6: {
                    if (++this.frameAsync == this.bobdata.length) {
                        this.frameAsync -= 2;
                        this.animType = 7;
                    }
                    this.frame = this.frameAsync;
                    break;
                }
                case 7: {
                    if (--this.frameAsync == -1) {
                        this.frameAsync += 2;
                        this.animType = 6;
                    }
                    this.frame = this.frameAsync;
                }
            }
        }
    }

    public void render() {
        this.render(this.posXshifted >> 12, this.posYshifted >> 12);
    }

    public void render(int posX, int posY) {
        if (this.enabled) {
            int startX = posX < 0 ? -posX : 0;
            int endX = posX + this.bobSizeX > clipX2 ? clipX2 - posX : this.bobSizeX;
            int startY = posY < 0 ? -posY : 0;
            int endY = posY + this.bobSizeY > clipY2 ? clipY2 - posY + posY : this.bobSizeY + posY;
            int offsetBob = startY * this.bobSizeX;
            int offset = (startY += posY) * clipX2 + posX;
            int y = startY;
            while (y < endY) {
                for (int x = startX; x < endX; ++x) {
                    int pixel = this.bobdata[this.frame][offsetBob + x];
                    if (pixel >= 0) continue;
                    Bob.screendataToWork[offset + x] = pixel;
                }
                ++y;
                offsetBob += this.bobSizeX;
                offset += clipX2;
            }
        }
    }

    public void setAnimType(String animType) {
        if (animType.length() == "NOANIM".length() && animType.equalsIgnoreCase("NOANIM")) {
            this.setAnimType(0);
        } else if (animType.length() == "FORWARD".length() && animType.equalsIgnoreCase("FORWARD")) {
            this.setAnimType(1);
        } else if (animType.length() == "FORWARDLOOP".length() && animType.equalsIgnoreCase("FORWARDLOOP")) {
            this.setAnimType(2);
        } else if (animType.length() == "BACKWARD".length() && animType.equalsIgnoreCase("BACKWARD")) {
            this.setAnimType(3);
        } else if (animType.length() == "BACKWARDLOOP".length() && animType.equalsIgnoreCase("BACKWARDLOOP")) {
            this.setAnimType(4);
        } else if (animType.length() == "PINGPONG".length() && animType.equalsIgnoreCase("PINGPONG")) {
            this.setAnimType(5);
        } else {
            throw new RuntimeException("Illegal anim type: " + animType);
        }
    }

    public void setAnimType(int animType) {
        this.animType = animType;
        if (animType == 5) {
            this.animType = 6;
        }
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public void setAnimDelay(int animDelay) {
        this.animdelay = animDelay;
    }

    public int getPosX() {
        return this.posXshifted >> 12;
    }

    public int getPosY() {
        return this.posYshifted >> 12;
    }

    private void setSize(int width, int height) {
        this.bobSizeX = width;
        this.bobSizeXshifted = width << 12;
        this.bobHalfSizeXshifted = this.bobSizeXshifted >>> 1;
        this.bobSizeY = height;
        this.bobSizeYshifted = height << 12;
        this.bobHalfSizeYshifted = this.bobSizeYshifted >>> 1;
    }

    public void setPos(int posX, int posY) {
        this.posXshifted = posX << 12;
        this.posYshifted = posY << 12;
    }

    public Bob clone() {
        Bob newbob = new Bob();
        newbob.setSize(this.bobSizeX, this.bobSizeY);
        newbob.bobdata = this.bobdata;
        newbob.animType = this.animType;
        newbob.animdelay = this.animdelay;
        return newbob;
    }

    static {
        clipX1 = 0;
        clipY1 = 0;
        clipX2 = 0;
        clipY2 = 0;
    }
}

