;METAL256 by Abaddon (2020)
;  code:TomCat / music:ern0
;   PC Speaker safe version

Divider EQU 72

ORG 256
 DW 24          ; constant 127 -> amplitude for sinus table
 DW 3C00H       ; constant 1/128 -> calculating PI/128 for sinus table

 MOV BH,64
@@:
 FLDPI          ; PI
 FMUL DWORD [SI]; PI/128
 FIMUL WORD [DI]; counter*PI/128
 FSIN           ; SIN(counter*PI/128)
 FIMUL WORD [SI]; 127*SIN(counter*PI/128)
 FISTP WORD [BX+SI]; -
 INC BX
 DEC BYTE [DI]  ; loop 256x
 JNZ @B         ; BX = sinus table (FC00H)

 MOV AL,13H     ; set video mode 320x200
 INT 10H        ; call VGA Bios

 MOV BP,BX

 MOV AX,3508H
 INT 21H
 PUSH ES
 PUSH BX

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 ADD AL,Divider-90H     ; carry flag means turn on the speaker
 CALL init

 MOV BX,BP

 PUSH 0A000H-10
 POP ES
nextframe:
 DEC BL
 MOV AX,[IRQ.COUNTER+1]
 IMUL AX,AX,8
 MOV CX,11110000B*256+7*14
 XOR CH,AH
 MOV AX,0CCCDH
nextpixel:
 PUSHA
 SHRD WORD [SI],CX,8+4
 MUL DI
nextcircle:
 XOR [SI],BH
 MOV AL,DL
 SUB AL,[BX]
 ADD BL,BH
 IMUL AL
 XCHG BP,AX
 MOV AL,DH
 SUB AL,100
 SUB AL,[BX]
 IMUL AL
 ADD BP,AX
 MOV AL,CL
 MUL AL
 CMP BP,AX
 JNB skip
 SUB BL,CH
 SUB CL,7
 JNZ nextcircle
skip:
 MOVSB
 POPA
 DEC DI
 JNZ nextpixel

 MOV AH,1
 INT 16H
 JZ nextframe

 POP DX
 POP DS
 SALC

init:
 OUT 40H,AL
 MOV AL,0
 OUT 40H,AL
 SALC
 OUT 61H,AL
 MOV AX,2508H
 INT 21H
RETN

; --------------------------- music please ! -------------------------------
INCLUDE "NOTES.INC"

BASE = NOTES-15

NOTES:
 DB G_2,As2,C_3,G_2
 DB As2,Cs3,C_3,C_3
 DB G_2,As2,C_3,As2
 DB G_2,G_2,G_2

 DB D_3,F_3,G_3,D_3
 DB F_3,Gs3,G_3,G_3
 DB D_3,F_3,G_3,F_3
 DB D_3,D_3,D_3

 DB 10110101B
 DB 01111010B
 DB 10110101B
 DB 00011110B

IRQ:
 PUSHA
 MOV AL,2
.SAMPLE:

 SHR AL,1               ; zero means pause (no sound)
 JZ @F
 OUT 42H,AL             ; out the 6bit sample
@@:

 DB 66H,68H             ; PUSH DWORD 00000000H
.COUNTER:
 DB 0,0,0               ; timer counter (default 0)
 DB 0                   ; sample sum (default 0)
 POP SI                 ; SI=timer counter
 POP BX                 ; BL=pattern, BH=volume

 MOV BP,BASE
 INC DWORD [BP-BASE+IRQ.COUNTER]

NOTEZ:
 MOV DI,BX
 SHLD DI,SI,4
 AND DI,31

 BT [BP+15+30],DI
 JNC .2
 SHR DI,1

 MOV CX,4002H
.0:
 ADD DI,15
 SALC
.1:
 MOV AH,[BP+DI]
 ADD AH,CL
 MUL SI
 AND DX,31
 ADD BH,DL
 DEC CL
 JZ .0
 JNS .1

 OR BH,CH               ; overdrive effect
 SUB BH,CH
.2:

 MOV AX,1
SEED:
 MOV CX,12              ; tempo
 BT SI,CX
 SBB CL,CH
 TEST BL,6
 LOOPZ DONE

HIHAT:
 BT SI,CX
 JC .1
 IMUL AX,AX,117;-15
 MOV [BP-BASE+SEED-2],AX
 MUL SI
 AND DL,31              ; volume
 ADD BH,DL
.1:

DONE:
 MOV [BP-BASE+IRQ.SAMPLE-1],BH

 MOV AL,20H
 OUT 20H,AL
 POPA
IRET
