;OK time to make a VC4000 Megademo...

;This demo won't need to hide behind a real Commodore 64 demo from the late 80's (except for the music. And the visuals. And the code.)

;SO these two lines on top of the screen I will probably replace with dashes from the grid generator. 
;Or just start on a blank screen.
;LOAD"*",8
;				(this line left intentionally blank)
;SEARCHING FOR * (FOR * can be omitted since that will need more than 4 sprites)
;LOADING
;READY.
;RUN

;START $0000
;Scratchpad-RAM:
R0SCRATCH    equ $1f0e
R1SCRATCH     equ $1f0f
R2SCRATCH     equ $1f1e
R3SCRATCH     equ $1f1f
MUUHMIST      equ $1f4e
BGCOLOR       equ $1fc6
SIZES         equ $1fc0
R0COPY        equ $1F67
SCORELT       equ $1fc8
SCORERT       equ $1fc9
SPRITE0       equ $1f00
SPRITE1       equ $1f10
SPRITE2       equ $1f20
SPRITE3       equ $1f40

SPR0BIRR	equ $1E0A
SPR1BIRR	equ $1E1A
SPR2BIRR	equ $1E2A
SPR3BIRR	equ $1E4A

SPRITE0AX     equ $1f0a
SPDUP0AX	  equ $1f0b
SPRITE0AY     equ $1f0c
SPDUP0AY	  equ $1f0d
SPRITE1AX     equ $1f1a
SPDUP1AX	  equ $1f1b
SPRITE1AY     equ $1f1c
SPDUP1AY	  equ $1f1d
SPRITE2AX     equ $1f2a
SPDUP2AX	  equ $1f2b
SPRITE2AY     equ $1f2c
SPDUP2AY	  equ $1f2d
SPRITE3AX     equ $1f4a
SPDUP3AX	  equ $1f4b
SPRITE3AY     equ $1f4c
SPDUP3AY	  equ $1f4d
SPCOLOR01	  equ $1fc1
SPCOLOR23	  equ $1fc2
JOYSTICK1     equ $1fcc
JOYSTICK2     equ $1fcd
P1MIDDLEKEYS  equ $1e89
P2MIDDLEKEYS  equ $1e8D        ;(R/-)
PITCH         equ $1fc7
NOISE         equ $1e80		;2 bits volume 11=lowest 00=highest. BG Invert flag. Noise on. Sound on. 2 bits unknown.
BGCOLLIDE	  equ $1fca		;Sprite/Background collision sowie Sprite Drawing completed
SPR_COLL      equ $1fcb
SCORECTRL       equ $1FC3        ;(-/W)
COLOR12		equ $1FC1
COLOR34		equ $1FC2

FLAG_PSU      equ %01000000 ; Maske: Flag-Bit fr Joystick-Richtung
REG_PSL       equ %00010000 ; Maske: Registersatz whlen

MAXFCOUNT	equ 32 ;26 mit BUNDISCH, 40 ohne, muss aber durch 8 teilbar sein, also 32. Wobei 24 htte ich probieren knnen.
TEXTLEN		equ 73 ;41 ;length of scrolltext in bytes (which is pixels / 8)

;User variables - need to nick'em from CANABALT since this is gonna be canabalt's easter egg

MUSBEAT		equ $1f0e	;separate counter for the drums, only counts to 18.
MUSBIDX		equ $1f0f	;Where in the bar are we? (there's a number of tables with bar data - this is the pointer to the entry in the table)
MUSBAR		equ $1f1e	;where in the song are we? (there's a number of tables with bar data - this is the pointer to which of these we're at now)

QUAK		equ $1f1F ;isn't really even used

;well since there's no 16 bit offset, I'll have to create a switch-case scenario with addresses... :-(
MUSWAIT		equ $1F4E	;wait for n frames as encoded in the data set
MUSBPTR		equ $1F4F	;where are we in the Drum track?

;f50-f59 sind belegt von Scrolltext!
FRAMECOUNT	equ $1f5a
FCOUNTDIV8	equ $1f5b
TEXTPOINTER	equ $1f5c

;1f5f-1f6d are now a program...

;these are just flags. But the CPU's too slow to extract one bit and test it.
P1S1		equ $1F5d ;CAN BE REUSED in Part 2
P1S2		equ $1F5e ;CAN BE REUSED in Part 2
P1S3		equ $1fad ;CAN BE REUSED in Part 2 - I need 1f5f for a program!

;OK 1F60 to 1F6D are freeeee - I could copy the part of the music routine that needs its adresses modified in there.
;that would make it the first VC4000 program to run code from RAM. With 37 Bytes!

;2650 Equates, need that to compile :-(-----------------------------------
z               equ 0
eq              equ z
p               equ 1
gt              equ p
n               equ 2
lt              equ n
un              equ 3

;BOOT:
        bcta,un MAIN         ;goto MAIN

ISR:
	retc,un

;OK NOTE: The music data NEEDS to be here. Otherwise I will have to change all the hardcoded addresses every time I hit compile.
DRUMS: ;                                   $11         $11 - tried that - doesn't work - blends in. Indistinct.
	DB $11,$11,$11,$00,$11,$00,$11,$11,$10,$00,$10,$00,$00,$00,$10,$00
;MUSIC DATA will be NOISE, PITCH, WAIT.
;NOISE will be the exact value to be POKEd into the NOISE register (minus the least significant 2 bits which encode "special" "effects")
;the ORed data from DRUMS and music will have bit 0 for a thud instead of a bang and bit 1 for End Of Measure.
;PITCH will be directly POKEd into the PITCH register
;WAIT denotes the number of frames to wait until the next entry will be read from the table.
;NOTE that WAIT gets decremented AFTER being loaded. So a value of 0 means 255 frames.
;Also NOTE that the drums aren't linked to the music data so you need to take meticulous care to make sure the drums and music don't drift apart.

;TAKT0: erstmal Stille
;Idee fr Implementierung: Wenn MUSBAR==0 dann ist Musik disabled. Ich setze dann im Code irgendwo MUSBAR auf 1, damit die Musik losgeht. Und genau so hab ichs gemacht.
TAKT1:
	;OH COPULATION AFFIRMATIVE IT WORKS (NOTE it only works on the first two versions of the VC4000, the last model doesn't have the audio shield anymore and only produces the bass drum but no toms)
	DB %00100000, 0, 1
	DB %00000000, 0, 8
	DB %00001010, 0, 9

;erstmal ne "Notentabelle". You try to find sheet music for Techno... ...couldn't even find a MIDI file...

;2:48 wirds interessant. Wenn Vorgeplnkel, dann erst 2:24
;meine eigene Kopie leiert zu dolle - Youtube 4:42 wirds interessant, also Vorgeplnkel 4:16

;Vorgeplnkel: $22 - Fade-In 1 Takt (18 Einheiten)

;Lautstrke (leise->laut): (01 macht keinen Unterschied zu 00)
;11 -> 10 ->00
TAKT2:
; DB $22, 16 Takte *18 A 220 - doof 16*16 ist schon 256 - naja mit Pseudohllkurve...
	DB %11001000, $22, 18
	DB %10001000, $22, 18
	DB %00001000, $22, 225
	DB %11001000, $22, 9 ;Pseudohllkurve
	DB %11001000, 0, 18 ;NOTE if setting square to 0 but keeping it enabled, it will have slow attack.
; DB $1F, 8 Takte *18 H 246 - auch hier - 2 verschiedene Methoden, gleiches Ergebnis.
	DB %11001000, $1F, 18
	DB %10001000, $1F, 18
	DB %00001000, $1F, 81
	DB %11001000, $1F, 9
	DB %11001000, 0, 18
; DB $2C, 8 Takte *18 F 174
	DB %11001000, $2C, 18
	DB %10001000, $2C, 18
	DB %00001000, $2C, 81
	DB %11001000, $2C, 9
	DB %11001010, 0, 18

;das Ganze 2*


TAKT3:
;Hier kommt das Interessante
;Mein Smartphone sagt $08 fr 12 Takte - aber leider gibts kein hohes C. Nur B und C#.
;also nehm ich eins drunter. 
;$11 fr 12 Takte A 440 hey stimmt ja! OK wenn 2 Methoden zum selben Ergebnis kommen...
	DB %11001000, $11, 18
	DB %10001000, $11, 18
	DB %00001000, $11, 162
	DB %11001000, $11, 18
;$0E fr 2 Takte       C 523
	DB %11001000, $0E, 9
	DB %10001000, $0E, 9
	DB %00001000, $0E, 18
;$0C fr 2 Takte (ughhh...) D 587 (ughhh weil die Frequenz nix is - das ist kein Ton, zumindest net nach der Chromatischen Skala...)
	DB %11001000, $0C, 9
	DB %10001000, $0C, 9
	DB %00001000, $0C, 18
;$13 fr 12 Takte		G 392
	DB %11001000, $13, 9
	DB %10001000, $13, 9
	DB %00001000, $13, 189 ;not a typo
	DB %11001000, $13, 9
;$0E fr 2 Takte       C 523
	DB %11001000, $0E, 9
	DB %10001000, $0E, 9
	DB %00001000, $0E, 18
;$0C fr 2 Takte (ughhh...) D 587 (ughhh weil die Frequenz nix is - das ist kein Ton, zumindest net nach der Chromatischen Skala...)
	DB %11001000, $0C, 9
	DB %10001000, $0C, 9
	DB %00001010, $0C, 18

;***REPEAT*** (3*)

;NOTE ab hier hab ich nen Frequenzzhler und Summen in ein Mikrofon genommen. Von der Ablesung scheint es perfekt zu sein.

TAKT4a:
;Dann kommt der Bassy Part (allerdings mit der interessanten Melodie, die hier nicht implementiert ist.)
;(ich habs probiert - es klingt SCHEIE! Schade...)
;x x   x :| (2 spaces=9 frames)
;$63 x8 (JETZT ABER! Hat nur 4 Stunden Trial&Error mit verschiedenen Methoden gebraucht - ist ein D.)
	DB %00001000, $63, 3
	DB 0, 0, 6
	DB %00001000, $63, 3
	DB 0, 0, 15
	DB %00001000, $63, 3
	DB %00000010, 0, 6


TAKT4b:
;$58 x4 Ist ein F
	DB %00001000, $58, 3
	DB 0, 0, 6
	DB %00001000, $58, 3
	DB 0, 0, 15
	DB %00001000, $58, 3
	DB %00000010, 0, 6

TAKT4c:
;$4F x2 Ist ein G
	DB %00001000, $4F, 3
	DB 0, 0, 6
	DB %00001000, $4F, 3
	DB 0, 0, 15
	DB %00001000, $4F, 3
	DB 0, 0, 6
	DB %00001000, $4F, 3
	DB 0, 0, 6
	DB %00001000, $4F, 3
	DB 0, 0, 15
	DB %00001000, $4F, 3
	DB 0, 0, 6
;$46 x2 Ist ein A
	DB %00001000, $46, 3
	DB 0, 0, 6
	DB %00001000, $46, 3
	DB 0, 0, 15
	DB %00001000, $46, 3
	DB 0, 0, 6
	DB %00001000, $46, 3
	DB 0, 0, 6
	DB %00001000, $46, 3
	DB 0, 0, 15
	DB %00001000, $46, 3
	DB %00000010, 0, 6

;***REPEAT*** (2x)

TAKT5:
;der geile Stakkato-Lead Sound:
;$34 D 146 oder 293 $1a - macht Sinn
	DB 8, $1a, 3
	DB 0,0,6
; A 220 $22 oder 440 $11.
	DB 8,$11, 3
	DB 0,0,6
; C (notfalls 261 $1d) 523 $0e
	DB 8, $0e, 3
	DB 0,0,6
; A 220 oder 440
	DB 8, $11, 3
	DB 0,0,6
; A
	DB 8, $11, 3
	DB 0,0,6
; A
	DB 8, $11, 3
	DB 0,0,6
; A
	DB 8, $11, 3
	DB 0,0,6
; E 330 $17
	DB 8, $17, 3
	DB %00000010,0,6
;***REPEAT*** (16x!)

TAKT5a: ;Stakkato + Interessanter Lead Part 1 (wird 3x wiederholt)
;$34 D 146 oder 293 $1a - macht Sinn
	DB 8, $1a, 3
	DB %11001000,$11,6
; A 220 $22 oder 440 $11.
	DB 8,$11, 3
	DB %11001000,$11,6
; C (notfalls 261 $1d) 523 $0e
	DB 8, $0e, 3
	DB %11001000,$11,6
; A 220 oder 440
	DB 8, $11, 3
	DB $C8,$11,6
; A
	DB 8, $11, 3
	DB $C8,$11,6
; A
	DB 8, $11, 3
	DB $C8,$11,6
; A
	DB 8, $11, 3
	DB $C8,$11,6
; E 330 $17
	DB 8, $17, 3
	DB %11001010,$11,6
;***3x***

TAKT5b:
;der geile Stakkato-Lead Sound + Interessanter Lead Part 2 und 4
;$34 D 146 oder 293 $1a - macht Sinn
	DB 8, $1a, 3
	DB %11001000,$0E,6
; A 220 $22 oder 440 $11.
	DB 8,$11, 3
	DB %11001000,$0E,6
; C (notfalls 261 $1d) 523 $0e
	DB 8, $0e, 3
	DB %11001000,$0E,6
; A 220 oder 440
	DB 8, $11, 3
	DB $C8,$0E,6
; A
	DB 8, $11, 3
	DB $C8,$0C,6
; A
	DB 8, $11, 3
	DB $C8,$0C,6
; A
	DB 8, $11, 3
	DB $C8,$0C,6
; E 330 $17
	DB 8, $17, 3
	DB %11001010,$0C,6

TAKT5c:
;der geile Stakkato-Lead Sound + Interessanter Lead Part 3
;$34 D 146 oder 293 $1a - macht Sinn
	DB 8, $1a, 3
	DB %11001000,$13,6
; A 220 $22 oder 440 $11.
	DB 8,$11, 3
	DB %11001000,$13,6
; C (notfalls 261 $1d) 523 $0e
	DB 8, $0e, 3
	DB %11001000,$13,6
; A 220 oder 440
	DB 8, $11, 3
	DB $C8,$13,6
; A
	DB 8, $11, 3
	DB $C8,$13,6
; A
	DB 8, $11, 3
	DB $C8,$13,6
; A
	DB 8, $11, 3
	DB $C8,$13,6
; E 330 $17
	DB 8, $17, 3
	DB %11001010,$13,6


;Dann wiederholung vom Bassy Part OHNE Interessanten Part (1x)

;SO UND JETZT MIXEN WIR BASSY PART UND STAKKATO (hab ich probiert, klingt kacke)

;SO UND JETZT MIXEN WIR STAKKATO LEAD MIT VORGEPLNKEL (wird klappen) (und nur 1x!)

;SO UND JETZT MIXEN WIR STAKKATO LEAD MIT DEM INTERESSANTEN PART (wird ughh... beide spielen dieselbe Oktave...) (4x)

;Wiederholung vom Interessanten Part **OHNE DRUMS!** (1x)

;STAKKATO LEAD + Interessanter Part (Wiederholung) (2x) - und dat schickt dann schon

REPTABL:
	DB 0 ;do nothing until music is activated.
	DB 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,4,4,5,5,5,5,6,7,7,7,7,5,5,5,5,6,8,8,8,9,10,10,10,9,8,8,8,9,10,10,10,9,8,8,8,9,10,10,10,9,$13,$13,0
	;last repetition of 8,8,8,9,10,10,10,9 could be omitted
	;NOTE that the music has to be halted from code, otherwise it will do the drums for ever.

MUSICPROG: ;this is the music kernel routine. It gets copied to RAM so I can just overwrite the bytes every time
	DB $0D, $60, $14 ;LODA,r0 TAKT1,r1 ;**0ACC is start address of TAKT1 - 0C3A is Takt5A - FIXME: Addresses are in need of changing every time I hit compile.
	DB $63 ;IORZ r3
	DB $C3 ;STRZ r3 ;DON'T APPLY NOISE - that happens on ENDMUSIC
	DB $0D, $20, $14 ;LODA,r0 TAKT1,r1+ ;finally we can count up...
	DB $CC, $1F, $C7 ;STRA,r0 PITCH
	DB $0D, $20, $14 ;LODA,r0 TAKT1,r1+ ;increment again
	DB $17 ;retc, un ;since this will be called like a RAM routine
MUSADDR:
	DB 0,0 ; fuck it. Doing it right means I will have to adapt ALL the addresses here again.
	DB $20, $14 ;using 2x so there's only one time per copy I will have to IORI, $40.
	DB $20, $1D
	DB $20, $4A
	DB $20, $86
	DB $20, $98
	DB $20, $AA
	DB $20, $F2
	DB $21, $22
	DB $21, $52
	DB $21, $82


MUSIC:
	CPSL %00011000 ;Registerbank 1 aktivieren und Carry abschalten, falls das an ist...
	eorz r0 ;clear R0 - if JUSTADDBEAT, r3 will be assigned whatever was in R0 before MUSIC was called.
;COUNTERS
	;When the beat drops, it will overwrite r3, turning off the MUSIC.
	;So if I IOR r3 to r0 after loading the drums, it will leave the music on.
	;But if I do that, everything will be IORed to r3, leading to all bits 1 eventually...
	;Which bits need to be preserved: VV--NS--
	;this means that HERE we will ANDI,r3 $CC
	;But prior to loading NOISE from DATA, we will ANDI,r3 $33.
	ANDI,r3 $CC
	STRA,r3 NOISE
	LODZ r3
	
	
	LODA,r1 MUSBEAT
	COMI,r1 9
	BCTR,eq EXTRAWURST
	COMI,r1 0
	BCFR,z JUSTADDBEAT
EXTRAWURST:
	LODA,r2 MUSBPTR
	ANDI,r2 $0F ;whatever - 16 beats.
	IORA,r0 DRUMS,r2
	ADDI,r2 1 ;OK waste 2 bytes, but using register increments increments BEFORE fetching, rendering them useless here
	STRA,r2 MUSBPTR
	COMI,r1 0
	BCTR,gt JUSTADDBEAT
	LODI,r1 18
JUSTADDBEAT:
	SUBI,r1 1
	STRA,r1 MUSBEAT
	STRZ r3
	;r3 now has DRUM value.
	
	;trying to solve this problem in an elegant way failed big time.
	;(check if we have to mute the drums)
	LODA,r2 MUSBAR
	LODA,r0 REPTABL,r2
	COMI,r0 16
	BCTR,lt MUTEDRUM
	IORI,r3 $04 ;MUTE NOISE but make Square sound better on full volume
MUTEDRUM:

	;check if WAIT is zero. If so, OR the music data to r0 and apply PITCH
	LODA,r0 MUSWAIT
	BCFA,z ENDMUSIC

	
	LODA,r2 MUSBAR
	;STRA,r2 SCORELT ;-DEBUG INFO
	LODA,r1 MUSBIDX ;points to the actual data value
	;STRA,r1 SCORERT ;-DEBUG INFO
	LODA,r0 REPTABL,r2 ;BXA isn't enough - the music data spans more than 256 bytes. Way more.
	bcta,z ENDMUSIC ;if r0==0 then just drums
	ANDI,r3 $33

	BSTA,un $1f5f ;JUMP TO FRIGGIN RAM! (contains the music kernal routine which needs self-modifying code, otherwise I have to copy the same code over and over and over - see earlier versions of the demo or music.asm)

MUSICONT:
	STRA,r0 MUSWAIT
	ADDI,r1 1 ;increment for next loop...
	STRA,r1 MUSBIDX
	
	TMI,r3 2 ;END OF MEASURE
	BCFR,eq ENDMUSIC

	;increment repeat table, load value from repeat table
	ADDI,r2 1
	STRA,r2 MUSBAR
	
	;SELF MODIFYING CODE
	STRZ r1
	LODA,r0 REPTABL,r2
	ANDI,r0 $0F
	STRZ r2
	RRL,r2
	
	LODA,r0 MUSADDR,r2
	STRA,r0 $1F65
	STRA,r0 $1F6B
	IORI,r0 $40
	STRA,r0 $1F60
	LODA,r0 MUSADDR,r2+
	STRA,r0 $1F61
	STRA,r0 $1F66
	STRA,r0 $1F6C
	LODZ r1 

	LODI,r2 0
	STRA,r2 MUSBIDX

ENDMUSIC:
	SUBI,r0 1 ;R0 contains MUSWAIT no matter how we got here
	STRA,r0 MUSWAIT

	;apply NOISE - NOTE I don't have to AND %11011100 because 1) I can insert background inversions to match the beat of the music at special parts and the least 2 significant bits are completely ignored by the hardware
	STRA,r3 NOISE
	TMI,r3 1
	BCFR,eq ENDDRUM
	ANDI,r3 $EF		;turn off noise: NOTE: Make sure, LSB is only 1 if MSB's 1-bit (16-bit) is set, otherwise we'll have runaway noise...
	STRA,r3 NOISE
ENDDRUM:

	PPSL REG_PSL
	retc,un




HIDE_SPRITES1A:
	LODI,r0 $F0
	STRA,r0 SPDUP0AY
	STRA,r0 SPDUP1AY
	STRA,r0 SPDUP2AY
	STRA,r0 SPDUP3AY
	BCTA,un WAIT_VRLE2
HIDE_SPRITES1B:
	LODI,r0 $F0
	STRA,r0 SPDUP0AX
	STRA,r0 SPDUP1AX
	STRA,r0 SPDUP2AX
	STRA,r0 SPDUP3AX
	BCTA,un WAIT_VRLE2

MAIN:

    PPSU %00100000 ;Interrupts deaktivieren
    PPSL %00000010

;blank memory
	lodi,r0 $08
	lpsu
	lodi,r0 $02
	lpsl                 ; use logical (unsigned) compare
	
	LODI,r0 0 ;if NOISE happens to be set, mute it.
	STRA,r0 PITCH
	LODI,r0 4
	STRA,r0 NOISE


	;Clear screen - NOTE this is only really necessary when developing using a RAM based PROM emulator.
	LODI,r3 $ff
CLRRAM:
    LODI,r0 $00
    STRA,r0 $1F00,r3+
    COMI,r3 $ff
    BCTR,lt CLRRAM
	
    STRA,r0 NOISE
	
	LODI,r3 $ff
CLRSCR2:
    LODI,r0 $FF
    STRA,r0 $1F80,r3+
    COMI,r3 $30
    BCTR,lt CLRSCR2
    STRA,r0 SCORELT
    STRA,r0 SCORERT
    
    ;;;BCTA,un BRIDGEINI ;Jump to part 2 immediately for DEBUG. FIXME remove this line when debugging is done
	LODI,r3 $FF
COPYMUSIC:
	LODA,r0 MUSICPROG,r3+
	STRA,r0 $1f5F,r3 ;STORE IT IN RAM!!!!! (5 exclamation marks. A sure sign of a diseased mind.)
	COMI,r3 15
	BCTR,lt COPYMUSIC	
    

    LODI,r0 %00100100
    STRA,r0 SPCOLOR01
    STRA,r0 SPCOLOR23
    ;I *COULD* put in a 50 frame black screen wait routine.
    LODI,r0 %00011011
    STRA,r0 BGCOLOR
    LODI,r2 10
BOOT1LOOP:	;simulate booting BASIC after booting KERNAL
    LODA,r0 SPR_COLL       ; Lade das Kollisionsregister (Bit 6 dort ist das VRLE-Flag)
    RRL,r0                 ; Bit 6 wird zu Bit 7 und kann nun getestet werden:
    BCFR,lt BOOT1LOOP      ; Wenn nicht negativ (Bit 7 nicht gesetzt), springe zurck.
	BDRR,r2 BOOT1LOOP


ALTJUMPMARK: ;DEMO INTRO
WAIT_VRLE2:
    LODA,r0 SPR_COLL       ; Lade das Kollisionsregister (Bit 6 dort ist das VRLE-Flag)
    RRL,r0                 ; Bit 6 wird zu Bit 7 und kann nun getestet werden:
    BCFR,lt WAIT_VRLE2      ; Wenn nicht negativ (Bit 7 nicht gesetzt), springe zurck.
	;code goes here
	LODA,r1 FRAMECOUNT
	ADDI,r1 1
	STRA,r1 FRAMECOUNT
	COMI,r1 30
	BCTR,lt ENDPART1
	LODI,r2 $FF
	STRA,r2 P1S1
	COMI,r1 200
	BCTR,lt ENDPART1
	STRA,r2 P1S2
	COMI,r1 220
	BCTR,lt ENDPART1
	STRA,r2 P1S3
ENDPART1:
	
	
	eorz r0
	STRA,r0 SIZES

    LODI,r0 $20
    STRA,r0 SPRITE0AX
    STRA,r0 SPDUP0AX
    STRA,r0 SPRITE0AY
    STRA,r0 SPRITE1AY
    STRA,r0 SPRITE2AY
    STRA,r0 SPRITE3AY
    ADDI,r0 $08
    STRA,r0 SPRITE1AX
    STRA,r0 SPDUP1AX
    ADDI,r0 $08
    STRA,r0 SPRITE2AX
    STRA,r0 SPDUP2AX
    ADDI,r0 $08
    STRA,r0 SPRITE3AX
    STRA,r0 SPDUP3AX
    LODI,r3 $ff
VLOOP2:
	;Grafik setzen
    LODA,r0 LOAD0,r3+
    STRA,r0 SPRITE0,r3
    LODA,r0 LOAD1,r3
    STRA,r0 SPRITE1,r3
    LODA,r0 LOAD2,r3
    STRA,r0 SPRITE2,r3
    LODA,r0 LOAD3,r3
    STRA,r0 SPRITE3,r3
    COMI,r3 $09
    BCTR,lt VLOOP2

	LODA,r0 BGCOLLIDE ;read to clear flags

WAIT_SPRCOMP2:
	LODA,r0 BGCOLLIDE
	BCTR,z WAIT_SPRCOMP2
;I still appear to be stuck somewhere in the VBLANK period - err no, see below, 1FCA still had the flags set from some previous instance where they were ready.

	;why the heck is this thing so darn slow
	;a 6502 will run circles around the 2650... if clocked at 0.5 MHz.
	;also, a 6502 is just as fast as an 8088. When the 6502 runs at 1 MHz and the 8088 at 4.77MHz. Unless you're dividing, of course.
	

	;Grafik setzen


    LODI,r0 14 ;OK wenn ich das weiter oben mache, funktioniert es nicht...
    STRA,r0 SPDUP0AY
    STRA,r0 SPDUP1AY
    STRA,r0 SPDUP2AY
    STRA,r0 SPDUP3AY


	;NOTE: We have now like 10 scan lines of free raster time...

	LODA,r0 $1FCA; RESET previous Sprite Completion flags (otherwise they linger from earlier readings)
WAIT_SPRCOMP3:
	LODA,r0 $1FCA
	TMI,r0 $01
	BCFR,eq WAIT_SPRCOMP3 ;BCTR,z isn't doing it. Seems you need to TEST MASK.
    LODI,r0 2
    STRA,r0 SPDUP0AY
    STRA,r0 SPDUP1AY
    STRA,r0 SPDUP2AY
    STRA,r0 SPDUP3AY
	
    LODI,r3 0
LINE2:
	;Grafik setzen
    LODA,r0 SRCH0,r3+
    STRA,r0 SPRITE0,r3
    LODA,r0 SRCH1,r3
    STRA,r0 SPRITE1,r3
    LODA,r0 SRCH2,r3
    STRA,r0 SPRITE2,r3
    LODA,r0 SRCH3,r3
    STRA,r0 SPRITE3,r3
    COMI,r3 $09
    BCTR,lt LINE2
    
	;a few questions:
    ;Why is it that if I unroll the loop with 3 sprites it works but if I keep them in a loop it appears to be way too slow?
	;Why can't I use SPRITE0+1,r3 in a loop? That way, I have to store the zero bytes for the graphics, wasting 8 bytes.
    
	;OK loops are outta the question. Gotta unroll the loops and hope it's fast enough. If too fast, insert nops if too slow...
	;also some of the scanlines are similar, so I can skip them
	;OK the manual was right in not stating any difference in runtime between LODA,r0 $something,r3+ and just LODA,r0 $something. There is none.


	;***ANIMATION STEP 1*** (after about 10 frames)
	LODA,r0 P1S1
	BCFA,n HIDE_SPRITES1A

	LODA,r0 $1FCA; RESET previous Sprite Completion flags (otherwise they linger from earlier readings)
WAIT_SPRCOMP4:
	LODA,r0 $1FCA
	TMI,r0 $01
	BCFR,eq WAIT_SPRCOMP4 ;BCTR,z isn't doing it. Seems you need to TEST MASK.
	;UHH just barely enough raster time for a LODA, COMI, BCTR. And that's guessing!



	;OK now we have reliable sprite-ready-loops, time to optimize the code. To the point where it is unreadable. Sorry about that.
;	LODI,r3 $F7
;LOADING:
;	LODA,r0 $1FF7,r3+ ;OK checked the manual - there is no index register for relative addressing.
;	STRA,r0 SPR0BIRR,r3
;	LODA,r0 0,r3
;	STRA,r0 SPR1BIRR,r3
;	BRNR,r3 LOADING
	;DAMN IT!
	LODI,r0 %10000100
	STRA,r0 SPRITE0+1
	LODI,r0 %01001100
	STRA,r0 SPRITE1+1
	LODI,r0 %10100100
	STRA,r0 SPRITE2+1
	LODI,r0 %10001110
	STRA,r0 SPRITE0+2
	LODI,r0 %11101110
	STRA,r0 SPRITE1+2
	LODI,r0 %10100101
	STRA,r0 SPRITE2+2
	LODI,r0 %11000000
	STRA,r0 SPRITE3+1
	STRA,r0 SPRITE3+2
	LODI,r1 %10001010
	STRA,r1 SPRITE0+3
	LODI,r2 %10101010
	STRA,r2 SPRITE1+3
	LODI,r3 %10110101
	STRA,r3 SPRITE2+3
	STRA,r1 SPRITE0+4
	STRA,r2 SPRITE1+4
	STRA,r3 SPRITE2+4
	STRA,r1 SPRITE0+5
	eorz r0
	STRA,r0 SPRITE3+3
	STRA,r0 SPRITE3+4
	LODI,r2 %11101010
	STRA,r2 SPRITE1+5
	LODI,r3 %10101101
	STRA,r3 SPRITE2+5
	STRA,r1 SPRITE0+6
	STRA,r2 SPRITE1+6
	STRA,r3 SPRITE2+6
	STRA,r1 SPRITE0+7
	LODI,r2 %01000000
	STRA,r2 SPRITE3+5
	STRA,r2 SPRITE3+6
	STRA,r2 SPRITE3+7
	LODI,r0 %10101010
	STRA,r0 SPRITE1+7
	LODI,r3 %10100101
	STRA,r3 SPRITE2+7
	LODI,r0 %11101110
	STRA,r0 SPRITE0+8
	LODI,r0 %10101110
	STRA,r0 SPRITE1+8
	LODI,r0 %11000000
	STRA,r0 SPRITE3+8
	STRA,r3 SPRITE2+8
	LODI,r0 %11100100
	STRA,r0 SPRITE0+9
	LODI,r0 %10101100
	STRA,r0 SPRITE1+9
	LODI,r0 %10100100
	STRA,r0 SPRITE2+9
	LODI,r0 %11000000
	STRA,r0 SPRITE3+9 ;OK this doesn't happen (it appears the sprite data are latched at the beginning of a scan line)

	;***ANIMATION STEP 2*** (after about a second)
	LODA,r0 P1S2 ;OK this works, but will need to hide the sprites if true.
	BCFA,n HIDE_SPRITES1B

	;READY line - can stay
    LODI,r0 %11001110
    STRA,r0 SPRITE0+1
    LODI,r3 %01001100
    STRA,r3 SPRITE1+1
    LODI,r0 %10100000
    STRA,r0 SPRITE2+1
    LODI,r1 %11101110
    STRA,r1 SPRITE0+2
    STRA,r1 SPRITE1+2
	LODI,r0 $DF
	STRA,r0 SPDUP3AX
    LODI,r0 %10100000
    STRA,r0 SPRITE2+2
    LODI,r1 %10101000
    STRA,r1 SPRITE0+3
    LODI,r2 %10101010
    STRA,r2 SPRITE1+3
    LODI,r0 %10100000
    STRA,r0 SPRITE2+3
    STRA,r1 SPRITE0+4
    STRA,r2 SPRITE1+4
    STRA,r0 SPRITE2+4
    LODI,r0 %11101100
    STRA,r0 SPRITE0+5
    LODI,r0 %11101010
    STRA,r0 SPRITE1+5
    LODI,r0 %11100000
    STRA,r0 SPRITE2+5
    LODI,r0 %11001100
    STRA,r0 SPRITE0+6
    LODI,r0 %11101010
    STRA,r0 SPRITE1+6
    STRA,r3 SPRITE2+6
    STRA,r1 SPRITE0+7
    STRA,r2 SPRITE1+7
    STRA,r3 SPRITE2+7
    LODI,r1 %10101110
    STRA,r1 SPRITE0+8
    STRA,r1 SPRITE1+8
    STRA,r3 SPRITE2+8
    STRA,r1 SPRITE0+9
    LODI,r0 %10101100
    STRA,r0 SPRITE1+9
    STRA,r3 SPRITE2+9
    
	;OK the next line will only contain RUN: (colon to emulate a turbo cart loaded into the "emulator")
	;so this will only need TWO sprites so a loop should be fast enough now.
	
	LODI,r0 $39 ;moving X is no good here. Also we need it again further down the line.
	STRA,r0 SPDUP2AY
	
	LODI,r3 $FF
RUNLOOP:
	LODA,r0 RUN0,r3+
	STRA,r0 SPRITE0+1,r3
	LODA,r0 RUN1,r3
	STRA,r0 SPRITE1+1,r3
	COMI,r3 9
	BCTR,lt RUNLOOP
	
	
	;OK we do have about 3 scanlines of raster. Enough to do a LOAD TEST CONDITIONALJUMP
	LODI,r0 $2B
	STRA,r0 SPDUP0AY
	STRA,r0 SPDUP1AY

	;*** ANIMATION STEP 3 ***
	LODA,r0 P1S3
	BCTR,n NOHIDESPR
	LODI,r0 $E0
	STRA,r0 SPDUP2AX
	BCTA,un HIDE_SPRITES1A
NOHIDESPR:
	LODI,r0 28 ;A NOP LOOP!
WAIT_SPRCOMP5:
	SUBI,r0 1
	BDRR,r0 WAIT_SPRCOMP5 ;BCTR,z isn't doing it. Seems you need to TEST MASK.
	
	LODI,r0 $1F
	STRA,r0 SPDUP0AX
	LODI,r0 $3F
	STRA,r0 SPDUP1AX
	LODI,r0 $5F
	STRA,r0 SPDUP2AX
	LODI,r0 $6E
	STRA,r0 SPDUP3AX

	LODI,r0 0 ;The SENIL Logo is comprised of all four sprites together with the background bar generator.
	STRA,r0 $1F98 ;Had to make the logo fit. The I is one pixel (one huge pixel) too wide, but that's a restriction of the background bar generator.
	STRA,r0 $1F99
	STRA,r0 $1FA4
	STRA,r0 $1FA5
	LODI,r0 %11001111
	STRA,r0 $1F9B
	STRA,r0 $1FA3
	LODI,r0 %01101010
	STRA,r0 SIZES
	LODI,r0 $15
	STRA,r0 SPDUP3AY

	LODI,r3 $FF
STARLOOP:
	LODA,r0 STAR,r3+
	STRA,r0 SPRITE3,r3
	COMI,r3 9
	BCTR,lt STARLOOP
	LODA,r0 $1FCA
WAIT_SPRCOMP6:
	LODA,r0 $1FCA
	TMI,r0 $01
	BCFR,eq WAIT_SPRCOMP6
	LODI,r0 %10101010
	STRA,r0 SIZES
	LODI,r0 $7F
	STRA,r0 SPDUP3AX

	LODI,r3 $FF
SENILOOP:
	LODA,r0 SENIL0,r3+
	STRA,r0 SPRITE0,r3
	LODA,r0 SENIL1,r3
	STRA,r0 SPRITE1,r3
	LODA,r0 SENIL2,r3
	STRA,r0 SPRITE2,r3
	LODA,r0 SENIL3,r3
	STRA,r0 SPRITE3,r3
	COMI,r3 9
	BCTR,lt SENILOOP
	LODI,r0 $60 ;get the sprites off screen.
	STRA,r0 SPDUP0AY
	STRA,r0 SPDUP1AY
	STRA,r0 SPDUP2AY
	STRA,r0 SPDUP3AY

	BSTA,un MUSIC

	LODA,r0 MUSBPTR
	COMI,r0 $10
	BCFR,eq DECIDENEXT
	LODA,r1 QUAK
	COMI,r1 9
	BCTR,eq BRIDGEINI
	ADDI,r1 1
	STRA,r1 QUAK
DECIDENEXT:

    BCTA,un WAIT_VRLE2

;##############################end C64 load screen#############################

BRIDGEINI:
    
    LODI,r0 1
    STRA,r0 MUSBAR ;get the music up and running (I programmed it that way)
    LODI,r0 10 ;tweak to get the music in sync with the drums. Emulator says 10 is the right value. Should be 0 though (or 1, since MUSWAIT decreases before checking)
    STRA,r0 MUSWAIT ;for some reason, there's some random decrementing value in here.
    
    LODI,r0 $E0
    STRA,r0 SPDUP0AX
    STRA,r0 SPDUP1AX
    STRA,r0 SPDUP2AX
	LODI,r0 $7F
    STRA,r0 SPDUP3AX
    LODI,r0 %00001001
    STRA,r0 COLOR12
    STRA,r0 COLOR34
	LODI,r0 $1F
	STRA,r0 SPRITE0AX
	LODI,r0 $3F
	STRA,r0 SPRITE1AX
	LODI,r0 $5F
	STRA,r0 SPRITE2AX
	LODI,r0 $6E ;64
	STRA,r0 SPRITE3AX
	
	LODI,r0 $15
	STRA,r0 SPDUP3AY

	LODI,r3 $ff
    LODI,r0 0
CLRSCR3:
    STRA,r0 $1F80,r3+
    COMI,r3 $29 ;-AD
    BCTR,lt CLRSCR3
	STRA,r0 QUAK
	LODI,r0 $FF
	STRA,r0 $1FA8
	STRA,r0 $1FA9
	STRA,r0 $1FAA
	STRA,r0 $1FAB
	
	LODI,r0 $97
	STRA,r0 P1S1
	LODI,r2 $18
	STRA,r2 P1S2
	LODI,r0 $FF
	STRA,r0 $1F80,r2
	STRA,r0 $1F81,r2
	STRA,r0 $1F8C,r2
	STRA,r0 $1F8D,r2
	LODI,r0 %00110000
	STRA,r0 $1F83,r2
	STRA,r0 $1F8B,r2


BRIDGE: ;SENIL PRESENTS
    LODA,r0 SPR_COLL
    RRL,r0
    BCFR,lt BRIDGE
    BSTA,un MUSIC

    LODI,r0 %01101000
    STRA,r0 BGCOLOR

	LODI,r0 $7F
    STRA,r0 SPDUP3AX
	LODI,r0 %01101010
	STRA,r0 SIZES
	

	;use MUSBEAT to shift the SENIL Logo up by 20 pixels every beat
	;until it is at the top.
	;There are 6 steps: 1F98, 94, 90, 8C, 88, 84; at 80 the star is offscreen and I don't even know about 84. The separation between the star and the logo is not arbitrary... shift it and there be dragons.
	LODA,r1 QUAK
	BCTA,gt NOSHIFTANI
	;20 pixels per background line pair.
	LODA,r0 MUSBEAT
	BCFA,z NOSHIFTANI ;phew first time he gets here, MUSBEAT isn't zero so the original position will stay for a beat.
	LODA,r2 P1S2 ;shift bars around SENIL logo
	LODI,r0 $0
	STRA,r0 $1F80,r2
	STRA,r0 $1F81,r2
	STRA,r0 $1F83,r2
	STRA,r0 $1F8B,r2
	STRA,r0 $1F8C,r2
	STRA,r0 $1F8D,r2
	SUBI,r2 4
	LODI,r0 $FF
	STRA,r0 $1F80,r2
	STRA,r0 $1F81,r2
	STRA,r0 $1F8C,r2
	STRA,r0 $1F8D,r2
	LODI,r0 %00110000
	STRA,r0 $1F83,r2
	STRA,r0 $1F8B,r2
	COMI,r2 4
	BCTR,eq QUIEKSTAR ;me and my jump marks
	STRA,r2 P1S2
QUIEKSTAR:
	LODA,r2 P1S1 ;shift SENIL logo
	SUBI,r2 20
	COMI,r2 40
	BCTR,lt STOPSHIFTANI
	STRA,r2 P1S1
	BCTR,un NOSHIFTANI
STOPSHIFTANI:
	LODI,r1 1
	STRA,r1 QUAK
NOSHIFTANI:

	LODA,r2 P1S1 ;LODI $2A ;$97
	STRA,r2 SPRITE0AY
	STRA,r2 SPRITE1AY
	STRA,r2 SPRITE2AY
	SUBI,r2 $2A
	STRA,r2 SPRITE3AY
	
	COMI,r1 1
	BCTR,lt NOPRESENT
	LODA,r1 MUSBPTR
	ANDI,r1 $0F
	BCFR,z NOPRESENT
	LODI,r3 $FF
PRESLOOP:
	LODA,r0 BACKVERT1,r3+
	STRA,r0 $1F94,r3
	COMI,r3 10
	BCTR,lt PRESLOOP
	LODI,r0 9
	STRA,r0 $1FAA
	STRA,r0 $1FAB
	LODI,r0 2
	STRA,r0 QUAK

NOPRESENT:

	LODI,r3 $FF
STARLOOP2:
	LODA,r0 STAR,r3+
	STRA,r0 SPRITE3,r3
	COMI,r3 9
	BCTR,lt STARLOOP2
	LODA,r0 $1FCA
WAIT_SPRCOMP7:
	LODA,r0 $1FCA
	TMI,r0 $01
	BCFR,eq WAIT_SPRCOMP7
	LODI,r0 %10101010
	STRA,r0 SIZES

	LODI,r3 $FF
SENILOOP2: ;draw logo AGAIN
	LODA,r0 SENIL0,r3+
	STRA,r0 SPRITE0,r3
	LODA,r0 SENIL1,r3
	STRA,r0 SPRITE1,r3
	LODA,r0 SENIL2,r3
	STRA,r0 SPRITE2,r3
	LODA,r0 SENIL3,r3
	STRA,r0 SPRITE3,r3
	COMI,r3 9
	BCTR,lt SENILOOP2
	LODI,r0 $60 ;get the sprites off screen.
	STRA,r0 SPDUP0AY
	STRA,r0 SPDUP1AY
	STRA,r0 SPDUP2AY
	LODA,r0 $1FCA
WAIT_SPRCOMP8:
	LODA,r0 $1FCA
	TMI,r0 $01
	BCFR,eq WAIT_SPRCOMP8
	LODI,r0 $E0
	STRA,r0 SPDUP3AX
	LODA,r0 QUAK
	COMI,r0 2
	BCTA,lt BRIDGE
	LODI,r0 60
NOPMII:
	NOP
	BDRR,r0 NOPMII
	LODI,r0 %00111000
    STRA,r0 BGCOLOR
	LODI,r3 $FF
BUNTMII: ;necessary? No. Cool? YES!
	LODA,r0 BUNDISCH,r3+
	ANDI,r0 7
	IORI,r0 %01011000
	;NOTE that the screen display will not change geometrically if you remove one of these ANDI/IORI lines
	;which shows that the PVI will HALT the CPU on access.
	STRA,r0 BGCOLOR
	COMI,r3 32
	BCTR,lt BUNTMII
	LODI,r3 32
BUNTMII2:
	LODA,r0 BUNDISCH,r3-
	ANDI,r0 7
	IORI,r0 %00101000
	STRA,r0 BGCOLOR
	COMI,r3 0
	BCTR,gt BUNTMII2
	
	LODA,r0 MUSBAR
	COMI,r0 17
	BCTR,eq BRIDGE2INI
    
    BCTA,un BRIDGE

BRIDGE2INI:
	LODI,r3 $ff
    LODI,r0 0
    STRA,r0 FRAMECOUNT
    STRA,r3 COLOR12
CLRSCR4:
    STRA,r0 $1F80,r3+
    COMI,r3 $29 ;-AD
    BCTR,lt CLRSCR4
	STRA,r0 QUAK
	LODI,r0 9
	STRA,r0 $1FA8
	STRA,r0 $1FA9
	STRA,r0 $1FAA
	LODI,r0 $3F
	STRA,r0 $1FAB
	STRA,r0 $1FAC
	
	
	LODI,r0 $37
	STRA,r0 SCORELT
	LODI,r0 $E0
	STRA,r0 SPDUP3AX
	;STRA,r0 SPRITE0AX
	;STRA,r0 SPRITE1AX
	STRA,r0 SPRITE2AX
	STRA,r0 SPRITE3AX
	LODI,r0 $E8
	STRA,r0 SPRITE0AY
	STRA,r0 SPRITE1AY
	LODI,r0 10
	STRA,r0 SPRITE0AX
	LODI,r0 $A0
	STRA,r0 SPRITE1AX
	LODI,r0 %01010101
	STRA,r0 SIZES
	LODI,r3 $FF
B2RAM:
	LODA,r0 RAM,r3+
	STRA,r0 SPRITE0,r3
	STRA,r0 SPRITE1,r3
	COMI,r3 9
	BCTR,lt B2RAM


BRIDGE2: ;37 bytes of RAM
    LODA,r0 SPR_COLL
    RRL,r0
    BCFR,lt BRIDGE2
    BSTA,un MUSIC
    

    LODA,r0 QUAK
    BCTA,gt NUFFIN
    LODA,r1 MUSBIDX
    COMI,r1 $10 ;sync with music
    BCTR,lt NUFFIN
    LODI,r3 $FF
BYTESOF:
	LODA,r0 BACKVERT2,r3+
	STRA,r0 $1F84,r3
	COMI,r3 20
	BCTR,lt BYTESOF
    COMI,r1 30 ;sync with music
    BCTR,lt NUFFIN
SPRAM:
	LODA,r0 BACKVERT2,r3+
	STRA,r0 $1F86,r3
	COMI,r3 29
	BCTR,lt SPRAM
	LODI,r0 0
	STRA,r0 COLOR12
	LODI,r0 1
	STRA,r0 QUAK
	;NOW INIT SPRITES OFFSCREEN FOR MORE AWESOME COPPER BAR EFFECTS.
NUFFIN:
	COMI,r0 1
	BCFR,eq NEXTANI
	LODA,r1 SPRITE0AY
	SUBI,r1 1
	COMI,r1 $78
	BCTR,lt NEXTANI
	STRA,r1 SPRITE0AY
	STRA,r1 SPRITE1AY
NEXTANI:
	LODA,r0 QUAK
	COMI,r0 1
	BCTA,lt BRIDGE2
	;Sprite animation here - 
	;with QUAK==1 just some colorful vertical areas that move up and down the screen
	;how about 4 sprites, all starting at the very bottom of the screen, two moving up, two moving down, one each moving 2 pixels per frame.
	;with QUAK==2 HOW ABOUT 16*20 pixel animated turning BIOHAZARD symbol? (prerendered, ofcoz)
	;OK biohazard looks like crap at 16*20 pixels. The Revision logo looks rather horrid even at 32*40 pixels and that takes like 160 bytes!
	;how about let's take the star and 3 other tiny sprites (size 00) and just have tons of independant sprites, like sprites up the ass, like literally dozens
	;use sin_tab2, but subtract 1 pixel per frame each so they will slowly move left up the screen.
	;QUAK==2 if MUSBAR==19, then run until it's 22 or 35 (end of bassy part)

	LODI,r2 %00101111 ;background
	LODI,r1 %00101000

	LODA,r0 QUAK
	COMI,r0 2
	BCFR,eq STONKS
	LODA,r3 FRAMECOUNT
	ADDI,r3 1
	ANDI,r3 $3F
	STRA,r3 FRAMECOUNT
	RRR,r3
	ANDI,r3 $3F
	LODA,r0 SIN_TAB3,r3
	ADDI,r0 $78
	STRA,r0 SPRITE0AY
	STRA,r0 SPRITE1AY
	TMI,r3 %00010000
	BCTR,eq STONKS
	
	LODI,r2 $FF
	LODI,r1 0 ;foreground
STONKS:

	LODA,r0 BGCOLLIDE ;read to clear flags
WAIT_SPRCOMP9:
	LODA,r0 BGCOLLIDE ;read to clear flags
	TMI,r0 $08 ;Sprite 0 complete
	BCFR,eq WAIT_SPRCOMP9

	LODI,r3 $FF
COPPER2:
	LODA,r0 BUNDISCH2,r3+
	ANDZ r2 ;switch if background generator uses same color as background, giving the copper bars that 3D effect that was all the rage in 1989
	IORZ r1
	STRA,r0 BGCOLOR
	COMI,r3 12
	BCTR,lt COPPER2
	LODI,r0 %00101000
	STRA,r0 BGCOLOR

	LODA,r0 MUSBAR
	COMI,r0 18
	BCFR,eq MWEITER
	LODI,r3 2
	STRA,r3 QUAK
MWEITER:
	COMI,r0 19 ;22 ;35 ;19-> Scrolltext of length 41 loops 2* and goes on for less than half-> we need ~100 length.
	BCTR,eq TECHINI

	BCTA,un BRIDGE2

TECHINI:
	LODI,r0 0
	STRA,r0 QUAK
	STRA,r0 P1S1
	STRA,r0 P1S2
	STRA,r0 P1S3
	STRA,r0 FRAMECOUNT
	LODI,r3 $FF
	STRA,r3 SCORELT
CLRSPR: ;clear sprites
	STRA,r0 SPRITE0,r3+
	STRA,r0 SPRITE1,r3
	STRA,r0 SPRITE2,r3
	STRA,r0 SPRITE3,r3
	COMI,r3 9
	BCTR,lt CLRSPR

	LODI,r3 $ff
    LODI,r0 0
CLRSCR5:
    STRA,r0 $1F80,r3+
    COMI,r3 $19 ;-AD (here, we leave the RAM on the screen, as it will be below the techtech scrolltext and will look impressing! Discovered that by accident)
    BCTR,lt CLRSCR5

	LODI,r0 %11111101
	STRA,r0 SIZES

	LODI,r0 $E0
	;STRA,r0 SPDUP0AX
	STRA,r0 SPDUP1AX
	STRA,r0 SPDUP2AX
	STRA,r0 SPDUP3AX
	LODI,r0 $40
	STRA,r0 SPDUP0AX

RUNTECH:
	LODA,r0 SPR_COLL	   ; Lade das Kollisionsregister (Bit 6 dort ist das VRLE-Flag)
	RRL,r0				 ; Bit 6 wird zu Bit 7 und kann nun getestet werden:
	BCFR,lt RUNTECH	  ; Wenn nicht negativ (Bit 7 nicht gesetzt), springe zurck.
	BSTA,un VRST
	BCTR,un RUNTECH


VRST:
;VBLANK, alles auf Anfang
	LODA,r2 MUSBAR
	COMI,r2 69
	BCTR,eq SHUTUP
	BSTA,un MUSIC
	BCTR,un GOON
SHUTUP: ;GOTO END (Sad Mac)
	LODI,r2 4
	STRA,r2 NOISE
	LODI,r2 0
	STRA,r2 PITCH
	BCTA,un GSADMAC
GOON:

	LODA,r2 TEXTPOINTER ;Biete dem Bildschirm etwas Abwechslung
	IORI,r2 8
	ANDI,r2 $0F
	STRA,r2 BGCOLOR
	CPSL $08 ;aha daran lags dass der immer 2 abgezogen hat.
	LODA,r0 FRAMECOUNT
	SUBI,r0 $01
	BCFR,n SQUAUNCH
	LODI,r0 MAXFCOUNT-1
SQUAUNCH:
	STRA,r0 FRAMECOUNT
	PPSL $08
	;STRA,r0 SCORELT
	LODI,r0 $00
	STRA,r0 QUAK
	;STRA,r0 NOISE
	LODI,r2 $20				; Y-Position
	LODI,r3 $ff			; autoincrement erhht VOR der Adressberechnung, daher $ff als Startwert
	;Farbe setzen - die Farben sind mir erst mal wurscht
	;STRA,r3 SPDUP0AX
	STRA,r3 SPRITE1AX
	LODI,r0 %00011000
	STRA,r0 $1fc1
	LODI,r0 %00000000
	STRA,r0 $1fc2
	;ich glaube, das hier ist fr die Herzchengre. Neue Koordinaten...
	LODA,r1 FCOUNTDIV8
	ANDI,r1 3
	STRA,r1 SIZES
	;LODA,r1 FCOUNTDIV8
	;ANDI,r1 3
	BCFR,z ISITONE
	LODI,r2 $54
	STRA,r2 SPRITE0AX
	LODI,r2 $30
	STRA,r2 SPRITE0AY
	LODI,r2 $A0
	STRA,r2 SPDUP0AY
	BCTA,un X_OUT
ISITONE:
	COMI,r1 1
	BCFR,eq ISITTWO
	LODI,r2 $50
	STRA,r2 SPRITE0AX
	LODI,r2 $28
	STRA,r2 SPRITE0AY
	LODI,r2 $9E
	STRA,r2 SPDUP0AY
	BCTR,un X_OUT
ISITTWO:
	COMI,r1 2
	BCFR,eq ISITTHREE
	LODI,r2 $48
	STRA,r2 SPRITE0AX
	LODI,r2 $20
	STRA,r2 SPRITE0AY
	LODI,r2 $92
	STRA,r2 SPDUP0AY
	BCTR,un X_OUT
ISITTHREE: ;jetzt kanns nix anderes sein
	LODI,r2 $38
	STRA,r2 SPRITE0AX
	LODI,r2 $10
	STRA,r2 SPRITE0AY
	LODI,r2 $7A
	STRA,r2 SPDUP0AY
X_OUT: ;yes this is an Amiga video game reference. 
;The load times are worse than C64 but the game does look and play like any other
;late 80's arcade shooter game, demonstrating the superiour graphics capabilities of the A500
	;LODI,r1 $00
	LODA,r1 FRAMECOUNT
	;RRL,r1 ;TEXT SPEEDUP PART 1 - can't have that - the zooming heart will go double speed too
	ANDI,r1 7
	ADDI,r1 16 ;NOTE: Compensate for negative wobble - sprite disappears when negative. NOTE2: If we reduce the wobble, we need to reduce this value as well.
	STRA,r1 SPDUP1AX
	;SUBI,r1 9
	ADDI,r1 $3F
	STRA,r1 SPRITE2AX
	ADDI,r1 $40
	STRA,r1 SPRITE3AX

	;BOUNCE
	LODI,r0 $67
	LODA,r1 MUSBEAT
	;ANDI,r1 31 ;FCOUNTDIV8
	ADDA,r0 SIN_TAB2,r1
	STRA,r0 SPRITE2AY
	STRA,r0 SPRITE3AY
	LODI,r0 $50
	ADDA,r0 SIN_TAB2,r1
	STRA,r0 SPRITE1AY
	LODI,r0 12
	STRA,r0 SPDUP1AY
	
	CPSL 8
	LODI,r3 $FF
	LODI,r2 $FF
	LODA,r0 FRAMECOUNT
	ANDI,r0 7
	comi,r0 3
	bctr,lt LHEART
	ADDI,r3 10 ;sprite data +1 sprite
	comi,r0 6
	bctr,lt LHEART
	ADDI,r3 10 ;sprite data +2 sprites
LHEART:
	LODA,r0 HEART_1,r3+
	STRA,r0 SPRITE0,r2+
	COMI,r2 9
	BCTR,lt LHEART

	PPSU %00100000 ;disable interrupts
	LODA,r1 TEXTPOINTER ;Biete dem Bildschirm etwas Abwechslung
	IORI,r1 8
	ANDI,r1 $0F
	STRA,r1 BGCOLOR
	LODA,r0 BGCOLLIDE ;read to clear flags
WAIT_SPRCOMP1: ;OK here's the deal: Accessing the 2636 PVI will make the CPU go WAIT until the PVI is ready. So to get more performance out of the VC4000, stop accessing the PVI!
	STRA,r0 BGCOLOR
	LODA,r0 BGCOLLIDE
	STRA,r1 BGCOLOR
	TMI,r0 $04 ;Sprite 1 complete
	BCFR,eq WAIT_SPRCOMP1
	LODI,r0 $FC
	IORA,r0 FCOUNTDIV8
	STRA,r0 SIZES

	LODI,r2 $C0 		;get rid of sprite 1's duplicate. We need sprite 1 to be rendered earlier offscreen immediately before the real scrolltext starts
	STRA,r2 SPDUP1AY ;so we can do some evil Tech-Tech! Muahahahahaaa! NARF! POIT!
	LODA,r3 FRAMECOUNT
	LODA,r0 SIN_TAB3,r3
	ADDI,r0 $30
	STRA,r0 SPDUP0AX
	lodi,r1 $FF
	STRA,r1 BGCOLOR

	;OK sprite 1 is complete, Time for some Tech-Tech - btw. the flickering - do I need to fix this? I remember that the flickering problem appeared on Canabalt and it took me quite a while to fix it.
	;I think I had to load the graphics somewhere else
	LODA,r1 $1F56 ;semi-random colors
	ANDI,r1 $70
	LODI,r0 %00001001
	IORZ r1
	STRA,r0 BGCOLOR
	PPSU %00100000 ;disable interrupts
	CPSL $08
	lodi,r0 $A0
	stra,r0 SPDUP1AY
	STRA,r0 SPDUP2AY
	STRA,r0 SPDUP3AY
	LODI,r3 $FF
	ADDA,r3 FRAMECOUNT ;NOTE that Framecount now only counts to 40.;that is 32 now.
TECHTECH:
	LODA,r0 SIN_TAB,r3+
	ADDA,r0 SPDUP1AX
	STRA,r0 SPDUP1AX ;and because sprites are R/W, adding and storing makes this routine require relative movements instead of absolute.
	ADDI,r0 $3F
	STRA,r0 SPRITE2AX
	ADDI,r0 $3F
	STRA,r0 SPRITE3AX
	LODI,r0 MAXFCOUNT
	ADDA,r0 FRAMECOUNT
	;ADDI,r2 %00001001
	STRZ r2
	LODA,r0 BUNDISCH,r3
	STRA,r0 COLOR12 ;still looking good. And super colorful now. But of course almost half the table is lost now.
	STRA,r0 COLOR34 ;and if I put something sensible in r3 first, then it'll be even slower.
	LODZ r2
	COMZ r3
	BCFR,lt TECHTECH
	LODI,r0 $FF
	STRA,r0 BGCOLOR
	LODA,r0 FRAMECOUNT
	ADDI,r0 1
	PPSL $08
	LODI,r1 0
	STRA,r1 BGCOLOR
	LODI,r1 %11111110
	STRA,r1 SIZES
	STRZ r2
	LODA,r0 %00011011
	STRA,r0 COLOR12

	LODI,r3 $FF
NEWSPR0:
	LODA,r0 STAR,r3+
	STRA,r0 SPRITE0,r3
	COMI,r3 9
	BCTR,lt NEWSPR0

	LODZ r2
	ANDI,r0 %0000111 ;TEXT SPEEDUP PART 2 (for 1 pixel per frame outcomment RRL,r2 and use ANDI,r0 %00000111 here or 00000011 for 2 frames per pixel)
	COMI,r0 1
	BCTA,eq ZERO
	;LODA,r0 SPDUP0AX
	;ADDA,r0 SIN_TAB,r3
	;STRA,r0 SPDUP0AX

	RETC,un ;REFE,z gibts net

ZERO:
	PPSL $08
	;if FCOUNTDIV8==0 lade nchste 10 Byte aus den Scrolltextdaten in Speicher F50-F5A
	LODA,r0 FCOUNTDIV8
	ANDI,r0 $07
	BCFA,z DONTLOADNEXT
	LODA,r3 TEXTPOINTER
	ADDI,r3 1
	COMI,r3 TEXTLEN-1
	BCTR,lt NORESETPOINT
	LODI,r3 0
NORESETPOINT:
	STRA,r3 TEXTPOINTER
	LODA,r0 TEXT0-1,r3
	STRA,r0 $1F50
	LODA,r0 TEXT1-1,r3
	STRA,r0 $1F51
	LODA,r0 TEXT2-1,r3
	STRA,r0 $1F52
	LODA,r0 TEXT3-1,r3
	STRA,r0 $1F53
	LODA,r0 TEXT4-1,r3
	STRA,r0 $1F54
	LODA,r0 TEXT5-1,r3
	STRA,r0 $1F55
	LODA,r0 TEXT6-1,r3
	STRA,r0 $1F56
	LODA,r0 TEXT7-1,r3
	STRA,r0 $1F57
	LODA,r0 TEXT8-1,r3
	STRA,r0 $1F58
	LODA,r0 TEXT9-1,r3
	STRA,r0 $1F59

DONTLOADNEXT:
	LODA,r0 FCOUNTDIV8
	ADDI,r0 1
	STRA,r0 FCOUNTDIV8
	LODI,r3 $FF
SCROLLPIX: ;ICH GLAUBS NICHT: Ich habe LESEZUGRIFF auf Spritedaten! Also HABE ich einen Framebuffer!
	;stattdesssen LODA,r1 $1F50,r3+ (und dann die Zeile drunter das + weg!) - funktioniert net!
	LODA,r0 $1F50,r3+
	RRL,r0 ;tu nen Zufallspixel ins Carry.
	
	STRA,r0 $1F50,r3
	LODA,r0 SPRITE3,r3
	RRL,r0
	
	;dafr sorgen, dass MSB nach Carry geschoben wird und im nchsten Zyklus LSB von Carry geholt wird
	;Bei Sprite 1 vom Zufallsgenerator statt vom Carry, versteht sich. WC muss gesetzt sein.
	
	STRA,r0 SPRITE3,r3
	LODA,r0 SPRITE2,r3
	RRL,r0
	STRA,r0 SPRITE2,r3
	LODA,r0 SPRITE1,r3
	RRL,r0
	STRA,r0 SPRITE1,r3

	;LODA,r0 $1F80,r3 ;Ich hab sogar auf den schei LABYRINTHGENERATOR Lesezugriff.
	;RRR,r0
	;STRA,r0 $1F80,r3

	;LODI,r0 %00001010 ;this is unintentionally looking pretty cool - so I keep it.
	LODZ r3
	IORI,r0 8
	STRA,r0 BGCOLOR
	NOP
	NOP
	NOP
	NOP
	LODI,r0 0
	STRA,r0 BGCOLOR
	COMI,r3 $09
	BCTR,lt SCROLLPIX
	CPSL $08
	retc, un ;das gehrt zu ISR!

GSADMAC:
    ;let's see if we have to kill any sprites
    LODI,r0 $E0
    STRA,r0 SPDUP0AX
    STRA,r0 SPRITE2AX
    STRA,r0 SPRITE3AX
    
    LODI,r0 $5A
    STRA,r0 SPRITE0AX
    STRA,r0 SPRITE0AY ;lol 3 Bytes gespart weil X und Y Koordinate identisch

    LODI,r0 %00001111
    STRA,r0 BGCOLOR
	lodi,r0 %01010101
	stra,r0 SIZES

	LODI,r3 $FF
MACOS:
    LODA,r0 SADMACSP,r3+
	STRA,r0 SPRITE0,r3
	COMI,r3 9
	BCTR,lt MACOS
    
    LODI,r3 $FF
    LODI,r0 9
VEEERT:
    STRA,r0 $1FA9,r3+
	COMI,r3 5
	BCTR,lt VEEERT
    LODI,r3 $FF
    STRA,r3 COLOR12
MACX:
	LODA,r0 SADMACBG,r3+
	STRA,r0 $1F8C,r3
	COMI,r3 25
	BCTR,lt MACX
	
	HALT


	;After PRESENTS, wait until MUSBAR is 17, then go to the next screen
	;which will require MUSBIDX for animation (showing one part of the image after the others
	
	;the part after that will not touch the background generation, but will put a layer of sprites on there.
	
	;and after the first bassy part, switch to SCRL2.ASM. Muahahaha
	;(but only if I have time for the layer of sprites, otherwise right before the interesting part)
BUNDISCH: ;reused in the TECHTECH scroller - actually I copied it from there...
	DB 0
	DB 0
	DB %00001001
	DB 0
	DB %00001001
	DB %00001001
	DB 0
	DB %00001001
	DB %00001001
	DB %00011011
	DB %00001001
	DB %00011011
	DB %00011011
	DB %00111111
	DB %00011011
	DB %00111111
	DB %00111111
	DB %00111111
	DB %00110110
	DB %00111111
	DB %00110110
	DB %00110110
	DB %00110110
	DB %00100100
	DB %00110110
	DB %00100100
	DB %00100100
	DB %00100100
	DB 0
	DB %00100100
	DB 0
	DB 0
;Double that again (only used on scrolltext due to lack of rastertime)
	DB 0
	DB 0
	DB %00001001
	DB 0
	DB %00001001
	DB %00001001
	DB 0
	DB %00001001
	DB %00001001
	DB %00011011
	DB %00001001
	DB %00011011
	DB %00011011
	DB %00111111
	DB %00011011
	DB %00111111
	DB %00111111
	DB %00111111
	DB %00110110
	DB %00111111
	DB %00110110
	DB %00110110
	DB %00110110
	DB %00100100
	DB %00110110
	DB %00100100
	DB %00100100
	DB %00100100
	DB 0
	DB %00100100
	DB 0
	DB 0

BUNDISCH2:
;	DB %01001100
;	DB %01011101
;	DB %00011001
;	DB %01011101
;	DB %01101110
;	DB %01111111
;	DB %01101110
;	DB %01011101
;	DB %00011001
;	DB %01011101
;	DB %01001100 ;eugh that's ugly
	DB %00101010
	DB %01101110
	DB %00101010
	DB %01101110
	DB %01101110
	DB %01111111
	DB %01111111
	DB %01101110
	DB %01101110
	DB %00101010
	DB %01101110
	DB %00101010 ;kinda better, but sooo much green on the screen... the 3D effect isn't as lost as I feared though.

LOAD0: ;BTW yay double definition of LOAD0 and 1. The other one is LODI... bcoz of too slow CPU...
    DB %00000000
	DB %10000100
    DB %10001110
    DB %10001010
    DB %10001010
    DB %10001010
    DB %10001010
    DB %10001010
    DB %11101110
    DB %11100100
LOAD1:
    DB %00000000
	DB %01001100
    DB %11101110
    DB %10101010
    DB %10101010
    DB %11101010
    DB %11101010
    DB %10101010
    DB %10101110
    DB %10101100

LOAD2:
    DB %00000000
    DB %10100010
	DB %10101010
    DB %00010100
    DB %00001000
    DB %00011100
    DB %00011100
    DB %00001000
    DB %00010100
    DB %00001000
LOAD3:
    DB %00000000
	DB %10000010
    DB %10000111
    DB %00000101
    DB %00000111
    DB %00000010
    DB %00110101
    DB %00110101
    DB %01100111
    DB %01100010



SRCH0:
    DB %00000000
	DB %01101100
    DB %11101101
    DB %10001001
    DB %11001001
    DB %11101101
    DB %01101001
    DB %00101001
    DB %11101101
    DB %11001101

SRCH1:
    DB %00000000
	DB %10011000
    DB %11011101
    DB %01010101
    DB %01010101
    DB %11011001
    DB %11011101
    DB %01010101
    DB %01010101
    DB %01010100

SRCH2:
    DB %00000000
	DB %10101010
    DB %10101010
    DB %00101010
    DB %00101010
    DB %00111010
    DB %00111010
    DB %00101010
    DB %10101010
    DB %10101010

SRCH3:
    DB %00000000
	DB %10010011
    DB %10010111
    DB %11010100
    DB %11010100
    DB %10110101
    DB %10110101
    DB %10010101
    DB %10010111
    DB %10010011

RUN0:
	;DB 0
	DB %11001010
	DB %11101010
	DB %10101010
	DB %10101010
	DB %11001010
	DB %11101010
	DB %10101010
	DB %10101110
	DB %10100100
RUN1:
	;DB 0
	DB %10010000
	DB %10010000
	DB %11010010
	DB %11010010
	DB %10110000
	DB %10110000
	DB %10010010
	DB %10010010
	DB %10010000
SENIL0:
	DB %00000111
	DB %00001000
	DB %00010000
	DB %00010000
	DB %00001000
	DB %00000100
	DB %00000010
	DB %00000010
	DB %00000100
	DB %11111000
SENIL1:
	DB %11111100
	DB %01000110
	DB %01000110
	DB %01000101
	DB %01000101
	DB %01110100
	DB %01000100
	DB %01000100
	DB %01000100
	DB %01111100
SENIL2:
	DB %00101111
	DB %00101111
	DB %00101111
	DB %00101111
	DB %00101111
	DB %10101111
	DB %10101111
	DB %01101111
	DB %01101111
	DB %00101111
SENIL3:
	DB %01000000
	DB %01000000
	DB %01000000
	DB %01000000
	DB %01000000
	DB %01000000
	DB %01000000
	DB %01000000
	DB %01000000
	DB %01111111
STAR:
	DB %00001000
	DB %00001000
	DB %00011100
	DB %01111111
	DB %00111110
	DB %00011100
	DB %00011100
	DB %00111110
	DB %00110110
	DB %01100011


;background generator text
BACKVERT1: ;PRESENTS (probably 1F90)
	DB %10101010, %10101110
	DB %11111010, %10110110
	DB %10101010, %10000010
	DB %10111001, %10110101
	DB %00001010, %10000010
;HORI will be all $09s. (1FAA and maybe 1FAB)

BACKVERT2: ;bytes of RAM (37 being shown by the SCORERT - uhh SCORERT will be obscuring part of the "bytes".
	DB %00000000, %10100000
	DB %00100010, %11100000
	DB %00100010, %10100000
	DB %00111110, %10010000
	DB %00101010, %10100000
	DB %00000100, %00000000
	DB %00001010, %00000000
	DB %00000010, %00000000
	DB %00001010, %00000000
	DB %00001110, %00000000
	DB %00001000, %00000000
;	DB 0,0
	DB %00110001, %00100010
	DB %00101010, %10110110
	DB %00110011, %10101010
	DB %00101010, %10100010

BACKHORI2:
	;gotta be $09 for the normal part and $3F for the fat part.
	;FA8,FA9,FAA=$09, FAB=$3F
	DB $09,$09,$09,$3F

SADMACBG:
	DB %00000001, %11000000
	DB %00000001, %00100000
	DB 0,0
	DB %00000001, %00100000
	DB %00000001, %11000000
	DB %00000001, %00100000
	DB %00000001, %11000000
	DB 0,0
	DB %01100010, %00101010
	DB %00101110, %00101111
	DB %00001010, %00100000
	DB %00101110, %00101111
	DB %00000010, %00100010
	
SADMACSP: ;can this be made to look exactly like the original? Well yes, but we don't have the ROM space.
	DB %10100101
	DB %01000010
	DB %10100101
	DB %00000000
	DB %00100100
	DB %00011000
	DB %00000000
	DB %00111000
	DB %01000110
	DB %00000001


;DAMN IT - I can only have multiples of 8 for the length
SIN_TAB: ;I want to put a Tech-Tech on the scrolltext. Why? Because the hardware can! Looks awesome, too! I want a rainbow, but the machine needs to run half as slow.
;so I came up with this on the spot, no calculations, just some trying to get it look cool.
DB 0,1,  0,1,  1,  2,  1,  2,  2,  1,  2,  1,  1,  0,1,0
DB 0,$FF,0,$FF,$FF,$FE,$FF,$FE,$FE,$FF,$FE,$FF,$FF,0,1,0
;double that - no rastertime for wrapping
DB 0,1,  0,1,  1,  2,  1,  2,  2,  1,  2,  1,  1,  0,1,0
DB 0,$FF,0,$FF,$FF,$FE,$FF,$FE,$FE,$FF,$FE,$FF,$FF,0,1,0


SIN_TAB2:
;this was calculated. But for some odd reason, it added the numbers every scanline instead of loading their absolute values
;maybe a 90 phase shift looks better?
;DB 8,6,5,4,3,2,1,1,0,0,0,0,1,1,2,3,4,5,6,7 ;last one is 8 but probably looks better with 7
;DB 8,9,11,12,13,14,15,15,16,16,16,16,16,15,14,13,12,12,11,10,9

DB 24,20,16,12,9,6,4,2,1,0,1,2,4,6,9,13,16,21

SIN_TAB3:
DB 0,2,5,9,13,19,25,29,34,39,44,49,54,58,61,63,64,63,61,58,54,49,44,38,32,25,19,14,9,5,2,0
;DB 40,48,55,62,68,73,77,79,80,79,76,73,68,62,55,47,40,32,24,18,12,7,3,1,0,1,3,7,12,18,25,32

;note that if I changed it every scanline, I would need 80 entries and it probably wouldn't look any different.
; Grafikdaten... (Sprungmarkierungen sind Legacy von Hallo Welt und ich war zu faul, sie umzubenennen)
HEART_1:
	DB %00110110
	DB %01110111
	DB %01111111
	DB %01111111
	DB %00111110
	DB %00111110
	DB %00011100
	DB %00011100
	DB %00001000
	DB %00001000

HEART_2:
	DB %00000000
	DB %00010100
	DB %00111110
	DB %01111111
	DB %00111110
	DB %00011100
	DB %00011100
	DB %00001000
	DB %00001000
	DB %00000000

HEART_3:
	DB %00000000
	DB %00000000
	DB %00010100
	DB %00111110
	DB %00011100
	DB %00011100
	DB %00001000
	DB %00001000
	DB %00000000
	DB %00000000


RAM:
	DB %01010101
	DB %01010101
	DB %01111111
	DB %01111111
	DB %00111111
	DB %00111111
	DB %01111111
	DB %01111111
	DB %01010101
	DB %01010101



TEXT9:
    DB %00100000
    DB %00000000
    DB %11100010
    DB %00000111
    DB %00011101
    DB %00101001
    DB %11001000
    DB %00011010
    DB %10000001
    DB %00110000
    DB %00001101
    DB %01000100
    DB %11100001
    DB %00001000
    DB %00011000
    DB %00011000
    DB %01101111
    DB %11000011
    DB %01100000
    DB %11000100
    DB %00111001
    DB %11000010
    DB %00110000
    DB %01100011
    DB %00010001
    DB %10000000
    DB %11100011
    DB %10010010
    DB %01110001
    DB %11001001
    DB %00001110
    DB %01000111
    DB %00011100
    DB %01101000
    DB %00111001
    DB %00010001
    DB %11001001
    DB %00111000
    DB %11100100
    DB %00011100
    DB %10001011
    DB %00001000
    DB %11100100
    DB %10100001
    DB %00000001
    DB %00010001
    DB %00001000
    DB %01000100
    DB %11100011
    DB %10001110
    DB %00111010
    DB %00111000
    DB %11100000
    DB %00000001
    DB %00000000
    DB %00000011
    DB %10001001
    DB %00100000
    DB %01110000
    DB %00010000
    DB %10000001
    DB %10000100
    DB %00001001
    DB %00100111
    DB %00100001
    DB %00011100
    DB %11000011
    DB %10001100
    DB %00010000
    DB %01001000
    DB %01001000
    DB %01110011
    DB %00001010
TEXT8:
    DB %00110000
    DB %01001111
    DB %00110000
    DB %00000101
    DB %10110101
    DB %00101011
    DB %01101011
    DB %00100100
    DB %10000010
    DB %10001000
    DB %00010001
    DB %01000101
    DB %10100001
    DB %00010100
    DB %00100100
    DB %00011000
    DB %01101000
    DB %11000011
    DB %01100001
    DB %00100100
    DB %01101011
    DB %01000101
    DB %01001000
    DB %11110111
    DB %10010011
    DB %11000001
    DB %10110110
    DB %11010010
    DB %11011011
    DB %01101000
    DB %10011011
    DB %01001101
    DB %10110110
    DB %11000100
    DB %01101101
    DB %00010011
    DB %01101001
    DB %01101101
    DB %10110010
    DB %00110110
    DB %01010000
    DB %10001001
    DB %10110100
    DB %10010001
    DB %00000001
    DB %00010001
    DB %00000100
    DB %01000101
    DB %10110110
    DB %11011011
    DB %01001010
    DB %01101101
    DB %10110000
    DB %00011010
    DB %10010011
    DB %11000001
    DB %00001001
    DB %00100000
    DB %11010001
    DB %11100000
    DB %10000001
    DB %01101100
    DB %00001001
    DB %10100100
    DB %00100101
    DB %00110010
    DB %11000000
    DB %11000100
    DB %00010000
    DB %01001011
    DB %10011000
    DB %10010001
    DB %00011010
TEXT7:
    DB %00010111
    DB %11011110
    DB %00111001
    DB %00000100
    DB %10100001
    DB %00101010
    DB %00101101
    DB %10100100
    DB %10000100
    DB %00000100
    DB %00100001
    DB %01001001
    DB %00000001
    DB %00100000
    DB %00000100
    DB %00011000
    DB %01101000
    DB %11000011
    DB %00000010
    DB %00010100
    DB %01000010
    DB %00001000
    DB %00001000
    DB %10010100
    DB %10010010
    DB %01000001
    DB %00010100
    DB %00010010
    DB %00011010
    DB %00101000
    DB %00010001
    DB %01001000
    DB %00000110
    DB %10000000
    DB %01000101
    DB %00010010
    DB %00001001
    DB %01000001
    DB %00000000
    DB %00100010
    DB %01010000
    DB %10001001
    DB %00010100
    DB %10000001
    DB %00000011
    DB %10111001
    DB %00000000
    DB %01001101
    DB %00000000
    DB %11010001
    DB %01001010
    DB %01000001
    DB %00000000
    DB %00110110
    DB %10010110
    DB %01000001
    DB %00001001
    DB %01100000
    DB %10001001
    DB %01100000
    DB %10000001
    DB %00101000
    DB %00001001
    DB %10100111
    DB %00100101
    DB %10100010
    DB %10100000
    DB %01100000
    DB %00010000
    DB %11010011
    DB %10001000
    DB %00110001
    DB %00110000
TEXT6:
    DB %00010101
    DB %10010010
    DB %00101001
    DB %10000100
    DB %10111101
    DB %00101010
    DB %00101000
    DB %10011100
    DB %10000100
    DB %00011100
    DB %00100001
    DB %01101001
    DB %11100001
    DB %00100000
    DB %00011000
    DB %00011000
    DB %00101000
    DB %01000001
    DB %01100010
    DB %00010100
    DB %01111011
    DB %11001000
    DB %00110000
    DB %10010100
    DB %10010010
    DB %01000001
    DB %00000111
    DB %11010010
    DB %01110010
    DB %00101000
    DB %00010000
    DB %01001111
    DB %10011100
    DB %10000000
    DB %01000101
    DB %00010011
    DB %11101001
    DB %01000001
    DB %11110000
    DB %00100010
    DB %00100001
    DB %11001001
    DB %00010100
    DB %10000001
    DB %11100010
    DB %10101001
    DB %11100000
    DB %01011001
    DB %11110011
    DB %10010001
    DB %01001010
    DB %01000001
    DB %11110000
    DB %00100010
    DB %10010010
    DB %01000001
    DB %00001101
    DB %11000000
    DB %10001001
    DB %00100000
    DB %10000001
    DB %00101000
    DB %00001001
    DB %10100101
    DB %10110100
    DB %10110010
    DB %10111000
    DB %11100000
    DB %00010000
    DB %11110011
    DB %10001000
    DB %01000001
    DB %00100010
TEXT5:
    DB %00010100
    DB %10011010
    DB %01000100
    DB %10000100
    DB %10100101
    DB %10101010
    DB %00101000
    DB %10000100
    DB %10000100
    DB %00100100
    DB %00100001
    DB %01010001
    DB %00100001
    DB %00100000
    DB %00100000
    DB %00011000
    DB %00101000
    DB %01000001
    DB %01100010
    DB %01110110
    DB %01001010
    DB %01001000
    DB %01000000
    DB %10110100
    DB %10010010
    DB %01000001
    DB %00000100
    DB %01010010
    DB %11000010
    DB %00101000
    DB %00010000
    DB %01001000
    DB %10110000
    DB %10000000
    DB %01000101
    DB %00010010
    DB %00101001
    DB %01000001
    DB %00010000
    DB %00100010
    DB %01110001
    DB %01001001
    DB %00010100
    DB %10000001
    DB %00110010
    DB %10101001
    DB %00110000
    DB %01111001
    DB %00010110
    DB %00010001
    DB %01001010
    DB %01000001
    DB %00010000
    DB %00100010
    DB %10110010
    DB %01000001
    DB %00001111
    DB %11000000
    DB %11001001
    DB %00100001
    DB %11100001
    DB %00101000
    DB %00011111
    DB %01000101
    DB %10111111
    DB %10011110
    DB %10001101
    DB %10110000
    DB %00010000
    DB %11100001
    DB %10111100
    DB %01100001
    DB %00100010
TEXT4:
    DB %00011011
    DB %10001110
    DB %11000100
    DB %11000100
    DB %10100101
    DB %11111011
    DB %01101101
    DB %10100100
    DB %11001110
    DB %00100100
    DB %00100000
    DB %01001001
    DB %00100000
    DB %01110000
    DB %00100100
    DB %00001011
    DB %11101111
    DB %11011111
    DB %01100010
    DB %01110101
    DB %01001010
    DB %01011100
    DB %01001000
    DB %10110100
    DB %10010010
    DB %01000001
    DB %00000110
    DB %11010010
    DB %11011011
    DB %01101000
    DB %00010000
    DB %01001101
    DB %10110110
    DB %10000000
    DB %01000101
    DB %00010011
    DB %01101001
    DB %01101101
    DB %10110000
    DB %00100010
    DB %01010001
    DB %01001001
    DB %10110100
    DB %10000001
    DB %00010010
    DB %10101001
    DB %00010000
    DB %01001101
    DB %10110110
    DB %11011011
    DB %01001010
    DB %01101101
    DB %10110000
    DB %00110010
    DB %11100011
    DB %11000001
    DB %00100000
    DB %01000000
    DB %01111011
    DB %00100000
    DB %10000001
    DB %11001100
    DB %00010000
    DB %00000111
    DB %00100011
    DB %00000000
    DB %00000011
    DB %00010000
    DB %00010000
    DB %10000000
    DB %00001000
    DB %10000001
    DB %01110010
TEXT3:
    DB %00111000
    DB %00000000
    DB %00000000
    DB %01000100
    DB %10011001
    DB %01010001
    DB %11001011
    DB %00011000
    DB %10100100
    DB %01100100
    DB %00100001
    DB %01000100
    DB %11000001
    DB %00100001
    DB %00011000
    DB %00001010
    DB %00100100
    DB %10010001
    DB %01100010
    DB %00000000
    DB %00110001
    DB %10001000
    DB %00110000
    DB %10000100
    DB %10010010
    DB %01000001
    DB %00000011
    DB %10011100
    DB %01110001
    DB %11000110
    DB %00010000
    DB %00110111
    DB %00011100
    DB %10000000
    DB %01000111
    DB %11111101
    DB %11001110
    DB %00111000
    DB %11100000
    DB %00100010
    DB %10001010
    DB %00100110
    DB %11100111
    DB %00000001
    DB %00010110
    DB %10101101
    DB %00010000
    DB %01000100
    DB %11100011
    DB %10001110
    DB %01001001
    DB %10111000
    DB %11100000
    DB %00011110
    DB %10000000
    DB %01000001
    DB %00100000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %10000000
    DB %00111000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000010
    DB %00010000
    DB %00010000
    DB %10000000
    DB %00001000
    DB %10000000
    DB %00100010
TEXT2:
    DB %01101100
    DB %00000000
    DB %00000000
    DB %01000100
    DB %10000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000100
    DB %00000000
    DB %00100001
    DB %01000000
    DB %00000001
    DB %00100001
    DB %10000000
    DB %00001010
    DB %00100100
    DB %10010001
    DB %01100010
    DB %00000000
    DB %00000000
    DB %00001000
    DB %00000000
    DB %10000100
    DB %10010010
    DB %01000001
    DB %00010000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00010001
    DB %00000000
    DB %00000001
    DB %11100000
    DB %01000101
    DB %00010000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00100010
    DB %00000010
    DB %00100000
    DB %00000000
    DB %00000001
    DB %00010100
    DB %01000101
    DB %00010000
    DB %01000100
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %01000001
    DB %00100000
    DB %00000000
    DB %00000000
    DB %00000001
    DB %00000000
    DB %00001000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00010000
    DB %00010000
    DB %10000000
    DB %00011000
    DB %10000001
    DB %00100010
TEXT1:
    DB %11000110
    DB %00000000
    DB %00000000
    DB %01000101
    DB %10000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000100
    DB %00000000
    DB %00100000
    DB %01000000
    DB %00000000
    DB %00100000
    DB %10000000
    DB %00001010
    DB %00100100
    DB %10010001
    DB %01100001
    DB %00000000
    DB %00000000
    DB %00001000
    DB %00000000
    DB %11110111
    DB %10111011
    DB %11000001
    DB %10110000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00011011
    DB %00000000
    DB %00000000
    DB %10000000
    DB %01101101
    DB %10011000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00110110
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000001
    DB %00110100
    DB %01000101
    DB %00110000
    DB %01001100
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %01000001
    DB %00100000
    DB %00000000
    DB %00000000
    DB %00000001
    DB %00000000
    DB %00001000
    DB %10000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00010000
    DB %10000000
    DB %00010000
    DB %00000000
    DB %00100010
TEXT0:
    DB %10000011
    DB %00000000
    DB %00000000
    DB %01000111
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000100
    DB %00000000
    DB %00100000
    DB %01000000
    DB %00000000
    DB %00100000
    DB %00000000
    DB %00001011
    DB %11100111
    DB %10011111
    DB %01100000
    DB %11110000
    DB %00000000
    DB %00001000
    DB %00000000
    DB %01100011
    DB %00111001
    DB %10000000
    DB %11100000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00001110
    DB %00000000
    DB %00000000
    DB %10000000
    DB %00111000
    DB %11001100
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00011100
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000001
    DB %11100100
    DB %01000101
    DB %11100000
    DB %01111000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %01000111
    DB %10000000
    DB %00000000
    DB %00000000
    DB %00000001
    DB %00000000
    DB %00001111
    DB %10000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %00000000
    DB %01111110
    DB %10000000
    DB %00000000
    DB %00000000
    DB %00000010
end