/*****************************************************************************\
** plasma test program for cc65.                                             **
**                                                                           **
** (w)2001 by groepaz/hitmen                                                 **
**                                                                           **
** Cleanup and porting by Ullrich von Bassewitz.                             **
**                                                                           **
\*****************************************************************************/



#include <stdlib.h>
#include <time.h>

#include <conio.h>
#include <cc65.h>
#include <stdio.h>
#include <string.h>
#include <cbm.h>
#include <dbg.h>


#if defined(__C64__) || defined(__CBM510__)
static unsigned long FreqTab [13] = {
#ifndef NTSC
    /* PAL */
    0x008B38, 0x009381, 0x009C45, 0x00A590, 0x00AF68, 0x00B9D6,
    0x00C4E4, 0x00D099, 0x00DCFF, 0x00EA24, 0x00F810, 0x0106D1, 0x008B38*2
#else
    /* NTSC */
    0x00861E, 0x008E19, 0x00968B, 0x009F7F, 0x00A8FA, 0x00B307,
    0x00BDAD, 0x00C8F4, 0x00D4E6, 0x00E18F, 0x00EEF9, 0x00FD2F, 0x00861E*2
#endif
};


signed char notes_aleluya[] = {
    8,5,5,3,8,8,8,0,10,10,13,10,
    10,8,8,0,8,5,5,3,5,8,8,0,
    10,10,8,0,5,3,1,0,8,0,5,8,
    10,13,0,0,0,8,0,5,1,5,3,0,
    8,0,5,8,10,13,0,10,8,1,5,3,
    1,0,0,0,0,0,0,0,0,0,0,0
};

typedef struct {
    unsigned char       DoneMask;       /* Set this if we're done */
    unsigned char       Trigger;        /* Trigger value */
    unsigned char       Ticks;          /* Ticks for this tone */
    unsigned            Freq;           /* Actual frequency value */
    unsigned*           Data;           /* Pointer to data */
    struct __sid_voice* Voice;          /* Pointer to sid registers */
} VoiceCtrl;

/* Control structs for all three voices */
static VoiceCtrl V1_aleluya = {
    0x01,  0x11, 0, 0, 0, &SID.v1
};




/* Screen dimensions */
//static unsigned char XSize, YSize;

/* Variable that contains the time of the next clock tick to play a note */



/* Number of ticks for each tone */
#define TICKS_PER_TONE  4

/* Done flag. Contains one bit for each voice. Will contain 0x07 if all
** voices have finished playing.
*/



/*
static void TimeSync (void)
/* Sync the time for the next tone 
{
    static unsigned char Clock;

    do {
        Clock = clock ();
    } while (Clock != NextClock);
    NextClock = Clock + TICKS_PER_TONE;
}

*/


//----------------------------- ALELUYA

#if defined(__C64__) || defined(__C128__)
#  define SCREEN1               0xE000
#  define SCREEN2               0xE400
#  define CHARSET               0xE800
#  define outb(addr,val)        (*(addr)) = (val)
#  define inb(addr)             (*(addr))
#elif defined(__CBM510__)
#  define SCREEN1               0xF000
#  define SCREEN2               0xF400
#  define CHARSET               0xE000
#  define outb(addr,val)        pokebsys ((unsigned)(addr), val)
#  define inb(addr)             peekbsys ((unsigned)(addr))
#elif defined(__PLUS4__)
#  define SCREEN1               0x6400
#  define SCREEN2               0x6C00
#  define CHARSET               0x7000
#  define outb(addr,val)        (*(addr)) = (val)
#  define inb(addr)             (*(addr))
#endif



/* Values for the VIC address register to switch between the two pages */
#if defined(__PLUS4__)
#define PAGE1                   ((SCREEN1 >> 8) & 0xF8)
#define PAGE2                   ((SCREEN2 >> 8) & 0xF8)
#define CHARADR                 ((CHARSET >> 8) & 0xFC)
#else
#define PAGE1                   ((SCREEN1 >> 6) & 0xF0) | ((CHARSET >> 10) & 0x0E)
#define PAGE2                   ((SCREEN2 >> 6) & 0xF0) | ((CHARSET >> 10) & 0x0E)
#endif



/* Use static local variables for speed */
#pragma static-locals (1);

static const signed int xs_aleluya[13] = {
    3,3,7,7,3,3,-3,-3,-7,-7,-3,-3,3
};

static const signed int ys_aleluya[13] = {
    -7,-3,-3,3,3,11,11,3,3,-3,-3,-7,-7
};

unsigned int yd_aleluya[25];
   
static const unsigned char sinustable[] = {
    0x80, 
    0x67, 
    0x4f, 
    0x39, 
    0x26, 
    0x16, 
    0x0b, 
    0x03, 
    0x01, 
    0x03, 
    0x0b, 
    0x16, 
    0x26, 
    0x39, 
    0x4f, 
    0x67, 
    0x80, 
    0x99, 
    0xb1, 
    0xc7, 
    0xda, 
    0xea, 
    0xf5, 
    0xfd, 
    0xff, 
    0xfd, 
    0xf5, 
    0xea, 
    0xda, 
    0xc7, 
    0xb1, 
    0x99, 
};

#define DX_ALELUYA 20
#define DY_ALELUYA 12

static void line_aleluya (register unsigned char* scrn_aleluya,  unsigned char col_aleluya, signed int x1_aleluya, signed int y1_aleluya,signed int x2_aleluya, signed int y2_aleluya) 
{

    signed int xp1_aleluya = (signed int)(x1_aleluya)+DX_ALELUYA ;
    signed int yp1_aleluya = (signed int)(y1_aleluya)+DY_ALELUYA ;
    signed int xp2_aleluya = (signed int)(x2_aleluya)+DX_ALELUYA ;
    signed int yp2_aleluya = (signed int)(y2_aleluya)+DY_ALELUYA ;

    signed int xdt_aleluya = xp2_aleluya - xp1_aleluya;
    signed int ydt_aleluya = yp2_aleluya - yp1_aleluya;
    signed int axdt_aleluya = abs(xdt_aleluya);
    signed int aydt_aleluya = abs(ydt_aleluya); 

    signed int dirx_aleluya = xdt_aleluya < 0 ? -1 : (xdt_aleluya > 0 ? 1 : 0);
    signed int diry_aleluya = ydt_aleluya < 0 ? -1 : (ydt_aleluya > 0 ? 1 : 0);

    signed int x_aleluya = xp1_aleluya;
    signed int y_aleluya = yp1_aleluya;

    signed int x_accum_aleluya = 0;
    signed int y_accum_aleluya = 0;

    char xok_aleluya = 0;
    char yok_aleluya = 0;

    while( xok_aleluya + yok_aleluya < 2 ) {
        unsigned int coord_aleluya = x_aleluya + yd_aleluya[y_aleluya];
        if(coord_aleluya > 0) {
            unsigned char *scrnp_aleluya = scrn_aleluya + coord_aleluya ;
            *scrnp_aleluya = col_aleluya;
        }       
        
        if(x_aleluya == xp2_aleluya) xok_aleluya = 1;
        if(y_aleluya == yp2_aleluya) yok_aleluya = 1;
        
        x_accum_aleluya += axdt_aleluya;
        y_accum_aleluya += aydt_aleluya;
        if(x_accum_aleluya > y_accum_aleluya) {
            if(!xok_aleluya) x_aleluya += dirx_aleluya;
            x_accum_aleluya -= y_accum_aleluya;
        } else {
            if(!yok_aleluya) y_aleluya += diry_aleluya;
            y_accum_aleluya -= x_accum_aleluya;
        }
    }
}

static void doleluya (register unsigned char* scrn_aleluya, int frame_aleluya, unsigned char col_aleluya)
{
    unsigned int nxs_aleluya[13];
    unsigned int nys_aleluya[13];
    register unsigned int i_aleluya;

    for(i_aleluya=0;i_aleluya<12;i_aleluya++) {
        signed int sinrot_aleluya =   ((signed int) (sinustable [ ((20000-frame_aleluya) & 0x1f)]) -0x80);
        signed int cosinrot_aleluya = ((signed int) (sinustable [ ((20000-frame_aleluya) + 0x16) & 0x1f ]) -0x80);
    
        nxs_aleluya[i_aleluya] = (xs_aleluya[i_aleluya] * cosinrot_aleluya - ys_aleluya[i_aleluya] * sinrot_aleluya ) >> 7;
        nys_aleluya[i_aleluya] = (xs_aleluya[i_aleluya] * sinrot_aleluya + ys_aleluya[i_aleluya] * cosinrot_aleluya ) >> 7;
    }
    nxs_aleluya[12] = nxs_aleluya[0];
    nys_aleluya[12] = nys_aleluya[0];

    for(i_aleluya=0;i_aleluya<12;i_aleluya++) {
        int ni_aleluya = i_aleluya + 1;
        line_aleluya(scrn_aleluya,  col_aleluya,  nxs_aleluya[i_aleluya], nys_aleluya[i_aleluya], nxs_aleluya[ni_aleluya], nys_aleluya[ni_aleluya]);
    }
   
}

static void makechar_aleluya (void)
{
    
    unsigned int i_aleluya,j_aleluya;

    for(j_aleluya=0;j_aleluya < 512;j_aleluya++) {
        //Spend some time here


        for (i_aleluya=0;i_aleluya<8;i_aleluya++) {
           ((unsigned char*)CHARSET) [(8 * j_aleluya >> 1) + i_aleluya ] = 0xff - ((1<<i_aleluya) + (0x100>>i_aleluya)) ;       
       }
   }
}
static void makechar2_aleluya (long frame_aleluya)
{
    
    unsigned int i_aleluya;
    if((frame_aleluya & 0x6) == 0) {
        for (i_aleluya=0;i_aleluya<8;i_aleluya++) {
           ((unsigned char*)CHARSET) [0 + i_aleluya ] = 0x4;
        }
        return;
    }
    if((frame_aleluya & 0x6) == 2) {
        for (i_aleluya=0;i_aleluya<8;i_aleluya++) {
           ((unsigned char*)CHARSET) [0 + i_aleluya ] = 1<<i_aleluya;
        }
        return;
    }
    if((frame_aleluya & 0x6) == 6) {
        for (i_aleluya=0;i_aleluya<8;i_aleluya++) {
           ((unsigned char*)CHARSET) [(7-i_aleluya) ] = 1<<i_aleluya;
        }
        return;
    }
    for (i_aleluya=0;i_aleluya<8;i_aleluya++) {
           ((unsigned char*)CHARSET) [0 + i_aleluya ] = 0;
        }
    ((unsigned char*)CHARSET) [3 ] = 0xff;
    
    return;
}

#define outb(addr,val)        (*(addr)) = (val)
#define outw(addr,val)        (*(addr)) = (val)

void doSID_aleluya(int frame_aleluya ) {
    unsigned      ctr_aleluya;
    unsigned char       Tone;

    
    struct __sid_voice *V_aleluya = V1_aleluya.Voice;
    ctr_aleluya = notes_aleluya[(frame_aleluya>>1) & 0x3f];//((frame_aleluya*7)&0x7) ;
    //if((ctr_aleluya & 1) == 1) outb (&V_aleluya->ctrl, V1_aleluya.Trigger & 0xFE);
    //else {
        
            /* This is a tone. Extract the attributes. */
    if(ctr_aleluya > 0) {
        Tone = ctr_aleluya-1;

        /* Calculate the frequency */
        V1_aleluya.Freq = FreqTab [Tone] >> 4;
        outb (&V_aleluya->ctrl, V1_aleluya.Trigger & 0xFE);
        /* Set the frequency */
        outw (&V_aleluya->freq, V1_aleluya.Freq);
        /* Start the tone */
        outb (&V_aleluya->ctrl, V1_aleluya.Trigger);
        //if (--(VC->Ticks) == 0) {
        //    outb (&Voice->ctrl, VC->Trigger & 0xFE);
    //}
    }
}
int main (void)
{

    //ALELUYA
    /*unsigned char border;
    unsigned char background;
    unsigned char text;*/
    unsigned char v;
    
    unsigned long f_aleluya = 0;
    





#if defined(__C64__)
    unsigned char block;
#endif
#if defined(__C128__)
    unsigned char block;
    unsigned char initflag;
    unsigned char graphflag;
#endif
#if defined(__PLUS4__)
    unsigned int i;
    unsigned char v2;
#endif
    //makechar();
    unsigned int i_aleluya;
    for(i_aleluya = 0;i_aleluya<25;i_aleluya++) yd_aleluya[i_aleluya] = i_aleluya * 40;

    //---aleluya1
    /* Initialize the SID */
    outw (&SID.v1.pw, 0x0800);
    outb (&SID.v1.ad, 0x33);
    outb (&SID.v1.sr, 0xF0);
    outw (&SID.flt_freq, 0xF0F0);
    outb (&SID.flt_ctrl, 0xF2);
    outb (&SID.amp, 0x5F);

    /* Sync the clock */
    //NextClock = StartTime = clock ();
    //NextClock += TICKS_PER_TONE;

    //---aleluya2
    /* Set the border and background colors */
   /* border     = bordercolor (COLOR_BLUE);
    background = bgcolor (COLOR_BLACK);
    text       = textcolor (COLOR_WHITE);*/
    bordercolor (COLOR_WHITE);
    bgcolor (COLOR_WHITE);
    textcolor (COLOR_BROWN);

    clrscr();
    //cputsxy (0, 4, "Welcoming you home in the Easter party->Yes Jesus Loves me The Bible tells me so           Repent&Believe");
    cputsxy (0, 4, "Help our eyes dear Jesus to look to TheeTo not get clouded but to stay healthy. May we Repent & Believe.");
    
    
    makechar_aleluya();

#if defined(__C64__) || defined(__C128__)
    /* Move the VIC 16K block */
    block = inb (&CIA2.pra);
    outb (&CIA2.pra, (block & 0xFC) | ((SCREEN1 >> 14) ^ 0x03));
#endif
#if defined(__C128__)
    /* Save and change some flags, so that kernal/basic interrupt handler will
    ** not interfere with our routine.
    */
    initflag = *(unsigned char*) 0xA04;
    *(unsigned char*) 0xA04 &= 0xFE;
    graphflag = *(unsigned char*) 0xD8;
    *(unsigned char*) 0xD8 = 0xFF;
#endif

    /* Remember the VIC address register */
#if defined(__PLUS4__)
    v = inb (&TED.char_addr);
    v2 = inb (&TED.video_addr);
#else
    v = inb (&VIC.addr);
#endif

#if defined(__PLUS4__)
    for (i=0;i<1000;i++) {
        ((unsigned char *) (SCREEN1-0x0400))[i] = 0;
        ((unsigned char *) (SCREEN2-0x0400))[i] = 0;
    }
    outb (&TED.char_addr, CHARADR);
#endif
    for (i_aleluya=0;i_aleluya<1000;i_aleluya++) {
        ((unsigned char *) (SCREEN1))[i_aleluya] = 0;
        ((unsigned char *) (SCREEN2))[i_aleluya] = 0;
    }

    /* Run the demo until a key was hit */
  
    while (!kbhit() && f_aleluya < 128) {
        makechar2_aleluya(-f_aleluya);

        /* Build page 1, then make it visible */
        
        doleluya ((unsigned char*)SCREEN1, f_aleluya-2, 0);
        doleluya ((unsigned char*)SCREEN1, f_aleluya, 1);
#if defined(__PLUS4__)
        outb (&TED.video_addr, PAGE1);
#else
        outb (&VIC.addr, PAGE1);
#endif
        doSID_aleluya(f_aleluya);


        /* Build page 2, then make it visible */
        
        doleluya ((unsigned char*)SCREEN2, f_aleluya-1, 0);
        doleluya ((unsigned char*)SCREEN2, f_aleluya+1, 1);
#if defined(__PLUS4__)
        outb (&TED.video_addr, PAGE2);
#else
        outb (&VIC.addr, PAGE2);
#endif
        doSID_aleluya(f_aleluya+1);

        /* Count frames */
        f_aleluya += 2;

        ///ALELUYA
        /* Play all three voices */
        /* Get a pointer to this voice */
        
        
        
    }
   

        /* Reset the SID */
    outb (&SID.v1.ctrl, 0x00);


    /* Switch back the VIC screen */
#if defined(__PLUS4__)
    outb (&TED.video_addr, v2);
    outb (&TED.char_addr, v);
#else
    outb (&VIC.addr, v);
#endif

#if defined(__C64__) || defined(__C128__)
    /* Move back the VIC 16K block */
    outb (&CIA2.pra, block);
#endif
#if defined(__C128__)
    /* Restore the flags */
    *(unsigned char*) 0xA04 = initflag;
    *(unsigned char*) 0xD8  = graphflag;
#endif

    /* Fetch the character from the keyboard buffer and discard it */
    //(void) cgetc();

    /* Reset screen colors */
    /*bordercolor (border);
    bgcolor (background);
    textcolor (text);*/


    /* Calculate stats */
    /*sec   = (t * 10) / CLK_TCK;
    sec10 = sec % 10;
    sec  /= 10;
    fps   = (f * (CLK_TCK * 10)) / t;
    fps10 = fps % 10;
    fps  /= 10;*/

    /* Output stats */
   /* gotoxy (0, 0); cprintf ("time  : %lu.%us", sec, sec10);
    gotoxy (0, 1); cprintf ("frames: %lu", f);
    gotoxy (0, 2); cprintf ("fps   : %lu.%u", fps, fps10);*/

  /*  if (doesclrscrafterexit ()) {
        cputsxy (0, 4, "");
        (void) cgetc ();
    }*/


    /* Done */
    return EXIT_SUCCESS;
}
