{Ŀ}
{  IVS_VAR .PAS - System Variables and Types                              }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - Platform independent                                    }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}
{$INCLUDE IVS_SET.INC}
{$MODE FPC}

{$NOTES OFF} {  Enable this if you modify the source!  }
{$HINTS OFF} {  Enable this if you modify the source!  }
Unit IVS_Var;

Interface

Const {  >>> S Y S T E M  C O N S T A N T S <<<  }

      IVS_Name       = 'Inquisition Video Server';
      IVS_VersionStr = '2.0.2';
      IVS_Version    = $202;
      IVS_AdditionalVersionStr = 'Codename "Delta Flyer"';

      {  Maximum number of video devices  }
      IVS_MaxDevices = 2;

      {  Videomode capabilities flags  }
      IVS_VMNotSupport = 0;  {  Feature not supported (always disabled)  }
      IVS_VMSupport    = 1;  {  Feature supported (always enabled)  }
      IVS_VMDisabled   = 2;  {  Feature disabled by default  }
      IVS_VMEnabled    = 4;  {  Feature enabled by default  }

      {  Display mode flags  }
      IVS_DMNotSupport = 0;  {  Mode disabled!  }
      IVS_DMNormal     = 1;  {  Scaling not supported in this mode  }
      IVS_DMScaled     = 2;  {  Simple scaling supported  }
      IVS_DMLaced      = 4;  {  Interlaced scaling supported  }
      IVS_DMBilinear   = 8;  {  Interpolated scaling supported  }


Type {  >>> S Y S T E M  S T R U C T U R E S <<<  }

     {  A record, storing pointers to the copy procedures  }
     IVS_TCopyProc = Record
       CP_Normal   : Procedure; {  A simple copy procedure with no scaling  }
       CP_Scaled   : Procedure; {  A normal copy routine with scaling  }
       CP_Laced    : Procedure; {  A copy routine with interlaced scaling  }
       CP_Bilinear : Procedure; {  A copy routine with bilinear scaling  }
      End;

     {  A mode record  }
     IVS_TVideoMode = Record
       VMWidth    : DWord;   {  X resolution  }
       VMHeight   : DWord;   {  Y resolution  }
       VMBFWidth  : DWord;   {  Used backbuffer X resolution  }
       VMBFHeight : DWord;   {  Used backbuffer Y resolution  }
       VMColours  : DWord;   {  Number of colours  }
       VMBPP      : DWord;   {  Bits per pixel  }
       VMName     : String;  {  Name of the videomode  }
       VMMode     : DWord;   {  Video mode number  }
       {  Flag bytes  }
       VMDoubleBuf : Byte;    {  Supports double buffering?  }
       VMVSync     : Byte;    {  Supports vertical retrace syncronization?  }
       VMAvailable : Boolean; {  True if the mode is available.  }
       {  Pointer to the record, storing the Mem->Screen copy functions  }
       VMCopy_Banked : IVS_TCopyProc; {  Storing the banked routines  }
       VMCopy_Linear : IVS_TCopyProc; {  Storing the linear routines  }
      End;
     IVS_PVideoMode = ^IVS_TVideoMode;

     {  Videomode Setup structure, contains flags for easy videomode setup  }
     IVS_TModeSetup = Record
       MSDispMode  : Byte; {  Supported scaling mode number  }
       MSLinear    : Byte; {  Selected linear access?  }
       MSDoubleBuf : Byte; {  Selected double buffering?  }
       MSVSync     : Byte; {  Selected retrace sync?  }
       MSDispFlags       : Byte; {  Active display flags  }
       MSDispFlagsLFB    : Byte; {  Display flags for linear modes  }
       MSDispFlagsBanked : Byte; {  Display flags for banked modes  }
      End;

     {  Device Driver Routines  }
     IVS_TVideoDriver = Record
       {  Detects device. Returns true if available. Also sets the modelist.  }
       DrvDetect : Function : Boolean;
       {  Inits the specified mode. Returns true if successful.  }
       DrvInit   : Function(ModeNumber : DWord; ModeSetup : IVS_TModeSetup) : Boolean;
       {  Closes the device. The device should be closed before a new mode can be set.  }
       DrvClose  : Function : Boolean;
       {  The main backbuffer swap routine  }
       DrvCopy   : Procedure;
      End;
     IVS_PVideoDriver = ^IVS_TVideoDriver;

     {  Device Parameters  }
     IVS_TVideoDevice = Record
       DevDriver   : IVS_PVideoDriver;
       DevAvail    : Boolean; {  True if device is available  }
       DevName     : String;  {  Name of the device  }
       DevDRAM     : DWord;   {  Size DRAM available on device  }
       DevModeNum  : DWord;   {  Number of video modes available  }
       DevBestMode : DWord;   {  Number of the "best" videomode available  }
       DevModeList : IVS_PVideoMode; {  Pointer to the device mode list  }
      End;
     IVS_PVideoDevice = ^IVS_TVideoDevice;


Var {  >>> S Y S T E M  V A R I A B L E S <<<  }

    {  Backbuffer releated  }

    {  Points to the current backbuffer data area.  }
    IVS_VirtualScreen  : Pointer;
    {  Points to the "previous" virtual screen.  }
    {  Used by IVS_Flip in ISS_SYS.PAS  }
    IVS_PrevVirtScreen : Pointer;
    {  The backbuffer copy function  }
    IVS_Copy           : Procedure;

{  >>> Dummy procedure for safe IVS_Copy assigns <<<  }
Procedure IVS_DummyProc;

Const {  >>> A D D I T I O N A L  C O N S T A N T S <<<  }

      {  Dummy procedures for unavailable videomodes  }
      IVS_DummyProcs : IVS_TCopyProc = (
          CP_Normal:@IVS_DummyProc; CP_Scaled  :@IVS_DummyProc;
          CP_Laced :@IVS_DummyProc; CP_Bilinear:@IVS_DummyProc);

Implementation

{  >>> Dummy procedure for safe IVS_Copy assigns <<<  }
Procedure IVS_DummyProc;
Begin
End;

Begin
End.

{  IVS_VAR.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }
