{Ŀ}
{  IVS_VESA.PAS - VESA BIOS Driver - 320x200 15bit include file           }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - GO32V2                                                  }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}

Procedure VESA_Copy15Bit_Linear; Assembler;
Asm
 PUSH ES
 MOV  ESI,IVS_VirtualScreen
 MOV  ES,VESA_SegLFB
 MOV  EDI,VESA_PhysScrAddr
 MOV  ECX,32000
 CLD
 @CycleHead:
  MOV   EAX,[ESI]
  ROR   EAX,8 {  First Pixel  }
  SHR   AH,3
  SHR   AX,3
  ROL   EAX,5
  MOV   EBX,EAX
  MOV   EAX,[ESI+4]
  ROR   EAX,8 {  Second Pixel  }
  SHR   AH,3
  SHR   AX,3
  ROL   EAX,5
  SHL   EAX,16 {  2*16->32  }
  AND   EBX,$0FFFF
  OR    EAX,EBX
  STOSD
  ADD   ESI,8
  DEC   ECX
 JNZ  @CycleHead
 POP  ES
End;

Procedure VESA_Copy15Bit_Banked; Assembler;
Var CurrentBank : Word;
Asm
 XOR  EDX,EDX
 MOV  EAX,VESA_PhysScrAddr
 DIV  VESA_WinSize
 MOV  CurrentBank,AX
 PUSH EDX

 PUSH CurrentBank
 CALL VESA_SwitchBank
 POP  EDX
 PUSH GS
 MOV  ESI,IVS_VirtualScreen
 MOV  GS,VESA_SegA000
 MOV  EDI,EDX
 MOV  EDX,VESA_WinSize
 MOV  ECX,32000
 CLD
 @CycleHead:
  MOV   EAX,[ESI]
  MOV   EBX,[ESI+4]
  ROR   EAX,8 {  First Pixel  }
  SHR   AH,3
  SHR   AX,3
  ROL   EAX,5
  ROR   EBX,8 {  Second Pixel  }
  SHR   BH,3
  SHR   BX,3
  ROL   EBX,5
  SHL   EBX,16 {  2*16->32  }
  AND   EAX,$0FFFF
  OR    EAX,EBX
  MOV   GS:[EDI],EAX
  ADD   EDI,4
  CMP   EDI,EDX
  JB    @NoBankSwitch
    INC CurrentBank
    PUSHAD
    PUSH CurrentBank
    CALL VESA_SwitchBank
    MOV  GS,VESA_SegA000
    POPAD
    XOR EDI,EDI
  @NoBankSwitch:
  ADD   ESI,8
 LOOP @CycleHead
 POP  GS
End;

{  320x200/15bit hicolor  }
Const VESA_LowResHiColor15 : IVS_TVideoMode =
           (VMWidth  :320; VMHeight  :200;
            VMBFWidth:320; VMBFHeight:200;
            VMColours:32768; VMBPP:15;
            VMName:'hicolor';
            VMMode:0;
            VMDoubleBuf:IVS_VMEnabled;
            VMVSync    :IVS_VMDisabled;
            VMAvailable:True;
            VMCopy_Banked:(CP_Normal  :@VESA_Copy15Bit_Banked;
                           CP_Scaled  :@IVS_DummyProc;
                           CP_Laced   :@IVS_DummyProc;
                           CP_Bilinear:@IVS_DummyProc);
            VMCopy_Linear:(CP_Normal  :@VESA_Copy15Bit_Linear;
                           CP_Scaled  :@IVS_DummyProc;
                           CP_Laced   :@IVS_DummyProc;
                           CP_Bilinear:@IVS_DummyProc));

{  VBE_LO15.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }
