"use strict";

class Scene7Controller extends BaseSceneController {

    _grave;
    _graveStartPosition;

    initialize() {
        this.showText("And now he's in his grave with");

        var grassTexture = this.textureManager.get("grass");
        const grassMaterial = new THREE.MeshBasicMaterial({
            map: grassTexture
        });
        var screenHeight = this.getVisibleHeight(-0.0001);
        var screenWidth = this.getVisibleWidth(-0.0001);
        grassTexture.repeat.set(2 * screenWidth / screenHeight, 1);
        var grass = new THREE.Mesh( new THREE.PlaneGeometry(screenWidth, 0.5 * screenHeight), grassMaterial);
        grass.position.set(0, -0.25 * screenHeight, -0.0001);
        this.scene.add(grass);

        var grave = this.spriteManager.get("grave");
        grave.scale.setScalar(2);
        this._graveStartPosition = new THREE.Vector3(0, 0.5 * screenHeight + 1, 0);
        grave.position.copy(this._graveStartPosition);
        this.scene.add(grave);
        this._grave = grave;
    }

    update(time) {
        this._grave.position.copy(this._graveStartPosition.clone().lerp(new THREE.Vector3(0, -1, 0), Math.min(time / 400, 1)));
    }

    clear() {
        // Empty on purpose, no clear
    }
}