"use strict";

class SceneManager {
    _scene;
    _camera;
    _sceneContext;
    _sceneInfos = [];

    constructor(scene, camera, sceneContext) {
        this._scene = scene;
        this._camera = camera;
        this._sceneContext = sceneContext;;
    }

    registerScene(sceneClass, startTime, endTime) {
        var scene = new sceneClass(this._scene, this._camera, this._sceneContext);

        var info = new SceneInfo();
        info.scene = scene;
        info.startTime = startTime;
        info.endTime = endTime;

        this._sceneInfos.push(info);
    }

    updateScenes(globalTime) {
        this._sceneInfos.forEach(sceneInfo => {
            if (globalTime < sceneInfo.startTime)
                return;
            if (globalTime > sceneInfo.endTime) {
                if (sceneInfo.startedTime) {
                    sceneInfo.scene.clear();
                    sceneInfo.startedTime = null;
                }
                return;
            }
            if (!sceneInfo.startedTime) {
                sceneInfo.startedTime = globalTime;
                sceneInfo.scene.initialize();
                console.log(`Started ${sceneInfo.scene.constructor.name}`);
            }
            sceneInfo.scene.update(globalTime - sceneInfo.startedTime, globalTime);
        });
    }

}

class SceneInfo {
    scene;
    startTime;
    endTime;

    startedTime;
}
