#version 430

// layout (location=0) in vec3 vertexPosition;

layout(binding=0) uniform sampler2D texPartPos;
layout(binding=1) uniform sampler2D texPartCol;
layout(binding=2) uniform sampler2D texPal;

out vec2 posV;
out vec4 colV;
out float fadeV;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float g_time;

uniform float effectWidth;
uniform float effectHeight;

uniform float ptw;
uniform float pth;

uniform float approachFade = 10.0;

uniform float paletteFreq = 1.0;
uniform float paletteOfs = 0.0;

void main() {
  vec4 vp = vec4(0.0);

  float id = float(gl_VertexID);
  vp = vec4(0.0, 0.0, 0.0, 1.0);
  float idq = id; // quad index

  vec2 fpt;
  ivec2 pt;
  fpt.y = floor(idq/ptw);
  fpt.x = idq-fpt.y*ptw;
  pt = ivec2(fpt);

  vec4 pp = texelFetch(texPartPos, pt, 0);
  // vec4 pc = texelFetch(texPartCol, pt, 0);
  //vec4 pp = texture2D(tex, fpt/vec2(effectWidth, effectHeight));

  vp.xy += pp.xy*1.0+0.0*(fpt.xy/effectWidth*2.0-vec2(1.0));

  if (pp.z < 0.01) vp.xy*=0.0;

  float fd = 1.0;
  if (pp.z > 2.0) {
    fd = 1.0-min(pp.z-2.0, 1.0);
    fd *= fd;
  } else if (pp.z > 0.0) {
    fd = pp.z;
    fd = min(pp.z*approachFade, 1.0);
    fd *= fd;
  }

//  vp.xy *= 1.0;

  posV = vp.xy;

  vec3 pal = texture2D(texPal, vec2(fract(pp.z*0.9999*paletteFreq+paletteOfs), 0.0)).rgb;

  colV = vec4(pal, 1.0)*fd;
  //colV.z = fd;
  fadeV = fd;
  colV.w = 1.0;
  if (pp.z < 0.01) colV.w = 0.0;
}
