import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: effect
    name: "tonemap"
    effectName: "Tonemap"
    enabled: syncRoot(effect.name+".ON")
    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Shader {
        file: "tonemap"
        ShaderParam {
            paramName: "g_preBright"
            paramValue: sync(effect.name+".preBright")
        }
        ShaderParam {
            paramName: "g_exp"
            paramValue: syncOsc(effect.name+".exp")
        }
        ShaderParam { paramName: "g_lowLimit"; paramValue: sync(effect.name+".lowLimit") }
        ShaderParam { paramName: "g_highLimit"; paramValue: sync(effect.name+".hiLimit") }



        ShaderParam { paramName: "g_solarLimit"; paramValue: sync(effect.name+".solarLimit", 1.0) }
        ShaderParam { paramName: "g_solarAmp"; paramValue: sync(effect.name+".solarAmp", 0.0) }

    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
    }
}

