import QtQuick 2.3
import AdaptDemoSystem 1.0
import QtGraphicalEffects 1.0
import "../"
import "../_SharedQML"

Effect {
    id: fx
    name: "textor"
    effectName: "Textor"

    // RT>0: render effect to rendertarget with name "fxRT"+RT & "fxRTP"+RT
    property int effectRT: s("RT", 0)
    property string effectRTName: "fxRT"+(effectRT.toString())
    property string effectRTPrevName: "fxRTP"+(effectRT.toString())
    property bool clearRT: s("RT.clear", 1.0) > 0.5

    property real ofsX: s("posX")
    property real ofsY: s("posY")

//    property var txts: [
//        "A D A P T",  // 0
//        "PRESENTS",
//        "A DEMO",     // 2
//        "OF THE 2020",
//        "
//:<br>A D A P T<br>
//:<br>
//.2020<br>
//.<br>
//-= deepr -=- mistral =-<br>-=- basscadet -=- legend =-<br>-= felor -=- minomus =-<br>"
//    ]


        property var txts: [
            "A D A P T",  // 0
            "INVITES YOU", // 1
            "TO THE<br>ASSEMBLY",     // 2
            "SUMMER 2020", // 3
            "<i>FALL EDITION</i>", // 4
            "TO THE ASSEMBLY SUMMER 2020 - FALL EDITION", // 5
            "15.-18. October 2020", // 6
            "to the<br><br>ASSEMBLY<br><i>SUMMER 2020 FALL EDITION</i>", // 7
            "TO THE<br><br><b>ASSEMBLY</b><br><i><font size=\"40\">SUMMER 2020<br>FALL EDITION</font></i>",  // 8
            "STAY", // 9
            "STRONG", // 10
            "STAY STRONG", // 11
            "JOIN US", // 12
            "AND COMPETE<br>IN THE<br>COMPOS", // 13
            "COMPETE IN", // 14
"///-<br>
    Oldskool Demo<br>
     PICO-8 Demo<br>
        PC Demo<br>
//-<br>
     4k Intro<br>
    1k Intro<br>
/-<br>
  Real Wild<br>
Short Film<br>
", // 15
            "",
            "",
            "",
        ]

    property string txtShuf: ""

    property real charsRandom: s("chars.state")
    property real charsOfs: s("chars.ofs")
    property real charsSwitchRandom: s("chars.switchRandom", 5.0)
    property real charsSwitchWidth: s("chars.switchWidth", 3.0)

    function getRandomInt(maxValue) {
        return Math.floor(Math.random() * maxValue);
    }

    property var rnds: {[]}
    property int rndsInited: 0

    Component.onCompleted: {
        rnds = [];
        for (var i=0; i<1000; i++) {
            rnds.push(Math.random());
        }
        rndsInited = 1000;
    }

    function getRandomFC(i, maxValue) {
        if (rndsInited <= i) return 0;
        // return 0;
        return Math.floor(rnds[Math.floor(maxValue)%1000]*Math.floor(maxValue*0.50));
    }

    property int txtSel: Math.min(Math.max(s("text"), 0), txts.length);

    function updateShuf() {
        var txtRes = "";

        var txtOrig = txts[txtSel];
        var len = txtOrig.length;

        for (var i=0; i<len; i++) {
            var crr = 1.0;
            if (charsRandom < 0.0) {
                crr = Math.max(-charsRandom*len-(i), 0.0);
            } else {
                crr = Math.max(charsRandom*len-(len-i), 0.0);
            }

            if (crr > charsSwitchWidth || txtOrig.charAt(i) === " ") {
                txtRes += "&nbsp;";
                //txtShuf += " ";
                continue;
            }
            crr *= charsSwitchRandom;
            //  txtRes += "-";
            txtRes += String.fromCharCode(txtOrig.charCodeAt(i)+charsOfs+getRandomFC(i, crr));
        }

        txtShuf = txtRes;
    }

    onCharsRandomChanged: {
        updateShuf();
    }
    onCharsOfsChanged: {
        updateShuf();
    }

    property string txt: txtShuf

    //    FontLoader {
    //        name: "Expansiva"
    //        source: "../../fonts/expansiva/Expansiva.otf"
    //    }

    FontLoader {
        name: "Telegrama"
        source: "../../fonts/telegrama/telegrama_render.otf"
    }


//    RenderTarget {
//        enabled: effectRT>0
//        RenderTargetLayer {
//            textureRT: effectRTName; format: "RGBA32F";
//            width: effectWidth; height: effectHeight
//            Clear {
//                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
//            }
//        }
//    }

    RenderTarget {
        enabled: effectRT>0 && clearRT
        RenderTargetLayer {
            textureRT: effectRTPrevName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
        DrawRT {
            textureRT: effectRTName
            drawBuffers: 1
        }
    }

    RenderTarget {
        enabled: effectRT>0
        RenderTargetLayer {
            textureRT: effectRTName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                enabled: clearRT
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
            mode: 1 // mode 1 = start render to the effect RT
        }
    }


    Item {
        visible: false
        enabled: false
        id: infoText
        layer.enabled: true
        width: demo.windowWidth
        height: demo.windowHeight
        Item {
            id: texts
            anchors.fill: parent
            Text {
                id: textu
                x: ofsX*demo.windowWidth
                y: ofsY*demo.windowHeight
                opacity: 1.0
                font.pixelSize: s("font.size")*(demo.windowWidth/1280.0)
                color: "white"
                font.family: "Telegrama"
                text: txt
                width: (1280.0-0.0)*(demo.windowWidth/1280.0)
                height: demo.windowHeight
                wrapMode: Text.WordWrap
                //textFormat: Text.PlainText
                textFormat: Text.RichText
                //textFormat: Text.StyledText

                antialiasing: true
                smooth: true
                // anchors.horizontalCenter : parent.horizontalCenter
            }

        }
    }

    TextureSel { id: texOvlSel; textureUnit: 0; nameOverride: fx.name+".ovl.texInd";  }
    property real ovlScale: s("ovl.scale", 1.0);
    property real ovlPosX: s("ovl.posX", 0.0);
    property real ovlPosY: s("ovl.posY", 0.0);
    DrawRT {
      enabled: texOvlSel.texInd > 0
    //  property real size: 0.5 //  1024.0/1280.0
      center: Qt.vector2d(ovlPosX, ovlPosY)
      sca: Qt.vector2d(ovlScale, ovlScale)
     // sca: texPreviewAspect < 16.0/9.0 ? Qt.vector2d(size*texPreviewTextureSel.texWidth/texPreviewTextureSel.texHeight*9.0/16.0, -size) : Qt.vector2d(size, -size*texPreviewTextureSel.texHeight/texPreviewTextureSel.texWidth*16.0/9.0)
      blendMode: "off"
      flip: false
    }

    DrawRT {
        visible: s("ON") > 0.5
        enabled: s("ON") > 0.5
        textureItem: infoText
        flip: false
    }



    RenderTarget {
        enabled: effectRT>0
        RenderTargetLayer {
            textureRT: effectRTName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            mode: 2 // mode 2 = end render to the effect RT
        }
    }



}

