import QtQuick 2.3
import AdaptDemoSystem 1.0
import QtGraphicalEffects 1.0
import "../"
import "../_SharedQML"

Effect {
    id: fx
    name: "partor"
    effectName: "Partor"

    property int sWidth: s("fx.width", 0)
    property int sHeight: s("fx.height", 0)

    property int effectWidth: sWidth!==0 ? sWidth : demo.windowWidth
    property int effectHeight: sHeight!==0 ? sHeight : demo.windowHeight

    property bool reset: syncTrigger(name+".reset") > 0.5

    property int srcRT: s("srcRT", 1)
    property string srcRTName: "fxRT"+(srcRT.toString())
    property string srcRTPrevName: "fxRTP"+(srcRT.toString())

    ShaderAtomicCounter { name: fx.name+".nextFreeParticle"; clear: reset; bind: 0 }



    Texture { textureUnit: 0; textureRT: srcRTName }
    Texture { textureUnit: 1; textureRT: srcRTPrevName }
    //Texture { textureUnit: 2; textureWrap: "clamp"; textureRT: ((frameIndex&1)===0) ? fx.name+"Parts1" : fx.name+"Parts2" }
    //Texture { textureUnit: 3; textureWrap: "clamp"; textureRT: ((frameIndex&1)===1) ? fx.name+"Parts1" : fx.name+"Parts2" }

    property int frameIndex: 0
    Connections {
        target: demo; onFrameRendered: {
            frameIndex++;
        }
    }

    property int ptw: 2048
    property int pth: 2048

    RenderTarget {
        RenderTargetLayer {
            textureRT: fx.name+"Particles"; format: "RGBA32F";
            width: fx.ptw; height: fx.pth
            Clear {
                enabled: frameIndex<2 || reset
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: fx.name+"ParticlesSUV"; format: "RGBA32F";
            width: fx.ptw; height: fx.pth
            Clear {
                enabled: frameIndex<2 || reset
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }

    Shader { file: "spartorEmit" }
    RenderTarget {
        RenderTargetLayer {
            textureRT: fx.name+"temp"
            format: "RGBA32F";
            width: effectWidth; height: effectHeight
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: fx.name+"Particles" } // write
        Texture { textureUnit: 1; imageUnit: 1; textureRT: fx.name+"ParticlesSUV" } // write
        Texture { textureUnit: 0; textureRT: srcRTName }
        Texture { textureUnit: 1; textureRT: srcRTPrevName }

        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1

            ShaderParam { paramName: "approachOrigSize"; paramValue: s("approach.origSize", 1.0) }
            ShaderParam { paramName: "approachRandSize"; paramValue: s("approach.randSize", 0.10) }

            ShaderParam { paramName: "emitsNum"; paramValue: s("emits.num", 1.0) }
            ShaderParam { paramName: "emitsSpread"; paramValue: s("emits.spread", 1.0) }
            ShaderParam { paramName: "emitsSpread"; paramValue: s("emits.spreadAmp", 1.0) }
            ShaderParam { paramName: "emitsSpreadFade"; paramValue: s("emits.spreadFade", 0.20) }
            ShaderParam { paramName: "emitsSpreadUV"; paramValue: s("emits.spreadUV", 0.50) }

            ShaderParam { paramName: "effectWidth"; paramValue: effectWidth }
            ShaderParam { paramName: "effectHeight"; paramValue: effectHeight }

            ShaderParam { paramName: "ptw"; paramValue: ptw }
            ShaderParam { paramName: "pth"; paramValue: pth }

        }
    }

//    Texture { textureUnit: 2; textureRT: fx.name+"Particles" } // read & write
//    Texture { textureUnit: 3; textureRT: fx.name+"ParticlesSUV" } // read & write

    Shader { file: "spartorSim" }
    RenderTarget {
        RenderTargetLayer {
            textureRT: fx.name+"temp2"
            format: "RGBA32F";
            width: fx.ptw; height: fx.pth
        }

        Texture { textureUnit: 0; imageUnit: 0; textureRT: fx.name+"Particles" } // read & write
        Texture { textureUnit: 1; imageUnit: 1; textureRT: fx.name+"ParticlesSUV" } // read & write
        Texture { textureUnit: 0; textureRT: srcRTName }
        Texture { textureUnit: 1; textureRT: srcRTPrevName }

        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1

            ShaderParam { paramName: "effectWidth"; paramValue: effectWidth }
            ShaderParam { paramName: "effectHeight"; paramValue: effectHeight }

            ShaderParam { paramName: "approachOrigSize"; paramValue: s("approach.origSize", 1.0) }
            ShaderParam { paramName: "approachRandSize"; paramValue: s("approach.randSize", 0.10) }
            ShaderParam { paramName: "approachSpeed"; paramValue: s("approach.speed", 0.50) }
            ShaderParam { paramName: "approachNoiseFreq"; paramValue: s("approach.noise.freq", 2.0) }
            ShaderParam { paramName: "approachNoiseDist"; paramValue: s("approach.noise.dist", 0.50) }
            ShaderParam { paramName: "approachNoiseDistOfs"; paramValue: s("approach.noise.distOfs", 1.0) }
            ShaderParam { paramName: "approachNoiseAmp"; paramValue: s("approach.noise.amp", 1.0) }
            ShaderParam { paramName: "approachNoiseSpeed"; paramValue: s("approach.noise.speed", 0.50) }

            ShaderParam { paramName: "vaporizeOrigShape"; paramValue: s("vaporize.origShape", 1.0) }
            ShaderParam { paramName: "vaporizeSpeed"; paramValue: s("vaporize.speed", 1.0) }
            ShaderParam { paramName: "vaporizeNoiseAmp"; paramValue: s("vaporize.noise.amp", 2.0) }
            ShaderParam { paramName: "vaporizeNoiseDist"; paramValue: s("vaporize.noise.dist", 2.0) }
            ShaderParam { paramName: "vaporizeNoiseFreq"; paramValue: s("vaporize.noise.freq", 1.50) }
            ShaderParam { paramName: "vaporizeNoiseDistOfs"; paramValue: s("vaporize.noise.distOfs", 2.0) }
            ShaderParam { paramName: "vaporizeNoiseSpeed"; paramValue: s("vaporize.noise.speed", 0.20) }

        }
    }




    Blit {
        textureRT: "colorBuffer"
    }

//    ClearRT {
//    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "partsColors"; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "partsMask"; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }

    property int partsNum: ptw*pth

    Shader { file: "spartorDrawG" }
    Texture { textureUnit: 0; textureWrap: "clamp"; textureRT: fx.name+"Particles" }
    Texture { textureUnit: 1; textureRT: srcRTName }
    TextureSel { nameOverride: effect.name+".palette.texInd"; textureUnit: 2; }
    DrawVB {
        type: "emptyVBO"
        primType: "points"
        vboId: sceneName+effect.name+".parts"
        depthTest: false; depthWrite: false
        blendMode: "add"
        drawNumPoints: (partsNum)

        Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
        Pos { x: 0.0; y: 0.0; z: 0.0}
        Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }

        ShaderParam { paramName: "param"; paramValue: 0.0 }

        ShaderParam { paramName: "ptw"; paramValue: ptw }
        ShaderParam { paramName: "pth"; paramValue: pth }

        ShaderParam { paramName: "effectWidth"; paramValue: effectWidth }
        ShaderParam { paramName: "effectHeight"; paramValue: effectHeight }

        ShaderParam { paramName: "bright"; paramValue: s("draw.bright", 1.0) }
        ShaderParam { paramName: "maskBright"; paramValue: s("draw.maskBright", 1.0) }

        ShaderParam { paramName: "approachFade"; paramValue: s("approach.fade", 1.0) }
        ShaderParam { paramName: "paletteFreq"; paramValue: s("palette.freq", 1.0) }
        ShaderParam { paramName: "paletteOfs"; paramValue: s("palette.ofs", 0.0) }

        ShaderParam { paramName: "drawSize"; paramValue: s("draw.size", 1.0) }

        drawBuffers: 2
        drawBufferRT: "partsColors"
        drawBufferRT2: "partsMask"
    }



//    Blit {
//        textureRT: "partsBuffer"
//    }

//    Blit {
//        textureRT: "partsMask"
//        blitRT: 1
//    }

    Shader { file: "mixMask" }
    Texture { textureUnit: 0; textureRT: "colorBuffer" }
    Texture { textureUnit: 1; textureRT: "partsColors" }
    Texture { textureUnit: 2; textureRT: "partsMask" }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }


}

