import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
    id: effect
  //  name: "mesher"
    effectName: "Mesher"

   // pm: "Mesher"

//    property int maxDiv: 2048
    property int maxDiv: 1024

    property bool drawOnly: false

    property int div: Math.max(1, s("div", 100))

    property bool setShader: true

    property var depthTestIn: undefined
    property bool depthTestActive: (depthTestIn !== undefined) ? depthTestIn : true

    property var depthWriteIn: undefined
    property bool depthWriteActive: (depthWriteIn !== undefined) ? depthWriteIn : true


    property var fixedTimeStepIn: undefined

//    property bool fileMesh: meshIndex>0
//    property int meshIndex: s("mesh.meshIndex", 0)
//    property int mesh2Index: s("mesh2.meshIndex", 0)
    property bool fileMesh: false

    RenderTarget { RenderTargetLayer { textureRT: "mesherTriangles"+effect.name; format: "RGBA32F"; width: 2048; height: maxDiv } }
    RenderTarget { RenderTargetLayer { textureRT: "mesherTriAdjLeft"+effect.name; format: "RGBA32F"; width: 2048; height: maxDiv } }
    RenderTarget { RenderTargetLayer { textureRT: "mesherTriAdjRight"+effect.name; format: "RGBA32F"; width: 2048; height: maxDiv } }
    RenderTarget { RenderTargetLayer { textureRT: "mesherVertPriTri"+effect.name; format: "R32F"; width: 2048; height: maxDiv } }
    RenderTarget { RenderTargetLayer { textureRT: "mesherTriNorm"+effect.name; format: "RGBA32F"; width: 2048; height: maxDiv } }
    RenderTarget { RenderTargetLayer { textureRT: "mesherVertPos"+effect.name; format: "RGBA32F"; width: 2048; height: maxDiv } }
    RenderTarget { RenderTargetLayer { textureRT: "mesherVertNorm"+effect.name; format: "RGBA32F"; width: 2048; height: maxDiv } }


    // used for accessing loading the texture buffers
//    DrawMesh {
//      id: mesh
//      enabled: fileMesh
//      file: meshSel(effect.name+".mesh")
//      drawBuffers: 0
//      meshTexture: true
//    }
//    DrawMesh {
//      id: mesh2
//      enabled: fileMesh
//      file: meshSel(effect.name+".mesh2")
//      drawBuffers: 0
//      meshTexture: true
//    }

//    property int meshFaceCount: 0

//    Connections {
//      enabled: fileMesh
//      target: demo
//      onFrameRendered: {
//        meshFaceCount = mesh.getNumMeshFaces(Math.abs(meshFileIndex1));
//      }
//    }

    property bool triggerDrawEnabled: s("noise.updateOnRequest") > 0.5
    property bool triggerDraw: (!drawOnly && !fileMesh) && triggerDrawEnabled && (syncTrigger(effect.name+".noise.updateOnRequest")>0.5)

    property int tdc: 0
    onTriggerDrawChanged: {
      log("triggerDraw now, count:"+tdc);
      tdc++;
    }

    // generate meshes & related buffers
    GroupBase {
      effectName: effect.effectName
      enabled: (!drawOnly && !fileMesh && !triggerDrawEnabled) || (triggerDrawEnabled && triggerDraw)

      // 1st generate mesh into triangles & adjacency info RT's
      // the mesh is generated so that
      // -mesherTriangles RGB will have integer indexes into the vertices
      RenderTarget {
          Shader { file: "mesherGen" }
          RenderTargetLayer {
              textureRT: "mesherTriangles"+effect.name; format: "RGBA32F"; width: 2048; height: maxDiv
          }
          Texture { textureUnit: 0; imageUnit: 0; textureRT: "mesherTriangles"+effect.name } // write
          Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPriTri"+effect.name } // write
          Texture { textureUnit: 2; imageUnit: 2; textureRT: "mesherTriAdjLeft"+effect.name } // write
          Texture { textureUnit: 3; imageUnit: 3; textureRT: "mesherTriAdjRight"+effect.name } // write


          DrawVB {
              type: "quad"
              depthTest: false
              depthWrite: false
              blendMode: "off"
              ShaderParam { paramName: "div"; paramValue: div }

              ShaderParam { paramName: "shape"; syncName: ns("shape"); syncDefault: 0.0 } // 0.0 = plane, 1.0 = ball
          }
      }


      Texture {
          textureUnit: 6;
          texImage: getTexImageFFT(effect.name+".disp.amp")
      }

      // Generate the shape
      // -vertices are stored in the mesherVertPos
      RenderTarget {
          Shader { file: "mesherGenShape" }
          RenderTargetLayer {
              textureRT: "mesherTriangles"+effect.name; format: "RGBA32F"; width: 2048; height: maxDiv
              // Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
          }

          Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos"+effect.name } // write

          TextureSel { nameOverride: effect.name+".disp.heightImg.texInd"; textureUnit: 0; }
          property int texLay1: s("disp.heightImg.texInd", 0.0)

          DrawVB {
              type: "quad"
              depthTest: false
              depthWrite: false
              blendMode: "off"
              ShaderParam { paramName: "div"; paramValue: div }

              ShaderParam { paramName: "noiseOfsX"; syncName: ns("noise.ofs.x"); syncDefault: 0.0 }
              ShaderParam { paramName: "noiseOfsY"; syncName: ns("noise.ofs.y"); syncDefault: 0.0 }
              ShaderParam { paramName: "noisePos"; syncFFTName: ns("noise.pos"); syncDefault: 0.0 }
              ShaderParam { paramName: "noiseFreq"; syncFFTName: ns("noise.freq"); syncDefault: 1.0 }
              ShaderParam { paramName: "noiseOct"; syncName: ns("noise.oct.num"); syncDefault: 3.0 }
              ShaderParam { paramName: "noiseOctMul"; syncName: ns("noise.oct.mul"); syncDefault: 2.0 }
              ShaderParam { paramName: "noiseOctAmp"; syncName: ns("noise.oct.amp"); syncDefault: 0.5 }

              ShaderParam { paramName: "dispImgAmp"; syncName: ns("disp.heightImg.amp"); syncDefault: 0.0 }

             // ShaderParam { paramName: "dispAmp"; syncFFTName: ns("disp.amp"); syncDefault: 1.0 }
              ShaderParam { paramName: "dispAmp"; paramValue: syncFFT(effect.name+".disp.amp", 1.0)}

              ShaderParam { paramName: "dispExp"; syncName: ns("disp.exp"); syncDefault: 1.0 }
              ShaderParam { paramName: "dispSub"; syncName: ns("disp.sub"); syncDefault: 0.5 }
              ShaderParam { paramName: "dispMinLim"; syncName: ns("disp.minLim"); syncDefault: -1.0 }
              ShaderParam { paramName: "dispMaxLim"; syncName: ns("disp.maxLim"); syncDefault: 1.0 }
              ShaderParam { paramName: "dispSmooth"; syncName: ns("disp.smooth"); syncDefault: 0.0 }

              ShaderParam { paramName: "shape"; syncName: ns("shape"); syncDefault: 0.0 } // 0.0 = plane, 1.0 = ball


//              uniform float modFFT_hOfsMul = 1.0;
//              uniform float modFFT_hOfsPow = 0.20;

//              uniform float modFFT_base = -0.50;
//              uniform float modFFT_hPow = 1.0;
//              uniform float modFFT_hMul = 1.0;

              ShaderParam { paramName: "modFFT_hOfsMul"; syncName: ns("modFFT.height.ofsMul"); syncDefault: 1.0 }
              ShaderParam { paramName: "modFFT_hOfsPow"; syncName: ns("modFFT.height.ofsPow"); syncDefault: 0.20 }
              ShaderParam { paramName: "modFFT_base"; syncName: ns("modFFT.height.base"); syncDefault: 1.0 }
              ShaderParam { paramName: "modFFT_hPow"; syncName: ns("modFFT.height.pow"); syncDefault: 1.0 }
              ShaderParam { paramName: "modFFT_hMul"; syncName: ns("modFFT.height.mul"); syncDefault: 0.0 }



              ShaderParam { paramName: "scaleX"; syncName: ns("trans.scale.x"); syncDefault: 1.0 }
              ShaderParam { paramName: "scaleY"; syncName: ns("trans.scale.y"); syncDefault: 1.0 }
              ShaderParam { paramName: "scaleZ"; syncName: ns("trans.scale.z"); syncDefault: 1.0 }

          }
      }

      MesherCalcNorm {
        efName: effect.name
        div: effect.div
      }

      RenderTarget {
          Shader { file: "mesherGenShapeRec" }
          RenderTargetLayer {
              textureRT: "mesherTriangles"+effect.name; format: "RGBA32F"; width: 2048; height: maxDiv
          }
          Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos"+effect.name } // read & write
          Texture { textureUnit: 2; imageUnit: 2; textureRT: "mesherVertNorm"+effect.name } // read

          TextureSel { nameOverride: effect.name+".recDisp.heightImg.texInd"; textureUnit: 0; }
          property int texLay1: s("recDisp.heightImg.texInd", 0.0)

          DrawVB {
              type: "quad"
              depthTest: false
              depthWrite: false
              blendMode: "off"
              ShaderParam { paramName: "div"; paramValue: effect.div }

              ShaderParam { paramName: "noiseOfsX"; syncName: ns("recNoise.ofs.x"); syncDefault: 0.0 }
              ShaderParam { paramName: "noiseOfsY"; syncName: ns("recNoise.ofs.y"); syncDefault: 0.0 }
              ShaderParam { paramName: "noisePos"; syncFFTName: ns("recNoise.pos"); syncDefault: 0.0 }
              ShaderParam { paramName: "noiseFreq"; syncFFTName: ns("recNoise.freq"); syncDefault: 1.0 }
              ShaderParam { paramName: "noiseOct"; syncName: ns("recNoise.oct.num"); syncDefault: 3.0 }
              ShaderParam { paramName: "noiseOctMul"; syncName: ns("recNoise.oct.mul"); syncDefault: 2.0 }
              ShaderParam { paramName: "noiseOctAmp"; syncName: ns("recNoise.oct.amp"); syncDefault: 0.5 }

              ShaderParam { paramName: "dispImgAmp"; syncName: ns("recDisp.heightImg.amp"); syncDefault: 0.0 }
              ShaderParam { paramName: "dispAmp"; syncName: ns("recDisp.amp"); syncDefault: 1.0 }
              ShaderParam { paramName: "dispExp"; syncName: ns("recDisp.exp"); syncDefault: 1.0 }
              ShaderParam { paramName: "dispSub"; syncName: ns("recDisp.sub"); syncDefault: 0.0 }
              ShaderParam { paramName: "dispMinLim"; syncName: ns("recDisp.minLim"); syncDefault: -1.0 }
              ShaderParam { paramName: "dispMaxLim"; syncName: ns("recDisp.maxLim"); syncDefault: 1.0 }
              ShaderParam { paramName: "dispSmooth"; syncName: ns("recDisp.smooth"); syncDefault: 0.0 }
          }
      }
      MesherCalcNorm {
        div: effect.div
        efName: effect.name
      }
    }


    //property int meshFileIndex1: s("mesh.subMesh", 0)

   // Texture { id: meshTrianglesTex; textureUnit: 0; imageUnit: 0; textureRT: !fileMesh ? "mesherTriangles"+effect.name : ("meshTexFI_"+meshFileIndex1+"_"+mesh.file)
    Texture { id: meshTrianglesTex; textureUnit: 0; imageUnit: 0; textureRT: "mesherTriangles"+effect.name
      property string pulkka: textureRT;
        onPulkkaChanged: {
     //     log("texFI:"+pulkka)
        }

    } // read
    //Texture { id: meshVerticesPosTex; textureUnit: 1; imageUnit: 1; textureRT: !fileMesh ? "mesherVertPos"+effect.name : ("meshTexVP_"+meshFileIndex1+"_"+mesh.file)
    Texture { id: meshVerticesPosTex; textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos"+effect.name
      property string pulkka: textureRT;
        onPulkkaChanged: {
       //   log("tex:"+pulkka)
        }
    } // read
    //Texture { textureUnit: 2; imageUnit: 2; textureRT: !fileMesh ? "mesherVertNorm"+effect.name : ("meshTexVN_"+meshFileIndex1+"_"+mesh.file) } // read
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "mesherVertNorm"+effect.name } // read


    Shader {
      enabled: setShader
      file: "mesherDraw"
    }
    TextureSel { id: tex; nameOverride: effect.name+".mat.diff.texInd"; textureUnit: 0; }
    TextureSel { id: texBump; nameOverride: effect.name+".mat.bump.texInd"; textureUnit: 1; }
    property int bumpTex: s("mat.bump.texInd")

    TextureSel { id: texNormalMap; nameOverride: effect.name+".mat.normalMap.texInd"; textureUnit: 2; }
    TextureSel { id: texEmitMap; nameOverride: effect.name+".mat.emitMap.texInd"; textureUnit: 3; }

    DrawVB {
        type: "emptyVBO"
        primType: "triangles"
        vboId: sceneName+effect.name+"mesher"
        depthTest: depthTestActive; depthWrite: depthWriteActive
        blendMode: blendSel(effect.name)

        drawNumPoints: {
          if (!fileMesh) {
            return 6*effect.div*effect.div;  // ball or plane
          }
         // log("meshTex width:"+meshTrianglesTex.textureWidth)
         // return meshTrianglesTex.textureWidth*meshTrianglesTex.textureHeight*3;
          //var numFac = meshFaceCount;
        //  log("meshTex numFac:"+numFac);
         // return numFac*3;
        }

//        property int purkka: drawNumPoints
//        property var purkka2: fileMesh
//        onPurkka2Changed: {
//          log("draw points:"+purkka)
//        }

        Pos { x: s("trans.pos.x", 0.0); y: s("trans.pos.y", 0.0); z: s("trans.pos.z", 0.0)}
        Rot { d: s("trans.rot.x", 0.0); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: s("trans.rot.y", 0.0); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sf("trans.rot.z", 0.0); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: syncIn(effect.name+".trans.scale", 1.0); x: 1.0; y: 1.0; z: 1.0 }

        ShaderParam { paramName: "div"; paramValue: div }

        ShaderParam { paramName: "dispBrightMul"; syncName: ns("disp.bright.mul"); syncDefault: 1.0 }
        ShaderParam { paramName: "dispBrightOfs"; syncName: ns("disp.bright.ofs"); syncDefault: 0.0 }
        ShaderParam { paramName: "dispBrightExp"; syncName: ns("disp.bright.exp"); syncDefault: 1.0 }

        ShaderParam { paramName: "uvScale"; syncName: ns("mat.uvScale"); syncDefault: 1.0 }

//        ShaderParam { paramName: "specAmp"; paramValue: s("mat.spec.amp", 1.0) }
//        ShaderParam { paramName: "specExp"; paramValue: s("mat.spec.exp", 1.0) }
        ShaderParam { paramName: "alpha"; syncName: ns("mat.alpha"); syncDefault: 1.0 }
        ShaderParam { paramName: "diffAmp"; syncName: ns("mat.diff.amp"); syncDefault: 1.0 }
        ShaderParam { paramName: "diffExp"; syncName: ns("mat.diff.exp"); syncDefault: 1.0 }
        ShaderParam { paramName: "ambient"; syncName: ns("mat.ambient"); syncDefault: 0.1 }
        ShaderParam { paramName: "texAmount"; syncName: ns("mat.texAmount"); syncDefault: 1.0 }

        ShaderParam { paramName: "bumpUvScale"; syncName: ns("mat.bump.uvScale"); syncDefault: 1.0 }
        ShaderParam { paramName: "bumpStrength"; syncName: ns("mat.bump.strength"); syncDefault: 1.0 }
        ShaderParam { paramName: "bumpTexDelta"; syncName: ns("mat.bump.texDelta"); syncDefault: 1.0 }
        ShaderParam { paramName: "bumpTexInd"; paramValue: bumpTex }

        ShaderParam { paramName: "scaleX"; syncName: ns("trans.scale.x"); syncDefault: 1.0 }
        ShaderParam { paramName: "scaleY"; syncName: ns("trans.scale.y"); syncDefault: 1.0 }
        ShaderParam { paramName: "scaleZ"; syncName: ns("trans.scale.z"); syncDefault: 1.0 }

        ShaderParam { paramName: "g_timeStep"; paramValue: fixedTimeStepIn !== undefined ? fixedTimeStepIn : rocket.timeStep }

        ShaderParam { paramName: "emitAmount"; syncFFTName: ns("pardEmit.amount"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitAmountFromBright"; syncFFTName: ns("pardEmit.amount.fromBright"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitAge"; syncFFTName: ns("pardEmit.age"); syncDefault: 1.0 }
        ShaderParam { paramName: "emitAgeFromBright"; syncFFTName: ns("pardEmit.age.fromBright"); syncDefault: 0.0 }

        ShaderParam { paramName: "emitVelDirAmp"; syncFFTName: ns("pardEmit.velDir.amp"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirX"; syncName: ns("pardEmit.velDir.x"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirY"; syncName: ns("pardEmit.velDir.y"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirZ"; syncName: ns("pardEmit.velDir.z"); syncDefault: 0.0 }

        ShaderParam { paramName: "emitIntersect"; syncName: ns("pardEmit.intersect"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitIntExp"; syncName: ns("pardEmit.intersect.exp"); syncDefault: 1.0 }

        ShaderParam { paramName: "useNormalMap"; syncName: ns("mat.normalMap.texInd"); syncDefault: 0.0 }
        ShaderParam { paramName: "useEmitMap"; syncName: ns("mat.emitMap.texInd"); syncDefault: 0.0 }

    }
}
