import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


Group {
    id: dustPartikles
    property string name: "dustPart"
    property string forceName: "dustForce"
    property int particleCount: 0
    property bool drawEnabled: true
    property string drawBlendMode: "add"

    property string partTexture: "../../images/particles_64_2048.png"

    property int maxParticles: 100*100
    property int drawParticles: 10

    enabled: syncRoot(name+".ON")

//    property string emitMesh: "mesh/kolkkus.x"
    property alias emitMesh: dm.delegate


    property string sacName: "sacDust"+getUniqueId().toString()

    Blit {
        textureRT: "depth"; blitRT: 1;
    }

//    Blit {
//        enabled: drawEnabled
//        textureRT: "bg"
//        blitRT: 0
//    }

    property int maxEmitLayers: 1

    RenderTarget {
        RenderTargetLayer {
            textureRT: "emittedDustPartPos"
            format: "RGBA16F"
            width: 1280*maxEmitLayers
            height: 720*maxEmitLayers
        }
    }
    ShaderAtomicCounter { property string name: sacName; clear: true }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedDustPartPos" }
    Shader { file: "smDustEmitter" }

    TextureImage {
        textureUnit: 0
        file: "../../images/gas1.png"
    }

    // emitmesh
    Repeater { id: dm; model: 1 }

    ShaderAtomicCounter { property string name: sacName }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedDustPartPos" }
//    WaterPartikles { id: wp; name: "waterPart"; drawEnabled: sync(name+".drawEnabled") }

    DustPartSim {
        name: dustPartikles.name
        forceName: dustPartikles.forceName
        simShader: "simPartDust"
        //drawShader: "partBalls"
        //drawBlendMode: "off"
        drawEnabled: dustPartikles.drawEnabled
        drawShader: "partDust"
        drawBlendMode: parent.drawBlendMode

        partTexture: parent.partTexture

        onParticleCountChanged: {
            dustPartikles.particleCount = particleCount;
        }

        // max particles count is gridDimension*gridDimension
        // CHANGE PROPOSAL: make a new parameter maxPoints instead...
        gridDimension: Math.sqrt(maxParticles)

        // This is actually the number of points drawn for the first frame
        // of the simulation (or when reset).
        // As after that, the simulation will continue with own number of particles
        // as some particles might die and others might emit new ones...
        // CHANGE PROPOSAL: because of the above explanation, change this variable name to
        // initNumPoints instead ...
        drawNumPoints: drawParticles

        partSize: sync(name+".partSize")
        //  partEmitShapeImage: "../../images/black.png"
        //partEmitShapeImage: "../../images/PinkMedusa.png"
    }

//    Group {
//        enabled: waterPartikles.drawEnabled
//        Blit {
//            textureRT: "prevFrame"
//        }
//        Blit {
//            textureRT: "prevFrame2"
//            blitRT: 1
//        }
//        Texture {
//            textureUnit: 0
//            textureRT: "prevFrame"
//        }
//        Texture {
//            textureUnit: 1
//            textureRT: "bg"
//            //textureRT: "depth"
//        }
//        Texture {
//            textureUnit: 2
//            textureRT: "prevFrame2"
//        }
//        Shader {
//            //file: sceneDir+"mixBalls"
//            file: sceneDir+"mixWater"
//        }
//        DrawVB {
//            ShaderParam {
//                paramName: "flip"
//                paramValue: 0.0
//            }
//            ShaderParam {
//                paramName: "g_bgAmount"; paramValue: sync(waterPartikles.name+".bgAmount")
//            }
//            ShaderParam {
//                paramName: "g_lightAmount"; paramValue: sync(waterPartikles.name+".lightAmount")
//            }
//            ShaderParam {
//                paramName: "g_waterClip"; paramValue: sync(waterPartikles.name+".waterClip")
//            }
//            ShaderParam {
//                paramName: "g_bumpStrength"; paramValue: sync(waterPartikles.name+".bumpStrength")
//            }
//            type: "quad"
//            depthTest: false
//            depthWrite: false
//            drawBuffers: 2
//        }
//    }
}

