import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

Group {
    id: partSim
    property string name: "partSim"
    property string forceName: "partSim"
    property string simShader: "simPart"
    property string drawShader: "partWater"
    property string drawBlendMode: "add"
    property int gridDimension: 600
    property int drawNumPoints: 100*100
    property bool drawEnabled: true



    property string partTexture: "../../images/particles_64_2048.png"

    property real partSize: 0.50

    property string partEmitShapeImage: "../../images/adapt_logo2_full.png"

    property int particleCount: advanceSim.particleCount

    signal particleCountTo(int pc)

    Blit {
        textureRT: "screenBuffer"
    }

    Texture {
        textureUnit: 0
        textureItem: particleTexture
        Image {
            id: particleTexture
            source: partTexture
        }
    }

    Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "../../images/system/random16.png"
        }
    }

    Texture {
        textureUnit: 2
        textureItem: particleEmitShape
        Image {
            id: particleEmitShape
            visible: false
            source: partEmitShapeImage

        }
    }

    Texture {
        textureUnit: 3
        textureRT: "depth"
    }

    //    Texture {
    //        textureUnit: 2
    //        textureRT: "screenBuffer"
    //    }

//    Texture {
//        textureUnit: 3
//        textureItem: particleEnv
//        Image {
//            id: particleEnv
//            visible: false
//            source: "../../images/Bright-roof-multi.jpg"
//        }
//    }


    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------

    property string shaderVaryings: "
        vec3 posG;
        vec2 uvG;
        vec3 velG;
        float ageG;
        float recG;
        float ageSplitG;
        vec4 posInitG;"
       // vec3 posScrG;"


    Shader {
        file: simShader
        tfVaryings: shaderVaryings
    }


    DrawVB {
        id: advanceSim
        enabled: true
        type: "pointGrid"
        vboId: sceneName+name

        property real resetOn: sync(partSim.name+".reset")

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
            } else {
                reset = 0.0;
            }
        }

        onParticleCountChanged: {
            // console.log("jorma particle count:"+particleCount);
            particleCountTo(particleCount);
        }


        tfVaryings: shaderVaryings

        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_gridDim"
            paramValue: partSim.gridDimension
        }
//        ShaderParam {
//            paramName: "g_rotOrigin"
//            paramValue: sync(partSim.name+".rotOrigin")
//        }

        ShaderParam {
            paramName: "g_velDamping"
            paramValue: sync(partSim.name+".velDamping")
        }

//        ShaderParam {
//            paramName: "g_emitShape"
//            paramValue: sync(partSim.name+".emitShape")
//        }

        ShaderParam {
            paramName: "g_noiseScale"
            paramValueVec4: sync(partSim.forceName+".noiseScale.x")+","+sync(partSim.forceName+".noiseScale.y")+","+sync(partSim.forceName+".noiseScale.z")
        }
        ShaderParam {
            paramName: "g_noiseOfs"
            paramValueVec4: sync(partSim.name+".dirForce.x")+","+sync(partSim.name+".dirForce.y")+","+sync(partSim.name+".dirForce.z")
        }

        ShaderParam {
            paramName: "g_force"
            paramValue: sync(partSim.forceName+".force")
        }
        ShaderParam {
            paramName: "g_noiseFreq"
            paramValue: sync(partSim.forceName+".noiseFreq")
        }
        ShaderParam {
            paramName: "g_speed"
            paramValue: sync(partSim.forceName+".speed")
        }

//        ShaderParam {
//            paramName: "g_initShapeX"
//            paramValue: sync(partSim.name+".initShapeX")
//        }
//        ShaderParam {
//            paramName: "g_initShapeY"
//            paramValue: sync(partSim.name+".initShapeY")
//        }
        ShaderParam {
            paramName: "g_maxAge"
            paramValue: sync(partSim.name+".maxAge")
        }
//        ShaderParam {
//            paramName: "g_initPosX"
//            paramValue: sync(partSim.name+".initPosX")
//        }
//        ShaderParam {
//            paramName: "g_initPosY"
//            paramValue: sync(partSim.name+".initPosY")
//        }
//        ShaderParam {
//            paramName: "g_initPosZ"
//            paramValue: sync(partSim.name+".initPosZ")
//        }

        ShaderParam { paramName: "g_elasticity"; paramValue: sync(partSim.name+".elasticity") }
        ShaderParam { paramName: "g_splitRandom"; paramValue: sync(partSim.name+".splitRandom") }
        ShaderParam { paramName: "g_splitNormal"; paramValue: sync(partSim.name+".splitNormal") }
        ShaderParam { paramName: "g_splitOnHitDiv"; paramValue: sync(partSim.name+".splitDiv") }


        ShaderParam {
            paramName: "g_radForcePos"
            paramValueVec4: sync(partSim.forceName+".radForce.x")+","+sync(partSim.forceName+".radForce.y")+","+sync(partSim.forceName+".radForce.z")
        }
        ShaderParam { paramName: "g_radForceAmp"; paramValue: sync(partSim.forceName+".radForce.amp") }
        ShaderParam { paramName: "g_radForceDistDamp"; paramValue: sync(partSim.forceName+".radForce.distDamp") }

        ShaderParam {
            paramName: "g_radForce2Pos"
            paramValueVec4: sync(partSim.forceName+".radForce2.x")+","+sync(partSim.forceName+".radForce2.y")+","+sync(partSim.forceName+".radForce2.z")
        }
        ShaderParam { paramName: "g_radForce2Amp"; paramValue: sync(partSim.forceName+".radForce2.amp") }
        ShaderParam { paramName: "g_radForce2DistDamp"; paramValue: sync(partSim.forceName+".radForce2.distDamp") }

        ShaderParam {
            paramName: "g_zoomPos"
            paramValueVec4: sync(partSim.forceName+".zoomPos.x")+","+sync(partSim.forceName+".zoomPos.y")+","+sync(partSim.forceName+".zoomPos.z")
        }
        ShaderParam { paramName: "g_zoom"; paramValue: sync(partSim.forceName+".zoom") }

        ShaderParam { paramName: "g_collisionDist"; paramValue: sync(partSim.forceName+".collisionDist")+0.5 }



        //uniform vec4 g_radForcePos = vec4(0.0, 0.0, 0.0, 0.0);
        //uniform float g_radForceAmp = 0.0;
        //uniform float g_radForceDistDamp = 0.0;

    }


    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: drawShader
    }
    DrawVB {
        enabled: drawEnabled
        type: "pointGridDraw"
        property string name: partSim.name
        vboId: sceneName+name
        depthTest: true
        depthWrite: false

       // blendMode: "normal"
        blendMode: drawBlendMode
       // blendMode: "off"

        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }
        ShaderParam {
            paramName: "g_partMapX"
            paramValue: sync(partSim.name+".partMapX")
        }
        ShaderParam {
            paramName: "g_partMapY"
            paramValue: sync(partSim.name+".partMapY")
        }
        ShaderParam {
            paramName: "g_partMapWX"
            paramValue: sync(partSim.name+".partMapWX")
        }
        ShaderParam { paramName: "g_partAlpha"; paramValue: sync(partSim.name+".alpha") }

        ShaderParam {
            paramName: "g_maxAge"
            paramValue: sync(partSim.name+".maxAge")
        }

        ShaderParam { paramName: "g_vilkeFreq"; paramValue: sync(partSim.name+".vilkeFreq") }
        ShaderParam { paramName: "g_vilkeAmp"; paramValue: sync(partSim.name+".vilkeAmp") }
        ShaderParam { paramName: "g_fadeInSpeed"; paramValue: sync(partSim.name+".fadeInSpeed") }
        ShaderParam { paramName: "g_fadeOutSpeed"; paramValue: sync(partSim.name+".fadeOutSpeed") }
        ShaderParam { paramName: "g_alkuRotate"; paramValue: sync(partSim.name+".alkuRotate") }
        ShaderParam { paramName: "g_rotateSpeed"; paramValue: sync(partSim.name+".rotateSpeed") }

        drawBuffers: 2
    }

    Shader {
        file: "partDepthOnly"
    }
    DrawVB { // depth only draw
        enabled: drawEnabled && (sync(partSim.name+".depthDraw")>0.5)
        type: "pointGridDraw"
        property string name: partSim.name
        vboId: sceneName+name
        depthTest: true
        depthWrite: true
       // blendMode: "normal"
        blendMode: "add"
       // blendMode: "off"
        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }
        ShaderParam {
            paramName: "g_partMapX"
            paramValue: sync(partSim.name+".partMapX")
        }
        ShaderParam {
            paramName: "g_partMapY"
            paramValue: sync(partSim.name+".partMapY")
        }
        ShaderParam {
            paramName: "g_partMapWX"
            paramValue: sync(partSim.name+".partMapWX")
        }
        ShaderParam { paramName: "g_partAlpha"; paramValue: sync(partSim.name+".alpha") }

        drawBuffers: 1
    }

//    DrawVB {
//        enabled: false
//        type: "pointGridDraw"
//        property string name: partSim.name
//        vboId: sceneName+name
//        depthTest: true
//        depthWrite: true

//        blendMode: "add"
//       // blendMode: "add"

//        tfVaryings: shaderVaryings
//        gridWidth: partSim.gridDimension
//        gridHeight: partSim.gridDimension
//        drawNumPoints: partSim.drawNumPoints

////        ShaderParam {
////            paramName: "g_pikselos"
////            paramValue: sync("pikselos")
////        }
//        ShaderParam {
//            paramName: "g_partSize"
//            paramValue: partSize
//        }
////        ShaderParam {
////            paramName: "g_partMapX"
////            paramValue: sync(partSim.name+".partMapX")
////        }
////        ShaderParam {
////            paramName: "g_partMapY"
////            paramValue: sync(partSim.name+".partMapY")
////        }
//    }
}
