import QtQuick 2.4
import QtGraphicalEffects 1.0
import "./_SharedQML"
import AdaptDemoSystem 1.0

import QtQuick.Window 2.2
import Qt.labs.settings 1.0
import QtQuick.Dialogs 1.0


RocketDemo {
    id: demo

    focus: true

    signal fileMissing(string fName, string sName)


    onFirstDemoRender: {
        console.log("YES first demo rendered now!!!");
        ackFirstDemoRender();
    }

    anchors.fill: parent

    property bool demoLoaded: false

    Connections {
        target: root
        onDemoLoaded: {
//            if (editorLoader.item) {
//                editorLoader.item.demoLoaded();
//            }
            demoLoaded = true;
//            if (editorLoader.item) {
//                editorLoader.item.demoLoaded();
//            }
        }
        onShowEditor: {
            skeneEditorWindow.enabled = true;
            skeneEditorWindow.loadEditor();
        }
    }

    Window {
        id: skeneEditorWindow
        title: "Skene editor"
        x: 10
        y: 24
        width: 1024
        height: 720
        property bool enabled: false
        visible: enabled && !rocket.getFullScreen();

        property string choosePath: "[Choose editor..]"
        property string editorPath: choosePath
        property string editorFolder
        property string importPath

        function loadEditor() {
            if (editorPath !== choosePath && enabled) {
                importPath = editorFolder+"/plugins";
                importPath = importPath.replace(/^(file:\/{3})/,"");
                //console.log("adding import path:"+importPath);
                demo.addImportPath(importPath);
                editorLoader.source = editorPath;
            }
        }

        onEditorPathChanged: {
            loadEditor();
        }

        Settings {
            id: editorSettings
            property alias x: skeneEditorWindow.x
            property alias y: skeneEditorWindow.y
            property alias width: skeneEditorWindow.width
            property alias height: skeneEditorWindow.height
            property alias editorFolder: skeneEditorWindow.editorFolder
            property alias editorPath: skeneEditorWindow.editorPath
            property alias importPath: skeneEditorWindow.importPath
        }

        Rectangle {
            anchors.fill: parent
            color: "white"
        }

        FileDialog {
            id: editorFileDialog
            title: "Please choose a SkeneEditor.qml file"
            folder: skeneEditorWindow.editorFolder
            nameFilters: ["SkeneEditor.qml file (SkeneEditor.qml)"]
            onAccepted: {
                var path = editorFileDialog.fileUrl.toString();
                skeneEditorWindow.editorFolder = folder;
                skeneEditorWindow.editorPath = path;
            }
        }

        Loader {
            id: editorLoader
          //  source: skeneEditorWindow.editorPath
            anchors.fill: parent
            property bool underRealDemo: true
            property string sceneName: item ? item.getSkeneName() : ""

            property string editorPath: skeneEditorWindow.editorPath

            onEditorPathChanged: {
                skeneEditorWindow.editorPath = editorPath
            }

            function sync(track) {
                if (sceneName === "") {
                    return 0.0;
                } else {
                    return syncRocketRoot(sceneName+"."+track)
                }
            }
            onStatusChanged: {
                if (status === Loader.Error) {

                }
                if (status === Loader.Ready) {
                    if (demoLoaded) {
                        editorLoader.item.demoLoaded();
                    }
                }
            }
        }


//        SkeneEditor {
//            id: editor
//            anchors.fill: parent
//            property bool underRealDemo: true
//            property string sceneName: getSkeneName()
//            function sync(track) {
//                if (editor.sceneName === "") {
//                    return 0.0;
//                } else {
//                    return syncRocketRoot(sceneName+"."+track)
//                }
//            }
//        }

        Rectangle {
            id: header
            opacity: 0.5
            anchors.top: parent.top
            anchors.left: parent.left
            anchors.right: parent.right
            height: 80
            color: "black"
            clip: true
        }

        Row {
            anchors.right: header.right
            anchors.rightMargin: 5
            anchors.verticalCenter: header.verticalCenter
            Item {
                id: changeEditor
                width: changeEditorText.width+5
                height: changeEditorText.height+5
                anchors.verticalCenter: parent.verticalCenter

                Rectangle {
                    color: "grey"
                    radius: 3
                    anchors.fill: changeEditor
                }

                Text {
                    id: changeEditorText
                    width: contentWidth
                    height: contentHeight
                    anchors.centerIn: parent
                    text: "CHANGE<br>EDITOR"
                    font.pixelSize: 12
                    color: "black"

                }

                MouseArea {
                    anchors.fill: parent
                    hoverEnabled: true
                    onEntered: {
                      //  showHoverInfoText("<b>Left Click</b> - select editor<br>Editor: "+editorPath);
                    }

                    onClicked: {
                        editorFileDialog.open();
                    }
                }
            }
        }

        Text {
            font.pixelSize: 24
            text: "<b>Skene Editor</b>"
            color: "white"
            anchors.top: parent.top
            anchors.margins: 10
            anchors.horizontalCenter: parent.horizontalCenter
        }


        Rectangle {
            id: selectIniitalEditor
            visible: skeneEditorWindow.editorPath === skeneEditorWindow.choosePath
            anchors.centerIn: parent
            width: selectEditorText.width+20
            height: selectEditorText.height+20
            color: "white"
            Text {
                id: selectEditorText
                text: skeneEditorWindow.editorPath
                width: contentWidth
                height: contentHeight
                anchors.centerIn: parent
                font.pixelSize: 18
                color: "black"
                MouseArea {
                    anchors.fill: parent
                    enabled: selectIniitalEditor.visible
                    onClicked: {
                        editorFileDialog.open();
                    }
                }
            }
        }
    }

//    DebugInfoOverDemo {
//    }

    property string windowText

    Component {
        id: kurko
        Window {
            width: 300
            height: 250
            visible: true

            Text {
                anchors.fill: parent
                text: demo.windowText
                font.pixelSize: 15
                wrapMode: Text.WordWrap
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter
            }
        }
    }

//    Window {
//        width: 200
//        height: 200
//        visible: true
//    }

    Loader {
        id: windowLoader

    }

    onFileNotFound: {
        console.log("QML Skene received file not found:"+fileName+" skene:"+skeneName);

        demo.windowText = "<b>ERROR!!!!</b><br><br>QML Skene received file not found.<br><br>File:"+fileName+"<br>skene:"+skeneName;

        windowLoader.sourceComponent = kurko;
        fileMissing(fileName, skeneName);
    }

    onFrameRendered: {
        demo.clearResetParticles();
        //console.log("no ny tee poika resetti");
    }



}
