import QtQuick 2.3

Rectangle {
    id: scrollbar
    // anchors.right: parent.right
    anchors.top: effectsContainer.top
    anchors.left: parent.left
    anchors.leftMargin: 310
    width: 20
    color: "white"

    property real scrollPos: 0.0
    property real scrollRatio: 0.5

    Rectangle {
        color: "grey"
        anchors.left: parent.left
        anchors.right: parent.right
        height: (parent.height-4)*parent.scrollRatio
        y: 2+parent.scrollPos*((parent.height-4)*(1.0-parent.scrollRatio))
        anchors.margins: 2
    }

    MouseArea {
        anchors.fill: parent

        property int mouseOnPressX: 0
        property int mouseOnPressY: 0

        property real scrollPosOnSelect: 0.0

        property bool bEditingScroll: false

        onPressedChanged: {
            if (pressed) {
                console.log("mouse pressed on scrollbar")
                mouseOnPressX = mouseX;
                mouseOnPressY = mouseY;
                scrollPosOnSelect = scrollbar.scrollPos;
                console.log("scrollPosOnSelect:"+scrollPosOnSelect)
                bEditingScroll = true;
            } else {
                bEditingScroll = false;
            }
        }
        onMouseYChanged: {
            if (bEditingScroll) {
                var newScrollPos = scrollPosOnSelect+((mouseY-mouseOnPressY))/((parent.height*(1.0-scrollbar.scrollRatio)));
                if (newScrollPos <= 0.0) {
                    newScrollPos = 0.0;
                    // effects.contentY = 0;
                }
                if (newScrollPos > 1.0) {
                    newScrollPos = 1.0;
                }
                scrollbar.scrollPos = newScrollPos;
                //console.log("scrollbar.scrollPos:"+scrollbar.scrollPos)
            }
            rocket.markUpdateFrequent()
        }
    }
}


