

import pygame, random


def main(clock, MAX_X, MAX_Y, screen):
    very_done = False
    slow_freq = 3
    BLACK = (0, 0, 0)
    WHITE = (255, 255, 255)
    GOLD = (220,200,0)
    Hat = 0

    # gold starting point
    pygame.Surface.fill(screen, GOLD)
    pygame.display.flip()

    HorizontalPrimes = list(range(1, MAX_Y))
    VerticalPrimes = list(range(1, MAX_X))

    #delete horizontal deletables
    current_prime_index = 1
    used_slow_freq = slow_freq
    slower = 0
    while current_prime_index < len(HorizontalPrimes) and not very_done:  # this will be an off-by-1 error
        slower += 1
        clock.tick(50)
        for event in pygame.event.get():
            if event.type == pygame.KEYDOWN:
                very_done = True
                break

        if slower%used_slow_freq == 0:
            current_divisor = HorizontalPrimes[current_prime_index]
            if current_divisor > MAX_Y / 10: used_slow_freq = 1
            last_to_kill = int(MAX_Y/current_divisor) #this is probably right
            for i in range(2, last_to_kill):
                #print(current_divisor)
                kill_line = i * current_divisor
                if kill_line in HorizontalPrimes:
                    HorizontalPrimes.remove(kill_line)
                    pygame.draw.line(screen, BLACK, (0, kill_line), (MAX_X, kill_line))
                    pygame.display.flip()
            current_prime_index += 1

    #delete vertical deletables
    used_slow_freq = slow_freq
    current_prime_index = 1
    while current_prime_index < len(VerticalPrimes) and not very_done:  # this will be an off-by-1 error
        slower += 1
        clock.tick(50)
        for event in pygame.event.get():
            if event.type == pygame.KEYDOWN:
                very_done = True
                break

        if slower%used_slow_freq == 0:
            current_divisor = VerticalPrimes[current_prime_index]
            if current_divisor > MAX_X / 10: used_slow_freq = 1
            last_to_kill = int(MAX_X / current_divisor)  # this is probably right
            for i in range(2, last_to_kill):
                #print(current_divisor)
                kill_line = i * current_divisor
                if kill_line in VerticalPrimes:
                    VerticalPrimes.remove(kill_line)
                    pygame.draw.line(screen, BLACK, (kill_line,0), (kill_line,MAX_Y))
                    pygame.display.flip()
            current_prime_index += 1

    # 8: [(3,5),(5,3),(1,7),(7,1)]
    PrimePairDict = {}
    for i in range(len(HorizontalPrimes)):
        hprime = HorizontalPrimes[i]
        for j in range(len(VerticalPrimes)):
            vprime = VerticalPrimes[j]
            prime_pair = (vprime, hprime)
            pair_index = hprime + vprime
            if pair_index in PrimePairDict:
                PrimePairDict[pair_index] = PrimePairDict[pair_index] + [prime_pair]
            else:
                PrimePairDict[pair_index] = [prime_pair]
    #print(PrimePairDict)


    i = 4
    its_sunny = True
    rainpoint = (0,0)
    brightness = random.randint(50,250)
    color = (0, 0, brightness)
    slow_freq = 1
    while its_sunny and not very_done:
        slower += 1
        clock.tick(50)
        for event in pygame.event.get():
            if event.type == pygame.KEYDOWN:
                very_done = True
                break

        if slower%slow_freq == 0:
            if i in PrimePairDict: #it might run off screen
                NextSteps = PrimePairDict[i]
                j = random.randint(0, len(NextSteps)-1)
                (oldx, oldy) = rainpoint
                (newx, newy) = NextSteps[j]
                pygame.draw.line(screen, (0,0,255), (oldx, oldy), (newx, newy))
                rainpoint = (newx, newy)
                pygame.display.flip()
                i = i+2
            else:
                its_sunny = False

    return HorizontalPrimes, very_done
