#include <Arduino.h>
#line 1 "D:\\src\\esp32\\compositeArduino\\compositeArduino.ino"
#include <dummy.h>

//code by bitluni give me a shout-out if you like it

#include <soc/rtc.h>
#include "Graphics.h"
#include "Image.h"
#include "SimplePALOutput.h"
#include "Sprites.h"
#include "Font.h"
#include "farjan.ACT.h"
#include "picopng.h"
#include "laiva.png.h"
#include "sun.png.h"

//lincude graphics and sounds
namespace font88
{
#include "gfx/font.h"
}
Font font(8, 8, font88::pixels);
#include "gfx/texture.h"
//#include "sfx/music.h"



///////////////////////////
//Video configuration
//PAL MAX, half: 324x268 full: 648x536
//NTSC MAX, half: 324x224 full: 648x448
const int XRES = 320;
//const int YRES = 144;
const int YRES = 240;
Graphics graphics(XRES, YRES);
SimplePALOutput composite;


void compositeCore(void *data)
{
  while (true)
  {
    for(int i = 0; i < 121; i++)
    {
      composite.sendFrame(&graphics.frame);
    }
  }
}
void MusicCore(void *data)
{
  while (true)
  {
   // vgmPlayer.update();
    loop();
  }
}


int sintab[256];
int costab[256];

unsigned long lastTime;
image_t laiva;
image_t sun;
unsigned int palette[256]; 
const char* scroller = "This is first demo for JumaCo v1.0 computer. Finlandsfarjan is the new benchmark for new devices. Step a side doom! Jumalauta is 20 years old and we want 20 more years..20 more years...20 more years...";
void setup()
{
  rtc_clk_cpu_freq_set(RTC_CPU_FREQ_240M);              //highest cpu frequency

  //initialize composite output and graphics
  composite.init();
  graphics.init();
  graphics.setFont(font);
  xTaskCreatePinnedToCore(compositeCore, "c", 1024, NULL, 1, NULL, 0);



  for(int i = 0; i < 256; i++)
  {
    sintab[i] = int(sin(i / 256.f * M_PI) * 256);
    costab[i] = int(cos(i / 256.f * M_PI) * 80 * 256);
  }
  //
 // Init();
 for(int i = 0; i < 256; i++)
 {
  palette[i] = graphics.rgb(farjan_ACT[i*3], farjan_ACT[i*3+1], farjan_ACT[i*3+2]);
 }
loadImage(laiva_png, laiva, 2077);
loadImage(sun_png, sun, 1803);
lastTime = millis();

}


void loop()
{

//vgmPlayer.update();
  //return;
  graphics.begin(0);
  //draw some sprites
  int t = millis();

  unsigned long timeNow = millis();
  int dt = timeNow - lastTime;
  lastTime = timeNow;
//  if(dt > 10000)
 //   DrawFrame(dt);
    const char* jumaco = "JumaCo";

    graphics.fillRect(0,0, 320, 100, palette[9]); // sky 
   
    for(int y = 0; y < 50; y++)
    {
      for(int x = 0; x < 50; x++)
      {
        if(sun.data[x+y*50] < 0xff)
        {

          graphics.dotFast(270+x,y,graphics.rgb(255, 255, 255));
        }
      }      
    }
    


    graphics.fillRect(0,100, 320, 50, palette[16]); // land
   // graphics.fillRect(0,130, 320, 180, palette[10]); // water
    float laivaPosition = t/600;
    int laivaYPosition = 85+(int)((sin(t*0.001)+1.0f)*5);
    if(t > 51000)
    {
      laivaYPosition+=(t-51000)/200;
    }

    for(int y = 0; y < 50; y++)
    {
      for(int x = 0; x < 100; x++)
      {
        if(laiva.data[x+y*100] < 0xff)
        {

          graphics.dotFast(x+laivaPosition,y+laivaYPosition,palette[laiva.data[x+y*100]]);
        }
      }      
    }
    for(int i = 0; i < 320; i++)
    {
      int yStart = 130+(int)(sin(i*0.15f+t*0.001f)*7); 
      graphics.line(i, yStart, i, 400-yStart, palette[10]);
    
    }
      
   for(int i = 0; i<1; i++ )
   {
   // graphics.setCursor(180+i*8, sin(timeNow/1000.0f+i*0.2f)*30+160);
  //  graphics.setTextColor(graphics.rgb(255,255,255));


    //graphics.print(jumaco);
   }

        graphics.setCursor(180, 180);
 //   graphics.setTextColor(graphics.rgb(255,255,255));

    for(int i = 0; i < 201; i++)
    {
      int sx = 330+i*8-t/30;
      graphics.setCursor(sx, 180);
      if(sx <310 && sx > 8)
      {
        graphics.printx(scroller[i]);
      }
    }
    
    graphics.end();   

  if(t > 65000)
  {
    ESP.restart();
  }
  /*
  int rot = t / 100;
  int lightpos = min(t / 78, 256);
  int flare1 = min(t / 10, 256);
  int flare2 = min((t - 120 * 78) / 5, 256);
  for(int y = 0; y < 128; y++)
  {
    int vy = y - (lightpos >> 2) + 64;
    if(vy >= 0 && vy < 240)
      for(int x = 0; x < 128; x++)
      {
        int c = (((texture.get(1, x * 2, y * 2) & 15 ) * flare1) >> 8) | 0x80;
        graphics.backbuffer[vy][x + 32 + 64] = c;
      }
  }
  for(int y = 255; y >= 0; y--)
  {
    int light = lightpos - 256 + y;
    if(light > 256)
      light = 256;
    for(int x = 0; x < 256; x++)
    {
      int vx = (costab[x] >> 8) + 160;
      int vy = ((sintab[x] * costab[y]) >> 16) + 180;
      if(vy >= 240) continue;
      if(light <= 0)
        graphics.dotFast(vx, vy, graphics.rgb(0, 0, 0));
      else
      {
          int c = texture.get(0, 256 - x, (-rot - y) & 511);
          int r = (light * (c & 15)) >> 4;
          int g = (light * ((c >> 4) & 15)) >> 4;
          int b = (light * ((c >> 8) & 15)) >> 4;
          graphics.dotFast(vx, vy, graphics.rgb(r, g, b));
      }
    }
  }
  if(lightpos > 120)
  for(int y = 0; y < 256; y++)
  {
    int vy = y - (lightpos >> 2);
    if(vy >= 0 && vy < 240)
      for(int x = 0; x < 256; x++)
      {
        int c = (((texture.get(1, x, y) & 15 ) * flare2) >> 8);
        unsigned short oc = graphics.backbuffer[vy][x + 32];
        c += (oc & 15);
        if(c > 15) c = 15;
        graphics.backbuffer[vy][x + 32] = (oc & 0xf0) + c;
      }
  }  

  int ttext = (t - 30000)/100;
  if(ttext > 0)
  {
    char *text0 = "Greetings from bitluni's lab!";
    char text[32];
    int i = 0;
    for(; i < ttext && i < 32; i++)
    {
      text[i] = text0[i];
      if(!text[i]) break;
    }
    text[i] = 0;
    graphics.setCursor(160 - 4 * i, 16);
    graphics.setTextColor(graphics.rgb(255, 255, 255));
    graphics.print(text);
  }
  */

  
}

