#include <Adafruit_SI5351.h>
#include "music.h"
float singleSampleWait = 0;
const float WAIT60TH = 1000 / (44100/735);
const float WAIT50TH = 1000 / (44100/882);

Adafruit_SI5351 clockgen = Adafruit_SI5351();

const int latchPin = 19; // RCLK
const int clockPin =18; //SRCLK
const int dataPin = 23;//SER
const int WE = 27;


class VGMPlayer
{

	unsigned long parseLocation = 64; //Where we're currently looking in the music_data array. (64 = 0x40 = start of VGM music data)
uint32_t lastWaitData = 0;
float cachedWaitTime = 0;
public:
	VGMPlayer()
	{
	  Serial.begin(9600);
	  Serial.println("Si5351 Clockgen Test"); Serial.println("");
	  
	  /* Initialise the sensor */
	  if (clockgen.begin() != ERROR_NONE)
	  {
	    /* There was a problem detecting the IC ... check your connections */
	    Serial.print("Ooops, no Si5351 detected ... Check your wiring or I2C ADDR!");
	    while(1);
	  }
	  Serial.println("OK!");

	 // Set pll A to 601,363560000MHZ
	 clockgen.setupPLL(SI5351_PLL_A, 29, 247, 250);
	 // Set pll B to 699,244900000MHZ
	 clockgen.setupPLL(SI5351_PLL_A, 27, 242449, 250000);
	  
	  
	  Serial.println("Set Output #0 to 7,600489000MHz");  
	  clockgen.setupMultisynth(2, SI5351_PLL_B, 91, 1, 1);

	  Serial.println("Set Output #2 to 3,579545000MHz");  
	  clockgen.setupMultisynth(0, SI5351_PLL_A, 195, 1, 1);


	  /* Enable the clocks */
	  clockgen.enableOutputs(true);

	 // pinMode(clearShift, OUTPUT);
	  //digitalWrite(clearShift, LOW);
	 // delay(50);
	 // digitalWrite(clearShift, HIGH);
	  pinMode(latchPin, OUTPUT);
	  pinMode(clockPin, OUTPUT);
	  pinMode(dataPin, OUTPUT);

	    //Setup SN
	  pinMode(WE, OUTPUT);
	  digitalWrite(WE, HIGH);
	  delay(500);
	  SilenceAllChannels();
	  delay(500);
	 SilenceAllChannels();  
	}
	void SendSNByte(byte b)
{
	  digitalWrite(WE, HIGH);
  digitalWrite(latchPin, LOW);
  shiftOut(dataPin, clockPin, LSBFIRST, b);   
  digitalWrite(latchPin, HIGH);
  digitalWrite(WE, LOW);
  delayMicroseconds(10);
  digitalWrite(WE, HIGH);
}//Send 1-byte of data to PSG
void SilenceAllChannels()
{
	  SendSNByte(0x9f);
  SendSNByte(0xbf);
  SendSNByte(0xdf);
  SendSNByte(0xff);
}
public:
	 void update()
	{
		    switch(music_data[parseLocation]) //Use this switch statement to parse VGM commands
  {
    case 0x50:
    parseLocation++;
    SendSNByte(music_data[parseLocation]);
    break;
    case 0x61: 
    {
    uint32_t wait = 0;
    parseLocation++;
    for ( int i = 0; i < 2; i++ ) 
    {
      wait += ( uint32_t( music_data[parseLocation])  << ( 8 * i ));
      parseLocation++;
    }
    if(lastWaitData != wait) //Avoid doing lots of unnecessary division.
    {
      lastWaitData = wait;
      cachedWaitTime = 1000/(44100/wait);
    }
    delay(cachedWaitTime);
    break;
    }
    case 0x62:
    delay(WAIT60TH); //Actual time is 16.67ms (1/60 of a second)
    break;
    case 0x63:
    delay(WAIT50TH); //Actual time is 20ms (1/50 of a second)
    break;
    case 0x70:
    case 0x71:
    case 0x72:
    case 0x73:
    case 0x74:
    case 0x75:
    case 0x76:
    case 0x77:
    case 0x78:
    case 0x79:
    case 0x7A:
    case 0x7B:
    case 0x7C:
    case 0x7D:
    case 0x7E:
    case 0x7F: 
    {
      uint32_t wait = music_data[parseLocation] & 0x0F;
      delay(1000/(44100/wait));
    break;
    }
    case 0x66:
    parseLocation = 64;
    break;
  }
  parseLocation++;
  if (parseLocation == music_length)
  {
    parseLocation = 64;
  }
	}
}