var Glitch = function(){
    PartBase.call(this);

    
    this.setEdgeDetection();
    /*this.setDoF({
        focus: 0.8,
        maxblur: 1.25,
        aparture: 0.0025
    });*/
    this.setBloom(2.8);

    //this.scene.fog = new THREE.Fog(0xFF1111, 0.01, 600);

    this.texture = TDEMO.TEXTURES.getTextures().varma;

    this.sphere = this.createGeometry();
    this.sphere.rotation.x = Math.PI/2;
    this.scene.add(this.sphere);
}

Glitch.prototype = PartBase.prototype.inheritance();

Glitch.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var hb = TDEMO.SYNC.getHeartBeat();
    this.sphere.morphTargetInfluences[0] = hb;

    var offset = TDEMO.SYNC.getObjPosition();
    this.texture.offset.x = offset.x;
    this.texture.offset.y = offset.y;
    this.texture.needsUpdate = true;
}

Glitch.prototype.createGeometry = function(){
    var morphGeo = new THREE.BoxGeometry(512, 120, 120, 32, 32, 32);
    var geometry = new THREE.SphereGeometry(512, 64, 64);
    geometry.morphTargets.push({
        name : "sphere",
        vertices : morphGeo.vertices,
        side : THREE.DoubleSide
    });

    var material = new THREE.MeshBasicMaterial({
        map: TDEMO.TEXTURES.getTextures().varma,
        morphTargets : true
    });

    return new THREE.Mesh(geometry, material);
};
