#version 330 core

in vec2 texCoord;
out vec4 fragColor;

uniform sampler2D texture0; 
uniform sampler2D texture1; // fft

uniform float intensity = 4.0;
uniform float zoom = 4.0;

uniform vec3 iResolution;

uniform vec4 color = vec4(1);

uniform float fftHistory = 16.0;

uniform float sunThreshold = 0.0;


//BG_SPIRAL uniforms
uniform float curveThickness = 0.6;
uniform float curveBendDegrees = 180;
uniform float curvesDegrees = 90;

uniform float iTime = 1.0;
uniform float speed = 0.1;
uniform float fade = 0.1;
uniform vec2 position = vec2(-0.5, -0.5);
uniform vec4 backgroundColor = vec4(0,0,0,0);

void main()
{

        vec2 coord = (texCoord.yx-vec2(.5,.5))/vec2(iResolution.z,1.0)/zoom;

        float r = length(coord);

        float c = 0.0;
        for (int i = 0; i < fftHistory; i++) {
            float percent = i/fftHistory;
            c = mix(0.0, 1.0, texture2D(texture1, vec2(r,percent)).r*intensity*(percent));
        }

    float time = iTime * speed;

    float x = coord.x;
    float y = coord.y;
    float d = sqrt(x*x + y*y);

    vec4 color1 = backgroundColor;

    // Horizontal bars

    float mval = 0.0;
    float mvalDecay = 0.0;
    float mavg = 0.0;
    float mcur = texture2D(texture1, vec2(texCoord.x, 1.0)).r;

        coord += position;
        float curveBendRad = radians(curveBendDegrees);
        float curvesRad = radians(curvesDegrees);
        float bend = curveBendRad*log(length(coord));
        d = mod((time*2.5)+atan(coord.x,coord.y)+bend, curvesRad);
        if (d < curvesRad*curveThickness)
        {
            float cx = position.x+x;
            float cy = position.y+y;
            float circle = 1.0/sqrt(cx*cx + cy*cy);

            float d2 = 0;
            float size = 1.5-sqrt(cx*cx + cy*cy)*(10*sin(time*5.5));
            d2 = sin(sqrt(x*x)*80)*1.5*size+cos(sqrt(y*y)*80)*1.2*size;
            d += 0.15*d2;

            color1 = vec4(1-d*0.1);
            color1.a *= 0.15;
            //color1 = vec4(1);
        fragColor = mix(color1,vec4(1.0),vec4(vec3(c-r),c*1.0))*color;
        fragColor.a=fragColor.r;

        }

    //if (fragColor.r <= sunThreshold) {
        //circle visualization

    //}
}
